/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.services.licensemanager.model.OrganizationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetServiceSettingsResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, GetServiceSettingsResponse> {
    private static final SdkField<String> S3_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetServiceSettingsResponse.getter(GetServiceSettingsResponse::s3BucketArn)).setter(GetServiceSettingsResponse.setter(Builder::s3BucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketArn").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetServiceSettingsResponse.getter(GetServiceSettingsResponse::snsTopicArn)).setter(GetServiceSettingsResponse.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()}).build();
    private static final SdkField<OrganizationConfiguration> ORGANIZATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetServiceSettingsResponse.getter(GetServiceSettingsResponse::organizationConfiguration)).setter(GetServiceSettingsResponse.setter(Builder::organizationConfiguration)).constructor(OrganizationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfiguration").build()}).build();
    private static final SdkField<Boolean> ENABLE_CROSS_ACCOUNTS_DISCOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(GetServiceSettingsResponse.getter(GetServiceSettingsResponse::enableCrossAccountsDiscovery)).setter(GetServiceSettingsResponse.setter(Builder::enableCrossAccountsDiscovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCrossAccountsDiscovery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_ARN_FIELD, SNS_TOPIC_ARN_FIELD, ORGANIZATION_CONFIGURATION_FIELD, ENABLE_CROSS_ACCOUNTS_DISCOVERY_FIELD));
    private final String s3BucketArn;
    private final String snsTopicArn;
    private final OrganizationConfiguration organizationConfiguration;
    private final Boolean enableCrossAccountsDiscovery;

    private GetServiceSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.s3BucketArn = builder.s3BucketArn;
        this.snsTopicArn = builder.snsTopicArn;
        this.organizationConfiguration = builder.organizationConfiguration;
        this.enableCrossAccountsDiscovery = builder.enableCrossAccountsDiscovery;
    }

    public String s3BucketArn() {
        return this.s3BucketArn;
    }

    public String snsTopicArn() {
        return this.snsTopicArn;
    }

    public OrganizationConfiguration organizationConfiguration() {
        return this.organizationConfiguration;
    }

    public Boolean enableCrossAccountsDiscovery() {
        return this.enableCrossAccountsDiscovery;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableCrossAccountsDiscovery());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceSettingsResponse)) {
            return false;
        }
        GetServiceSettingsResponse other = (GetServiceSettingsResponse)((Object)obj);
        return Objects.equals(this.s3BucketArn(), other.s3BucketArn()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.organizationConfiguration(), other.organizationConfiguration()) && Objects.equals(this.enableCrossAccountsDiscovery(), other.enableCrossAccountsDiscovery());
    }

    public String toString() {
        return ToString.builder((String)"GetServiceSettingsResponse").add("S3BucketArn", (Object)this.s3BucketArn()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("OrganizationConfiguration", (Object)this.organizationConfiguration()).add("EnableCrossAccountsDiscovery", (Object)this.enableCrossAccountsDiscovery()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3BucketArn": {
                return Optional.ofNullable(clazz.cast(this.s3BucketArn()));
            }
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "OrganizationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.organizationConfiguration()));
            }
            case "EnableCrossAccountsDiscovery": {
                return Optional.ofNullable(clazz.cast(this.enableCrossAccountsDiscovery()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceSettingsResponse, T> g) {
        return obj -> g.apply((GetServiceSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private String s3BucketArn;
        private String snsTopicArn;
        private OrganizationConfiguration organizationConfiguration;
        private Boolean enableCrossAccountsDiscovery;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceSettingsResponse model) {
            super(model);
            this.s3BucketArn(model.s3BucketArn);
            this.snsTopicArn(model.snsTopicArn);
            this.organizationConfiguration(model.organizationConfiguration);
            this.enableCrossAccountsDiscovery(model.enableCrossAccountsDiscovery);
        }

        public final String getS3BucketArn() {
            return this.s3BucketArn;
        }

        @Override
        public final Builder s3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
            return this;
        }

        public final void setS3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final OrganizationConfiguration.Builder getOrganizationConfiguration() {
            return this.organizationConfiguration != null ? this.organizationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder organizationConfiguration(OrganizationConfiguration organizationConfiguration) {
            this.organizationConfiguration = organizationConfiguration;
            return this;
        }

        public final void setOrganizationConfiguration(OrganizationConfiguration.BuilderImpl organizationConfiguration) {
            this.organizationConfiguration = organizationConfiguration != null ? organizationConfiguration.build() : null;
        }

        public final Boolean getEnableCrossAccountsDiscovery() {
            return this.enableCrossAccountsDiscovery;
        }

        @Override
        public final Builder enableCrossAccountsDiscovery(Boolean enableCrossAccountsDiscovery) {
            this.enableCrossAccountsDiscovery = enableCrossAccountsDiscovery;
            return this;
        }

        public final void setEnableCrossAccountsDiscovery(Boolean enableCrossAccountsDiscovery) {
            this.enableCrossAccountsDiscovery = enableCrossAccountsDiscovery;
        }

        @Override
        public GetServiceSettingsResponse build() {
            return new GetServiceSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetServiceSettingsResponse> {
        public Builder s3BucketArn(String var1);

        public Builder snsTopicArn(String var1);

        public Builder organizationConfiguration(OrganizationConfiguration var1);

        default public Builder organizationConfiguration(Consumer<OrganizationConfiguration.Builder> organizationConfiguration) {
            return this.organizationConfiguration((OrganizationConfiguration)((OrganizationConfiguration.Builder)OrganizationConfiguration.builder().applyMutation(organizationConfiguration)).build());
        }

        public Builder enableCrossAccountsDiscovery(Boolean var1);
    }
}

