/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexruntimev2.model.Shape;
import software.amazon.awssdk.services.lexruntimev2.model.SlotsCopier;
import software.amazon.awssdk.services.lexruntimev2.model.Value;
import software.amazon.awssdk.services.lexruntimev2.model.ValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Slot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Slot> {
    private static final SdkField<Value> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("value").getter(Slot.getter(Slot::value)).setter(Slot.setter(Builder::value)).constructor(Value::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<String> SHAPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shape").getter(Slot.getter(Slot::shapeAsString)).setter(Slot.setter(Builder::shape)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shape").build()}).build();
    private static final SdkField<List<Slot>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("values").getter(Slot.getter(Slot::values)).setter(Slot.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Slot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Slot>> SUB_SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("subSlots").getter(Slot.getter(Slot::subSlots)).setter(Slot.setter(Builder::subSlots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subSlots").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Slot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, SHAPE_FIELD, VALUES_FIELD, SUB_SLOTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Slot.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Value value;
    private final String shape;
    private final List<Slot> values;
    private final Map<String, Slot> subSlots;

    private Slot(BuilderImpl builder) {
        this.value = builder.value;
        this.shape = builder.shape;
        this.values = builder.values;
        this.subSlots = builder.subSlots;
    }

    public final Value value() {
        return this.value;
    }

    public final Shape shape() {
        return Shape.fromValue(this.shape);
    }

    public final String shapeAsString() {
        return this.shape;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<Slot> values() {
        return this.values;
    }

    public final boolean hasSubSlots() {
        return this.subSlots != null && !(this.subSlots instanceof SdkAutoConstructMap);
    }

    public final Map<String, Slot> subSlots() {
        return this.subSlots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.shapeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubSlots() ? this.subSlots() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Slot)) {
            return false;
        }
        Slot other = (Slot)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.shapeAsString(), other.shapeAsString()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values()) && this.hasSubSlots() == other.hasSubSlots() && Objects.equals(this.subSlots(), other.subSlots());
    }

    public final String toString() {
        return ToString.builder((String)"Slot").add("Value", (Object)this.value()).add("Shape", (Object)this.shapeAsString()).add("Values", this.hasValues() ? this.values() : null).add("SubSlots", this.hasSubSlots() ? this.subSlots() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "shape": {
                return Optional.ofNullable(clazz.cast(this.shapeAsString()));
            }
            case "values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "subSlots": {
                return Optional.ofNullable(clazz.cast(this.subSlots()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("value", VALUE_FIELD);
        map.put("shape", SHAPE_FIELD);
        map.put("values", VALUES_FIELD);
        map.put("subSlots", SUB_SLOTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Slot, T> g) {
        return obj -> g.apply((Slot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Value value;
        private String shape;
        private List<Slot> values = DefaultSdkAutoConstructList.getInstance();
        private Map<String, Slot> subSlots = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Slot model) {
            this.value(model.value);
            this.shape(model.shape);
            this.values(model.values);
            this.subSlots(model.subSlots);
        }

        public final Value.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(Value.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(Value value) {
            this.value = value;
            return this;
        }

        public final String getShape() {
            return this.shape;
        }

        public final void setShape(String shape) {
            this.shape = shape;
        }

        @Override
        public final Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        @Override
        public final Builder shape(Shape shape) {
            this.shape(shape == null ? null : shape.toString());
            return this;
        }

        public final List<Builder> getValues() {
            List<Builder> result = ValuesCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<BuilderImpl> values) {
            this.values = ValuesCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<Slot> values) {
            this.values = ValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Slot ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<Builder> ... values) {
            this.values(Stream.of(values).map(c -> (Slot)((Builder)Slot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, Builder> getSubSlots() {
            Map<String, Builder> result = SlotsCopier.copyToBuilder(this.subSlots);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSubSlots(Map<String, BuilderImpl> subSlots) {
            this.subSlots = SlotsCopier.copyFromBuilder(subSlots);
        }

        @Override
        public final Builder subSlots(Map<String, Slot> subSlots) {
            this.subSlots = SlotsCopier.copy(subSlots);
            return this;
        }

        public Slot build() {
            return new Slot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Slot> {
        public Builder value(Value var1);

        default public Builder value(Consumer<Value.Builder> value) {
            return this.value((Value)((Value.Builder)Value.builder().applyMutation(value)).build());
        }

        public Builder shape(String var1);

        public Builder shape(Shape var1);

        public Builder values(Collection<Slot> var1);

        public Builder values(Slot ... var1);

        public Builder values(Consumer<Builder> ... var1);

        public Builder subSlots(Map<String, Slot> var1);
    }
}

