/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecognizeTextResponse extends LexRuntimeV2Response implements
        ToCopyableBuilder<RecognizeTextResponse.Builder, RecognizeTextResponse> {
    private static final SdkField<List<Message>> MESSAGES_FIELD = SdkField
            .<List<Message>> builder(MarshallingType.LIST)
            .memberName("messages")
            .getter(getter(RecognizeTextResponse::messages))
            .setter(setter(Builder::messages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Message> builder(MarshallingType.SDK_POJO)
                                            .constructor(Message::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SessionState> SESSION_STATE_FIELD = SdkField.<SessionState> builder(MarshallingType.SDK_POJO)
            .memberName("sessionState").getter(getter(RecognizeTextResponse::sessionState)).setter(setter(Builder::sessionState))
            .constructor(SessionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionState").build()).build();

    private static final SdkField<List<Interpretation>> INTERPRETATIONS_FIELD = SdkField
            .<List<Interpretation>> builder(MarshallingType.LIST)
            .memberName("interpretations")
            .getter(getter(RecognizeTextResponse::interpretations))
            .setter(setter(Builder::interpretations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interpretations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Interpretation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Interpretation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> REQUEST_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("requestAttributes")
            .getter(getter(RecognizeTextResponse::requestAttributes))
            .setter(setter(Builder::requestAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(RecognizeTextResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<RecognizedBotMember> RECOGNIZED_BOT_MEMBER_FIELD = SdkField
            .<RecognizedBotMember> builder(MarshallingType.SDK_POJO).memberName("recognizedBotMember")
            .getter(getter(RecognizeTextResponse::recognizedBotMember)).setter(setter(Builder::recognizedBotMember))
            .constructor(RecognizedBotMember::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recognizedBotMember").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGES_FIELD,
            SESSION_STATE_FIELD, INTERPRETATIONS_FIELD, REQUEST_ATTRIBUTES_FIELD, SESSION_ID_FIELD, RECOGNIZED_BOT_MEMBER_FIELD));

    private final List<Message> messages;

    private final SessionState sessionState;

    private final List<Interpretation> interpretations;

    private final Map<String, String> requestAttributes;

    private final String sessionId;

    private final RecognizedBotMember recognizedBotMember;

    private RecognizeTextResponse(BuilderImpl builder) {
        super(builder);
        this.messages = builder.messages;
        this.sessionState = builder.sessionState;
        this.interpretations = builder.interpretations;
        this.requestAttributes = builder.requestAttributes;
        this.sessionId = builder.sessionId;
        this.recognizedBotMember = builder.recognizedBotMember;
    }

    /**
     * For responses, this returns true if the service returned a value for the Messages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMessages() {
        return messages != null && !(messages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of messages last sent to the user. The messages are ordered based on the order that you returned the
     * messages from your Lambda function or the order that the messages are defined in the bot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessages} method.
     * </p>
     * 
     * @return A list of messages last sent to the user. The messages are ordered based on the order that you returned
     *         the messages from your Lambda function or the order that the messages are defined in the bot.
     */
    public final List<Message> messages() {
        return messages;
    }

    /**
     * <p>
     * Represents the current state of the dialog between the user and the bot.
     * </p>
     * <p>
     * Use this to determine the progress of the conversation and what the next action may be.
     * </p>
     * 
     * @return Represents the current state of the dialog between the user and the bot. </p>
     *         <p>
     *         Use this to determine the progress of the conversation and what the next action may be.
     */
    public final SessionState sessionState() {
        return sessionState;
    }

    /**
     * For responses, this returns true if the service returned a value for the Interpretations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInterpretations() {
        return interpretations != null && !(interpretations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of intents that Amazon Lex V2 determined might satisfy the user's utterance.
     * </p>
     * <p>
     * Each interpretation includes the intent, a score that indicates now confident Amazon Lex V2 is that the
     * interpretation is the correct one, and an optional sentiment response that indicates the sentiment expressed in
     * the utterance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInterpretations} method.
     * </p>
     * 
     * @return A list of intents that Amazon Lex V2 determined might satisfy the user's utterance. </p>
     *         <p>
     *         Each interpretation includes the intent, a score that indicates now confident Amazon Lex V2 is that the
     *         interpretation is the correct one, and an optional sentiment response that indicates the sentiment
     *         expressed in the utterance.
     */
    public final List<Interpretation> interpretations() {
        return interpretations;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequestAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRequestAttributes() {
        return requestAttributes != null && !(requestAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The attributes sent in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequestAttributes} method.
     * </p>
     * 
     * @return The attributes sent in the request.
     */
    public final Map<String, String> requestAttributes() {
        return requestAttributes;
    }

    /**
     * <p>
     * The identifier of the session in use.
     * </p>
     * 
     * @return The identifier of the session in use.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The bot member that recognized the text.
     * </p>
     * 
     * @return The bot member that recognized the text.
     */
    public final RecognizedBotMember recognizedBotMember() {
        return recognizedBotMember;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMessages() ? messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sessionState());
        hashCode = 31 * hashCode + Objects.hashCode(hasInterpretations() ? interpretations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestAttributes() ? requestAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(recognizedBotMember());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecognizeTextResponse)) {
            return false;
        }
        RecognizeTextResponse other = (RecognizeTextResponse) obj;
        return hasMessages() == other.hasMessages() && Objects.equals(messages(), other.messages())
                && Objects.equals(sessionState(), other.sessionState()) && hasInterpretations() == other.hasInterpretations()
                && Objects.equals(interpretations(), other.interpretations())
                && hasRequestAttributes() == other.hasRequestAttributes()
                && Objects.equals(requestAttributes(), other.requestAttributes())
                && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(recognizedBotMember(), other.recognizedBotMember());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecognizeTextResponse").add("Messages", hasMessages() ? messages() : null)
                .add("SessionState", sessionState()).add("Interpretations", hasInterpretations() ? interpretations() : null)
                .add("RequestAttributes", hasRequestAttributes() ? requestAttributes() : null).add("SessionId", sessionId())
                .add("RecognizedBotMember", recognizedBotMember()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messages":
            return Optional.ofNullable(clazz.cast(messages()));
        case "sessionState":
            return Optional.ofNullable(clazz.cast(sessionState()));
        case "interpretations":
            return Optional.ofNullable(clazz.cast(interpretations()));
        case "requestAttributes":
            return Optional.ofNullable(clazz.cast(requestAttributes()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "recognizedBotMember":
            return Optional.ofNullable(clazz.cast(recognizedBotMember()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecognizeTextResponse, T> g) {
        return obj -> g.apply((RecognizeTextResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexRuntimeV2Response.Builder, SdkPojo, CopyableBuilder<Builder, RecognizeTextResponse> {
        /**
         * <p>
         * A list of messages last sent to the user. The messages are ordered based on the order that you returned the
         * messages from your Lambda function or the order that the messages are defined in the bot.
         * </p>
         * 
         * @param messages
         *        A list of messages last sent to the user. The messages are ordered based on the order that you
         *        returned the messages from your Lambda function or the order that the messages are defined in the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<Message> messages);

        /**
         * <p>
         * A list of messages last sent to the user. The messages are ordered based on the order that you returned the
         * messages from your Lambda function or the order that the messages are defined in the bot.
         * </p>
         * 
         * @param messages
         *        A list of messages last sent to the user. The messages are ordered based on the order that you
         *        returned the messages from your Lambda function or the order that the messages are defined in the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Message... messages);

        /**
         * <p>
         * A list of messages last sent to the user. The messages are ordered based on the order that you returned the
         * messages from your Lambda function or the order that the messages are defined in the bot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexruntimev2.model.Message.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lexruntimev2.model.Message#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexruntimev2.model.Message.Builder#build()} is called immediately and
         * its result is passed to {@link #messages(List<Message>)}.
         * 
         * @param messages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexruntimev2.model.Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messages(java.util.Collection<Message>)
         */
        Builder messages(Consumer<Message.Builder>... messages);

        /**
         * <p>
         * Represents the current state of the dialog between the user and the bot.
         * </p>
         * <p>
         * Use this to determine the progress of the conversation and what the next action may be.
         * </p>
         * 
         * @param sessionState
         *        Represents the current state of the dialog between the user and the bot. </p>
         *        <p>
         *        Use this to determine the progress of the conversation and what the next action may be.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionState(SessionState sessionState);

        /**
         * <p>
         * Represents the current state of the dialog between the user and the bot.
         * </p>
         * <p>
         * Use this to determine the progress of the conversation and what the next action may be.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionState.Builder} avoiding the need
         * to create one manually via {@link SessionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionState.Builder#build()} is called immediately and its
         * result is passed to {@link #sessionState(SessionState)}.
         * 
         * @param sessionState
         *        a consumer that will call methods on {@link SessionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionState(SessionState)
         */
        default Builder sessionState(Consumer<SessionState.Builder> sessionState) {
            return sessionState(SessionState.builder().applyMutation(sessionState).build());
        }

        /**
         * <p>
         * A list of intents that Amazon Lex V2 determined might satisfy the user's utterance.
         * </p>
         * <p>
         * Each interpretation includes the intent, a score that indicates now confident Amazon Lex V2 is that the
         * interpretation is the correct one, and an optional sentiment response that indicates the sentiment expressed
         * in the utterance.
         * </p>
         * 
         * @param interpretations
         *        A list of intents that Amazon Lex V2 determined might satisfy the user's utterance. </p>
         *        <p>
         *        Each interpretation includes the intent, a score that indicates now confident Amazon Lex V2 is that
         *        the interpretation is the correct one, and an optional sentiment response that indicates the sentiment
         *        expressed in the utterance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interpretations(Collection<Interpretation> interpretations);

        /**
         * <p>
         * A list of intents that Amazon Lex V2 determined might satisfy the user's utterance.
         * </p>
         * <p>
         * Each interpretation includes the intent, a score that indicates now confident Amazon Lex V2 is that the
         * interpretation is the correct one, and an optional sentiment response that indicates the sentiment expressed
         * in the utterance.
         * </p>
         * 
         * @param interpretations
         *        A list of intents that Amazon Lex V2 determined might satisfy the user's utterance. </p>
         *        <p>
         *        Each interpretation includes the intent, a score that indicates now confident Amazon Lex V2 is that
         *        the interpretation is the correct one, and an optional sentiment response that indicates the sentiment
         *        expressed in the utterance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interpretations(Interpretation... interpretations);

        /**
         * <p>
         * A list of intents that Amazon Lex V2 determined might satisfy the user's utterance.
         * </p>
         * <p>
         * Each interpretation includes the intent, a score that indicates now confident Amazon Lex V2 is that the
         * interpretation is the correct one, and an optional sentiment response that indicates the sentiment expressed
         * in the utterance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexruntimev2.model.Interpretation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexruntimev2.model.Interpretation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexruntimev2.model.Interpretation.Builder#build()} is called
         * immediately and its result is passed to {@link #interpretations(List<Interpretation>)}.
         * 
         * @param interpretations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexruntimev2.model.Interpretation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interpretations(java.util.Collection<Interpretation>)
         */
        Builder interpretations(Consumer<Interpretation.Builder>... interpretations);

        /**
         * <p>
         * The attributes sent in the request.
         * </p>
         * 
         * @param requestAttributes
         *        The attributes sent in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestAttributes(Map<String, String> requestAttributes);

        /**
         * <p>
         * The identifier of the session in use.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the session in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The bot member that recognized the text.
         * </p>
         * 
         * @param recognizedBotMember
         *        The bot member that recognized the text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recognizedBotMember(RecognizedBotMember recognizedBotMember);

        /**
         * <p>
         * The bot member that recognized the text.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecognizedBotMember.Builder} avoiding the
         * need to create one manually via {@link RecognizedBotMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecognizedBotMember.Builder#build()} is called immediately and
         * its result is passed to {@link #recognizedBotMember(RecognizedBotMember)}.
         * 
         * @param recognizedBotMember
         *        a consumer that will call methods on {@link RecognizedBotMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recognizedBotMember(RecognizedBotMember)
         */
        default Builder recognizedBotMember(Consumer<RecognizedBotMember.Builder> recognizedBotMember) {
            return recognizedBotMember(RecognizedBotMember.builder().applyMutation(recognizedBotMember).build());
        }
    }

    static final class BuilderImpl extends LexRuntimeV2Response.BuilderImpl implements Builder {
        private List<Message> messages = DefaultSdkAutoConstructList.getInstance();

        private SessionState sessionState;

        private List<Interpretation> interpretations = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> requestAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String sessionId;

        private RecognizedBotMember recognizedBotMember;

        private BuilderImpl() {
        }

        private BuilderImpl(RecognizeTextResponse model) {
            super(model);
            messages(model.messages);
            sessionState(model.sessionState);
            interpretations(model.interpretations);
            requestAttributes(model.requestAttributes);
            sessionId(model.sessionId);
            recognizedBotMember(model.recognizedBotMember);
        }

        public final List<Message.Builder> getMessages() {
            List<Message.Builder> result = MessagesCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = MessagesCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<Message.Builder>... messages) {
            messages(Stream.of(messages).map(c -> Message.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final SessionState.Builder getSessionState() {
            return sessionState != null ? sessionState.toBuilder() : null;
        }

        public final void setSessionState(SessionState.BuilderImpl sessionState) {
            this.sessionState = sessionState != null ? sessionState.build() : null;
        }

        @Override
        public final Builder sessionState(SessionState sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        public final List<Interpretation.Builder> getInterpretations() {
            List<Interpretation.Builder> result = InterpretationsCopier.copyToBuilder(this.interpretations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInterpretations(Collection<Interpretation.BuilderImpl> interpretations) {
            this.interpretations = InterpretationsCopier.copyFromBuilder(interpretations);
        }

        @Override
        public final Builder interpretations(Collection<Interpretation> interpretations) {
            this.interpretations = InterpretationsCopier.copy(interpretations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interpretations(Interpretation... interpretations) {
            interpretations(Arrays.asList(interpretations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interpretations(Consumer<Interpretation.Builder>... interpretations) {
            interpretations(Stream.of(interpretations).map(c -> Interpretation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getRequestAttributes() {
            if (requestAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return requestAttributes;
        }

        public final void setRequestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
        }

        @Override
        public final Builder requestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final RecognizedBotMember.Builder getRecognizedBotMember() {
            return recognizedBotMember != null ? recognizedBotMember.toBuilder() : null;
        }

        public final void setRecognizedBotMember(RecognizedBotMember.BuilderImpl recognizedBotMember) {
            this.recognizedBotMember = recognizedBotMember != null ? recognizedBotMember.build() : null;
        }

        @Override
        public final Builder recognizedBotMember(RecognizedBotMember recognizedBotMember) {
            this.recognizedBotMember = recognizedBotMember;
            return this;
        }

        @Override
        public RecognizeTextResponse build() {
            return new RecognizeTextResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
