/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexruntimev2.model.Interpretation;
import software.amazon.awssdk.services.lexruntimev2.model.InterpretationsCopier;
import software.amazon.awssdk.services.lexruntimev2.model.LexRuntimeV2Response;
import software.amazon.awssdk.services.lexruntimev2.model.Message;
import software.amazon.awssdk.services.lexruntimev2.model.MessagesCopier;
import software.amazon.awssdk.services.lexruntimev2.model.SessionState;
import software.amazon.awssdk.services.lexruntimev2.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecognizeTextResponse
extends LexRuntimeV2Response
implements ToCopyableBuilder<Builder, RecognizeTextResponse> {
    private static final SdkField<List<Message>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("messages").getter(RecognizeTextResponse.getter(RecognizeTextResponse::messages)).setter(RecognizeTextResponse.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Message::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SessionState> SESSION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sessionState").getter(RecognizeTextResponse.getter(RecognizeTextResponse::sessionState)).setter(RecognizeTextResponse.setter(Builder::sessionState)).constructor(SessionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionState").build()}).build();
    private static final SdkField<List<Interpretation>> INTERPRETATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("interpretations").getter(RecognizeTextResponse.getter(RecognizeTextResponse::interpretations)).setter(RecognizeTextResponse.setter(Builder::interpretations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interpretations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Interpretation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> REQUEST_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("requestAttributes").getter(RecognizeTextResponse.getter(RecognizeTextResponse::requestAttributes)).setter(RecognizeTextResponse.setter(Builder::requestAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(RecognizeTextResponse.getter(RecognizeTextResponse::sessionId)).setter(RecognizeTextResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGES_FIELD, SESSION_STATE_FIELD, INTERPRETATIONS_FIELD, REQUEST_ATTRIBUTES_FIELD, SESSION_ID_FIELD));
    private final List<Message> messages;
    private final SessionState sessionState;
    private final List<Interpretation> interpretations;
    private final Map<String, String> requestAttributes;
    private final String sessionId;

    private RecognizeTextResponse(BuilderImpl builder) {
        super(builder);
        this.messages = builder.messages;
        this.sessionState = builder.sessionState;
        this.interpretations = builder.interpretations;
        this.requestAttributes = builder.requestAttributes;
        this.sessionId = builder.sessionId;
    }

    public final boolean hasMessages() {
        return this.messages != null && !(this.messages instanceof SdkAutoConstructList);
    }

    public final List<Message> messages() {
        return this.messages;
    }

    public final SessionState sessionState() {
        return this.sessionState;
    }

    public final boolean hasInterpretations() {
        return this.interpretations != null && !(this.interpretations instanceof SdkAutoConstructList);
    }

    public final List<Interpretation> interpretations() {
        return this.interpretations;
    }

    public final boolean hasRequestAttributes() {
        return this.requestAttributes != null && !(this.requestAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> requestAttributes() {
        return this.requestAttributes;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessages() ? this.messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInterpretations() ? this.interpretations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestAttributes() ? this.requestAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecognizeTextResponse)) {
            return false;
        }
        RecognizeTextResponse other = (RecognizeTextResponse)((Object)obj);
        return this.hasMessages() == other.hasMessages() && Objects.equals(this.messages(), other.messages()) && Objects.equals(this.sessionState(), other.sessionState()) && this.hasInterpretations() == other.hasInterpretations() && Objects.equals(this.interpretations(), other.interpretations()) && this.hasRequestAttributes() == other.hasRequestAttributes() && Objects.equals(this.requestAttributes(), other.requestAttributes()) && Objects.equals(this.sessionId(), other.sessionId());
    }

    public final String toString() {
        return ToString.builder((String)"RecognizeTextResponse").add("Messages", this.hasMessages() ? this.messages() : null).add("SessionState", (Object)this.sessionState()).add("Interpretations", this.hasInterpretations() ? this.interpretations() : null).add("RequestAttributes", this.hasRequestAttributes() ? this.requestAttributes() : null).add("SessionId", (Object)this.sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
            case "sessionState": {
                return Optional.ofNullable(clazz.cast(this.sessionState()));
            }
            case "interpretations": {
                return Optional.ofNullable(clazz.cast(this.interpretations()));
            }
            case "requestAttributes": {
                return Optional.ofNullable(clazz.cast(this.requestAttributes()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecognizeTextResponse, T> g) {
        return obj -> g.apply((RecognizeTextResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexRuntimeV2Response.BuilderImpl
    implements Builder {
        private List<Message> messages = DefaultSdkAutoConstructList.getInstance();
        private SessionState sessionState;
        private List<Interpretation> interpretations = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> requestAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(RecognizeTextResponse model) {
            super(model);
            this.messages(model.messages);
            this.sessionState(model.sessionState);
            this.interpretations(model.interpretations);
            this.requestAttributes(model.requestAttributes);
            this.sessionId(model.sessionId);
        }

        public final List<Message.Builder> getMessages() {
            List<Message.Builder> result = MessagesCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = MessagesCopier.copyFromBuilder(messages);
        }

        @Override
        @Transient
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessagesCopier.copy(messages);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder messages(Message ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder messages(Consumer<Message.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (Message)((Message.Builder)Message.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SessionState.Builder getSessionState() {
            return this.sessionState != null ? this.sessionState.toBuilder() : null;
        }

        public final void setSessionState(SessionState.BuilderImpl sessionState) {
            this.sessionState = sessionState != null ? sessionState.build() : null;
        }

        @Override
        @Transient
        public final Builder sessionState(SessionState sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        public final List<Interpretation.Builder> getInterpretations() {
            List<Interpretation.Builder> result = InterpretationsCopier.copyToBuilder(this.interpretations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInterpretations(Collection<Interpretation.BuilderImpl> interpretations) {
            this.interpretations = InterpretationsCopier.copyFromBuilder(interpretations);
        }

        @Override
        @Transient
        public final Builder interpretations(Collection<Interpretation> interpretations) {
            this.interpretations = InterpretationsCopier.copy(interpretations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder interpretations(Interpretation ... interpretations) {
            this.interpretations(Arrays.asList(interpretations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder interpretations(Consumer<Interpretation.Builder> ... interpretations) {
            this.interpretations(Stream.of(interpretations).map(c -> (Interpretation)((Interpretation.Builder)Interpretation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getRequestAttributes() {
            if (this.requestAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requestAttributes;
        }

        public final void setRequestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
        }

        @Override
        @Transient
        public final Builder requestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        @Transient
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public RecognizeTextResponse build() {
            return new RecognizeTextResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexRuntimeV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RecognizeTextResponse> {
        public Builder messages(Collection<Message> var1);

        public Builder messages(Message ... var1);

        public Builder messages(Consumer<Message.Builder> ... var1);

        public Builder sessionState(SessionState var1);

        default public Builder sessionState(Consumer<SessionState.Builder> sessionState) {
            return this.sessionState((SessionState)((SessionState.Builder)SessionState.builder().applyMutation(sessionState)).build());
        }

        public Builder interpretations(Collection<Interpretation> var1);

        public Builder interpretations(Interpretation ... var1);

        public Builder interpretations(Consumer<Interpretation.Builder> ... var1);

        public Builder requestAttributes(Map<String, String> var1);

        public Builder sessionId(String var1);
    }
}

