/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.protocols.core.OperationInfo;
import software.amazon.awssdk.protocols.core.ProtocolMarshaller;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.services.lexruntimev2.model.PlaybackCompletionEvent;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PlaybackCompletionEventMarshaller
implements Marshaller<PlaybackCompletionEvent> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().hasExplicitPayloadMember(false).hasPayloadMembers(true).httpMethod(SdkHttpMethod.GET).hasEvent(true).build();
    private final BaseAwsJsonProtocolFactory protocolFactory;

    public PlaybackCompletionEventMarshaller(BaseAwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public SdkHttpFullRequest marshall(PlaybackCompletionEvent playbackCompletionEvent) {
        Validate.paramNotNull((Object)playbackCompletionEvent, (String)"playbackCompletionEvent");
        try {
            ProtocolMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING);
            return ((SdkHttpFullRequest)protocolMarshaller.marshall((SdkPojo)playbackCompletionEvent)).toBuilder().putHeader(":message-type", "event").putHeader(":event-type", playbackCompletionEvent.sdkEventType().toString()).putHeader(":content-type", this.protocolFactory.getContentType()).build();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

