/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexruntimev2.model.ActiveContext;
import software.amazon.awssdk.services.lexruntimev2.model.ActiveContextsListCopier;
import software.amazon.awssdk.services.lexruntimev2.model.DialogAction;
import software.amazon.awssdk.services.lexruntimev2.model.Intent;
import software.amazon.awssdk.services.lexruntimev2.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionState> {
    private static final SdkField<DialogAction> DIALOG_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dialogAction").getter(SessionState.getter(SessionState::dialogAction)).setter(SessionState.setter(Builder::dialogAction)).constructor(DialogAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogAction").build()}).build();
    private static final SdkField<Intent> INTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("intent").getter(SessionState.getter(SessionState::intent)).setter(SessionState.setter(Builder::intent)).constructor(Intent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intent").build()}).build();
    private static final SdkField<List<ActiveContext>> ACTIVE_CONTEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("activeContexts").getter(SessionState.getter(SessionState::activeContexts)).setter(SessionState.setter(Builder::activeContexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeContexts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActiveContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> SESSION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sessionAttributes").getter(SessionState.getter(SessionState::sessionAttributes)).setter(SessionState.setter(Builder::sessionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ORIGINATING_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originatingRequestId").getter(SessionState.getter(SessionState::originatingRequestId)).setter(SessionState.setter(Builder::originatingRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originatingRequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIALOG_ACTION_FIELD, INTENT_FIELD, ACTIVE_CONTEXTS_FIELD, SESSION_ATTRIBUTES_FIELD, ORIGINATING_REQUEST_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final DialogAction dialogAction;
    private final Intent intent;
    private final List<ActiveContext> activeContexts;
    private final Map<String, String> sessionAttributes;
    private final String originatingRequestId;

    private SessionState(BuilderImpl builder) {
        this.dialogAction = builder.dialogAction;
        this.intent = builder.intent;
        this.activeContexts = builder.activeContexts;
        this.sessionAttributes = builder.sessionAttributes;
        this.originatingRequestId = builder.originatingRequestId;
    }

    public final DialogAction dialogAction() {
        return this.dialogAction;
    }

    public final Intent intent() {
        return this.intent;
    }

    public final boolean hasActiveContexts() {
        return this.activeContexts != null && !(this.activeContexts instanceof SdkAutoConstructList);
    }

    public final List<ActiveContext> activeContexts() {
        return this.activeContexts;
    }

    public final boolean hasSessionAttributes() {
        return this.sessionAttributes != null && !(this.sessionAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sessionAttributes() {
        return this.sessionAttributes;
    }

    public final String originatingRequestId() {
        return this.originatingRequestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dialogAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.intent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActiveContexts() ? this.activeContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionAttributes() ? this.sessionAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.originatingRequestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionState)) {
            return false;
        }
        SessionState other = (SessionState)obj;
        return Objects.equals(this.dialogAction(), other.dialogAction()) && Objects.equals(this.intent(), other.intent()) && this.hasActiveContexts() == other.hasActiveContexts() && Objects.equals(this.activeContexts(), other.activeContexts()) && this.hasSessionAttributes() == other.hasSessionAttributes() && Objects.equals(this.sessionAttributes(), other.sessionAttributes()) && Objects.equals(this.originatingRequestId(), other.originatingRequestId());
    }

    public final String toString() {
        return ToString.builder((String)"SessionState").add("DialogAction", (Object)this.dialogAction()).add("Intent", (Object)this.intent()).add("ActiveContexts", this.hasActiveContexts() ? this.activeContexts() : null).add("SessionAttributes", this.hasSessionAttributes() ? this.sessionAttributes() : null).add("OriginatingRequestId", (Object)this.originatingRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dialogAction": {
                return Optional.ofNullable(clazz.cast(this.dialogAction()));
            }
            case "intent": {
                return Optional.ofNullable(clazz.cast(this.intent()));
            }
            case "activeContexts": {
                return Optional.ofNullable(clazz.cast(this.activeContexts()));
            }
            case "sessionAttributes": {
                return Optional.ofNullable(clazz.cast(this.sessionAttributes()));
            }
            case "originatingRequestId": {
                return Optional.ofNullable(clazz.cast(this.originatingRequestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionState, T> g) {
        return obj -> g.apply((SessionState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DialogAction dialogAction;
        private Intent intent;
        private List<ActiveContext> activeContexts = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> sessionAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String originatingRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionState model) {
            this.dialogAction(model.dialogAction);
            this.intent(model.intent);
            this.activeContexts(model.activeContexts);
            this.sessionAttributes(model.sessionAttributes);
            this.originatingRequestId(model.originatingRequestId);
        }

        public final DialogAction.Builder getDialogAction() {
            return this.dialogAction != null ? this.dialogAction.toBuilder() : null;
        }

        public final void setDialogAction(DialogAction.BuilderImpl dialogAction) {
            this.dialogAction = dialogAction != null ? dialogAction.build() : null;
        }

        @Override
        @Transient
        public final Builder dialogAction(DialogAction dialogAction) {
            this.dialogAction = dialogAction;
            return this;
        }

        public final Intent.Builder getIntent() {
            return this.intent != null ? this.intent.toBuilder() : null;
        }

        public final void setIntent(Intent.BuilderImpl intent) {
            this.intent = intent != null ? intent.build() : null;
        }

        @Override
        @Transient
        public final Builder intent(Intent intent) {
            this.intent = intent;
            return this;
        }

        public final List<ActiveContext.Builder> getActiveContexts() {
            List<ActiveContext.Builder> result = ActiveContextsListCopier.copyToBuilder(this.activeContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActiveContexts(Collection<ActiveContext.BuilderImpl> activeContexts) {
            this.activeContexts = ActiveContextsListCopier.copyFromBuilder(activeContexts);
        }

        @Override
        @Transient
        public final Builder activeContexts(Collection<ActiveContext> activeContexts) {
            this.activeContexts = ActiveContextsListCopier.copy(activeContexts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder activeContexts(ActiveContext ... activeContexts) {
            this.activeContexts(Arrays.asList(activeContexts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder activeContexts(Consumer<ActiveContext.Builder> ... activeContexts) {
            this.activeContexts(Stream.of(activeContexts).map(c -> (ActiveContext)((ActiveContext.Builder)ActiveContext.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getSessionAttributes() {
            if (this.sessionAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sessionAttributes;
        }

        public final void setSessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
        }

        @Override
        @Transient
        public final Builder sessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
            return this;
        }

        public final String getOriginatingRequestId() {
            return this.originatingRequestId;
        }

        public final void setOriginatingRequestId(String originatingRequestId) {
            this.originatingRequestId = originatingRequestId;
        }

        @Override
        @Transient
        public final Builder originatingRequestId(String originatingRequestId) {
            this.originatingRequestId = originatingRequestId;
            return this;
        }

        public SessionState build() {
            return new SessionState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionState> {
        public Builder dialogAction(DialogAction var1);

        default public Builder dialogAction(Consumer<DialogAction.Builder> dialogAction) {
            return this.dialogAction((DialogAction)((DialogAction.Builder)DialogAction.builder().applyMutation(dialogAction)).build());
        }

        public Builder intent(Intent var1);

        default public Builder intent(Consumer<Intent.Builder> intent) {
            return this.intent((Intent)((Intent.Builder)Intent.builder().applyMutation(intent)).build());
        }

        public Builder activeContexts(Collection<ActiveContext> var1);

        public Builder activeContexts(ActiveContext ... var1);

        public Builder activeContexts(Consumer<ActiveContext.Builder> ... var1);

        public Builder sessionAttributes(Map<String, String> var1);

        public Builder originatingRequestId(String var1);
    }
}

