/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.lexruntimev2.model.startconversationrequesteventstream.DefaultAudioInputEvent;
import software.amazon.awssdk.services.lexruntimev2.model.startconversationrequesteventstream.DefaultConfigurationEvent;
import software.amazon.awssdk.services.lexruntimev2.model.startconversationrequesteventstream.DefaultDTMFInputEvent;
import software.amazon.awssdk.services.lexruntimev2.model.startconversationrequesteventstream.DefaultDisconnectionEvent;
import software.amazon.awssdk.services.lexruntimev2.model.startconversationrequesteventstream.DefaultPlaybackCompletionEvent;
import software.amazon.awssdk.services.lexruntimev2.model.startconversationrequesteventstream.DefaultTextInputEvent;

/**
 * Base interface for all event types in StartConversationRequestEventStream.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface StartConversationRequestEventStream {
    /**
     * Create a builder for the {@code ConfigurationEvent} event type for this stream.
     */
    static ConfigurationEvent.Builder configurationEventBuilder() {
        return DefaultConfigurationEvent.builder();
    }

    /**
     * Create a builder for the {@code AudioInputEvent} event type for this stream.
     */
    static AudioInputEvent.Builder audioInputEventBuilder() {
        return DefaultAudioInputEvent.builder();
    }

    /**
     * Create a builder for the {@code DTMFInputEvent} event type for this stream.
     */
    static DTMFInputEvent.Builder dTMFInputEventBuilder() {
        return DefaultDTMFInputEvent.builder();
    }

    /**
     * Create a builder for the {@code TextInputEvent} event type for this stream.
     */
    static TextInputEvent.Builder textInputEventBuilder() {
        return DefaultTextInputEvent.builder();
    }

    /**
     * Create a builder for the {@code PlaybackCompletionEvent} event type for this stream.
     */
    static PlaybackCompletionEvent.Builder playbackCompletionEventBuilder() {
        return DefaultPlaybackCompletionEvent.builder();
    }

    /**
     * Create a builder for the {@code DisconnectionEvent} event type for this stream.
     */
    static DisconnectionEvent.Builder disconnectionEventBuilder() {
        return DefaultDisconnectionEvent.builder();
    }

    /**
     * The type of this event. Corresponds to the {@code :event-type} header on the Message.
     */
    default EventType sdkEventType() {
        return EventType.UNKNOWN_TO_SDK_VERSION;
    }

    /**
     * The known possible types of events for {@code StartConversationRequestEventStream}.
     */
    @Generated("software.amazon.awssdk:codegen")
    enum EventType {
        CONFIGURATION_EVENT("ConfigurationEvent"),

        AUDIO_INPUT_EVENT("AudioInputEvent"),

        DTMF_INPUT_EVENT("DTMFInputEvent"),

        TEXT_INPUT_EVENT("TextInputEvent"),

        PLAYBACK_COMPLETION_EVENT("PlaybackCompletionEvent"),

        DISCONNECTION_EVENT("DisconnectionEvent"),

        UNKNOWN_TO_SDK_VERSION(null);

        private final String value;

        private EventType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        /**
         * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
         *
         * @param value
         *        real value
         * @return EventType corresponding to the value
         */
        public static EventType fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Stream.of(EventType.values()).filter(e -> e.toString().equals(value)).findFirst()
                    .orElse(UNKNOWN_TO_SDK_VERSION);
        }

        /**
         * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will
         * return all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
         *
         * @return a {@link Set} of known {@link EventType}s
         */
        public static Set<EventType> knownValues() {
            return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
        }
    }
}
