/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexruntime.model.DialogActionType;
import software.amazon.awssdk.services.lexruntime.model.FulfillmentState;
import software.amazon.awssdk.services.lexruntime.model.MessageFormatType;
import software.amazon.awssdk.services.lexruntime.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DialogAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DialogAction> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(DialogAction.getter(DialogAction::typeAsString)).setter(DialogAction.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intentName").getter(DialogAction.getter(DialogAction::intentName)).setter(DialogAction.setter(Builder::intentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()}).build();
    private static final SdkField<Map<String, String>> SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("slots").getter(DialogAction.getter(DialogAction::slots)).setter(DialogAction.setter(Builder::slots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slots").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SLOT_TO_ELICIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotToElicit").getter(DialogAction.getter(DialogAction::slotToElicit)).setter(DialogAction.setter(Builder::slotToElicit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotToElicit").build()}).build();
    private static final SdkField<String> FULFILLMENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fulfillmentState").getter(DialogAction.getter(DialogAction::fulfillmentStateAsString)).setter(DialogAction.setter(Builder::fulfillmentState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fulfillmentState").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(DialogAction.getter(DialogAction::message)).setter(DialogAction.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<String> MESSAGE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageFormat").getter(DialogAction.getter(DialogAction::messageFormatAsString)).setter(DialogAction.setter(Builder::messageFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, INTENT_NAME_FIELD, SLOTS_FIELD, SLOT_TO_ELICIT_FIELD, FULFILLMENT_STATE_FIELD, MESSAGE_FIELD, MESSAGE_FORMAT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String intentName;
    private final Map<String, String> slots;
    private final String slotToElicit;
    private final String fulfillmentState;
    private final String message;
    private final String messageFormat;

    private DialogAction(BuilderImpl builder) {
        this.type = builder.type;
        this.intentName = builder.intentName;
        this.slots = builder.slots;
        this.slotToElicit = builder.slotToElicit;
        this.fulfillmentState = builder.fulfillmentState;
        this.message = builder.message;
        this.messageFormat = builder.messageFormat;
    }

    public DialogActionType type() {
        return DialogActionType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String intentName() {
        return this.intentName;
    }

    public boolean hasSlots() {
        return this.slots != null && !(this.slots instanceof SdkAutoConstructMap);
    }

    public Map<String, String> slots() {
        return this.slots;
    }

    public String slotToElicit() {
        return this.slotToElicit;
    }

    public FulfillmentState fulfillmentState() {
        return FulfillmentState.fromValue(this.fulfillmentState);
    }

    public String fulfillmentStateAsString() {
        return this.fulfillmentState;
    }

    public String message() {
        return this.message;
    }

    public MessageFormatType messageFormat() {
        return MessageFormatType.fromValue(this.messageFormat);
    }

    public String messageFormatAsString() {
        return this.messageFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.slots());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotToElicit());
        hashCode = 31 * hashCode + Objects.hashCode(this.fulfillmentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageFormatAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DialogAction)) {
            return false;
        }
        DialogAction other = (DialogAction)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.intentName(), other.intentName()) && Objects.equals(this.slots(), other.slots()) && Objects.equals(this.slotToElicit(), other.slotToElicit()) && Objects.equals(this.fulfillmentStateAsString(), other.fulfillmentStateAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.messageFormatAsString(), other.messageFormatAsString());
    }

    public String toString() {
        return ToString.builder((String)"DialogAction").add("Type", (Object)this.typeAsString()).add("IntentName", (Object)this.intentName()).add("Slots", (Object)(this.slots() == null ? null : "*** Sensitive Data Redacted ***")).add("SlotToElicit", (Object)this.slotToElicit()).add("FulfillmentState", (Object)this.fulfillmentStateAsString()).add("Message", (Object)(this.message() == null ? null : "*** Sensitive Data Redacted ***")).add("MessageFormat", (Object)this.messageFormatAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "intentName": {
                return Optional.ofNullable(clazz.cast(this.intentName()));
            }
            case "slots": {
                return Optional.ofNullable(clazz.cast(this.slots()));
            }
            case "slotToElicit": {
                return Optional.ofNullable(clazz.cast(this.slotToElicit()));
            }
            case "fulfillmentState": {
                return Optional.ofNullable(clazz.cast(this.fulfillmentStateAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "messageFormat": {
                return Optional.ofNullable(clazz.cast(this.messageFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DialogAction, T> g) {
        return obj -> g.apply((DialogAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String intentName;
        private Map<String, String> slots = DefaultSdkAutoConstructMap.getInstance();
        private String slotToElicit;
        private String fulfillmentState;
        private String message;
        private String messageFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(DialogAction model) {
            this.type(model.type);
            this.intentName(model.intentName);
            this.slots(model.slots);
            this.slotToElicit(model.slotToElicit);
            this.fulfillmentState(model.fulfillmentState);
            this.message(model.message);
            this.messageFormat(model.messageFormat);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DialogActionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getIntentName() {
            return this.intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        public final Map<String, String> getSlots() {
            return this.slots;
        }

        @Override
        public final Builder slots(Map<String, String> slots) {
            this.slots = StringMapCopier.copy(slots);
            return this;
        }

        public final void setSlots(Map<String, String> slots) {
            this.slots = StringMapCopier.copy(slots);
        }

        public final String getSlotToElicit() {
            return this.slotToElicit;
        }

        @Override
        public final Builder slotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
            return this;
        }

        public final void setSlotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
        }

        public final String getFulfillmentState() {
            return this.fulfillmentState;
        }

        @Override
        public final Builder fulfillmentState(String fulfillmentState) {
            this.fulfillmentState = fulfillmentState;
            return this;
        }

        @Override
        public final Builder fulfillmentState(FulfillmentState fulfillmentState) {
            this.fulfillmentState(fulfillmentState == null ? null : fulfillmentState.toString());
            return this;
        }

        public final void setFulfillmentState(String fulfillmentState) {
            this.fulfillmentState = fulfillmentState;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getMessageFormat() {
            return this.messageFormat;
        }

        @Override
        public final Builder messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        @Override
        public final Builder messageFormat(MessageFormatType messageFormat) {
            this.messageFormat(messageFormat == null ? null : messageFormat.toString());
            return this;
        }

        public final void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        public DialogAction build() {
            return new DialogAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DialogAction> {
        public Builder type(String var1);

        public Builder type(DialogActionType var1);

        public Builder intentName(String var1);

        public Builder slots(Map<String, String> var1);

        public Builder slotToElicit(String var1);

        public Builder fulfillmentState(String var1);

        public Builder fulfillmentState(FulfillmentState var1);

        public Builder message(String var1);

        public Builder messageFormat(String var1);

        public Builder messageFormat(MessageFormatType var1);
    }
}

