/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexruntime.model.ResponseCard;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResponseCardMarshaller {
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").isBinary(false).build();
    private static final MarshallingInfo<String> CONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contentType").isBinary(false).build();
    private static final MarshallingInfo<List> GENERICATTACHMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("genericAttachments").isBinary(false).build();
    private static final ResponseCardMarshaller INSTANCE = new ResponseCardMarshaller();

    private ResponseCardMarshaller() {
    }

    public static ResponseCardMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResponseCard responseCard, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)responseCard, (String)"responseCard");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)responseCard.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)responseCard.contentTypeAsString(), CONTENTTYPE_BINDING);
            protocolMarshaller.marshall(responseCard.genericAttachments(), GENERICATTACHMENTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

