/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.AudioLogSetting;
import software.amazon.awssdk.services.lexmodelsv2.model.AudioLogSettingsListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.TextLogSetting;
import software.amazon.awssdk.services.lexmodelsv2.model.TextLogSettingsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConversationLogSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConversationLogSettings> {
    private static final SdkField<List<TextLogSetting>> TEXT_LOG_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("textLogSettings").getter(ConversationLogSettings.getter(ConversationLogSettings::textLogSettings)).setter(ConversationLogSettings.setter(Builder::textLogSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textLogSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TextLogSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AudioLogSetting>> AUDIO_LOG_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("audioLogSettings").getter(ConversationLogSettings.getter(ConversationLogSettings::audioLogSettings)).setter(ConversationLogSettings.setter(Builder::audioLogSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioLogSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudioLogSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_LOG_SETTINGS_FIELD, AUDIO_LOG_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConversationLogSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<TextLogSetting> textLogSettings;
    private final List<AudioLogSetting> audioLogSettings;

    private ConversationLogSettings(BuilderImpl builder) {
        this.textLogSettings = builder.textLogSettings;
        this.audioLogSettings = builder.audioLogSettings;
    }

    public final boolean hasTextLogSettings() {
        return this.textLogSettings != null && !(this.textLogSettings instanceof SdkAutoConstructList);
    }

    public final List<TextLogSetting> textLogSettings() {
        return this.textLogSettings;
    }

    public final boolean hasAudioLogSettings() {
        return this.audioLogSettings != null && !(this.audioLogSettings instanceof SdkAutoConstructList);
    }

    public final List<AudioLogSetting> audioLogSettings() {
        return this.audioLogSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTextLogSettings() ? this.textLogSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudioLogSettings() ? this.audioLogSettings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversationLogSettings)) {
            return false;
        }
        ConversationLogSettings other = (ConversationLogSettings)obj;
        return this.hasTextLogSettings() == other.hasTextLogSettings() && Objects.equals(this.textLogSettings(), other.textLogSettings()) && this.hasAudioLogSettings() == other.hasAudioLogSettings() && Objects.equals(this.audioLogSettings(), other.audioLogSettings());
    }

    public final String toString() {
        return ToString.builder((String)"ConversationLogSettings").add("TextLogSettings", this.hasTextLogSettings() ? this.textLogSettings() : null).add("AudioLogSettings", this.hasAudioLogSettings() ? this.audioLogSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "textLogSettings": {
                return Optional.ofNullable(clazz.cast(this.textLogSettings()));
            }
            case "audioLogSettings": {
                return Optional.ofNullable(clazz.cast(this.audioLogSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("textLogSettings", TEXT_LOG_SETTINGS_FIELD);
        map.put("audioLogSettings", AUDIO_LOG_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConversationLogSettings, T> g) {
        return obj -> g.apply((ConversationLogSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TextLogSetting> textLogSettings = DefaultSdkAutoConstructList.getInstance();
        private List<AudioLogSetting> audioLogSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConversationLogSettings model) {
            this.textLogSettings(model.textLogSettings);
            this.audioLogSettings(model.audioLogSettings);
        }

        public final List<TextLogSetting.Builder> getTextLogSettings() {
            List<TextLogSetting.Builder> result = TextLogSettingsListCopier.copyToBuilder(this.textLogSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTextLogSettings(Collection<TextLogSetting.BuilderImpl> textLogSettings) {
            this.textLogSettings = TextLogSettingsListCopier.copyFromBuilder(textLogSettings);
        }

        @Override
        public final Builder textLogSettings(Collection<TextLogSetting> textLogSettings) {
            this.textLogSettings = TextLogSettingsListCopier.copy(textLogSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textLogSettings(TextLogSetting ... textLogSettings) {
            this.textLogSettings(Arrays.asList(textLogSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textLogSettings(Consumer<TextLogSetting.Builder> ... textLogSettings) {
            this.textLogSettings(Stream.of(textLogSettings).map(c -> (TextLogSetting)((TextLogSetting.Builder)TextLogSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AudioLogSetting.Builder> getAudioLogSettings() {
            List<AudioLogSetting.Builder> result = AudioLogSettingsListCopier.copyToBuilder(this.audioLogSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudioLogSettings(Collection<AudioLogSetting.BuilderImpl> audioLogSettings) {
            this.audioLogSettings = AudioLogSettingsListCopier.copyFromBuilder(audioLogSettings);
        }

        @Override
        public final Builder audioLogSettings(Collection<AudioLogSetting> audioLogSettings) {
            this.audioLogSettings = AudioLogSettingsListCopier.copy(audioLogSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioLogSettings(AudioLogSetting ... audioLogSettings) {
            this.audioLogSettings(Arrays.asList(audioLogSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioLogSettings(Consumer<AudioLogSetting.Builder> ... audioLogSettings) {
            this.audioLogSettings(Stream.of(audioLogSettings).map(c -> (AudioLogSetting)((AudioLogSetting.Builder)AudioLogSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ConversationLogSettings build() {
            return new ConversationLogSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConversationLogSettings> {
        public Builder textLogSettings(Collection<TextLogSetting> var1);

        public Builder textLogSettings(TextLogSetting ... var1);

        public Builder textLogSettings(Consumer<TextLogSetting.Builder> ... var1);

        public Builder audioLogSettings(Collection<AudioLogSetting> var1);

        public Builder audioLogSettings(AudioLogSetting ... var1);

        public Builder audioLogSettings(Consumer<AudioLogSetting.Builder> ... var1);
    }
}

