/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.PathFormat;
import software.amazon.awssdk.services.lexmodelsv2.model.TranscriptFilter;
import software.amazon.awssdk.services.lexmodelsv2.model.TranscriptFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3BucketTranscriptSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3BucketTranscriptSource> {
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3BucketName").getter(S3BucketTranscriptSource.getter(S3BucketTranscriptSource::s3BucketName)).setter(S3BucketTranscriptSource.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketName").build()}).build();
    private static final SdkField<PathFormat> PATH_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pathFormat").getter(S3BucketTranscriptSource.getter(S3BucketTranscriptSource::pathFormat)).setter(S3BucketTranscriptSource.setter(Builder::pathFormat)).constructor(PathFormat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pathFormat").build()}).build();
    private static final SdkField<String> TRANSCRIPT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transcriptFormat").getter(S3BucketTranscriptSource.getter(S3BucketTranscriptSource::transcriptFormatAsString)).setter(S3BucketTranscriptSource.setter(Builder::transcriptFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transcriptFormat").build()}).build();
    private static final SdkField<TranscriptFilter> TRANSCRIPT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("transcriptFilter").getter(S3BucketTranscriptSource.getter(S3BucketTranscriptSource::transcriptFilter)).setter(S3BucketTranscriptSource.setter(Builder::transcriptFilter)).constructor(TranscriptFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transcriptFilter").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(S3BucketTranscriptSource.getter(S3BucketTranscriptSource::kmsKeyArn)).setter(S3BucketTranscriptSource.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_NAME_FIELD, PATH_FORMAT_FIELD, TRANSCRIPT_FORMAT_FIELD, TRANSCRIPT_FILTER_FIELD, KMS_KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3BucketTranscriptSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String s3BucketName;
    private final PathFormat pathFormat;
    private final String transcriptFormat;
    private final TranscriptFilter transcriptFilter;
    private final String kmsKeyArn;

    private S3BucketTranscriptSource(BuilderImpl builder) {
        this.s3BucketName = builder.s3BucketName;
        this.pathFormat = builder.pathFormat;
        this.transcriptFormat = builder.transcriptFormat;
        this.transcriptFilter = builder.transcriptFilter;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final PathFormat pathFormat() {
        return this.pathFormat;
    }

    public final TranscriptFormat transcriptFormat() {
        return TranscriptFormat.fromValue(this.transcriptFormat);
    }

    public final String transcriptFormatAsString() {
        return this.transcriptFormat;
    }

    public final TranscriptFilter transcriptFilter() {
        return this.transcriptFilter;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.transcriptFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transcriptFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketTranscriptSource)) {
            return false;
        }
        S3BucketTranscriptSource other = (S3BucketTranscriptSource)obj;
        return Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.pathFormat(), other.pathFormat()) && Objects.equals(this.transcriptFormatAsString(), other.transcriptFormatAsString()) && Objects.equals(this.transcriptFilter(), other.transcriptFilter()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"S3BucketTranscriptSource").add("S3BucketName", (Object)this.s3BucketName()).add("PathFormat", (Object)this.pathFormat()).add("TranscriptFormat", (Object)this.transcriptFormatAsString()).add("TranscriptFilter", (Object)this.transcriptFilter()).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "pathFormat": {
                return Optional.ofNullable(clazz.cast(this.pathFormat()));
            }
            case "transcriptFormat": {
                return Optional.ofNullable(clazz.cast(this.transcriptFormatAsString()));
            }
            case "transcriptFilter": {
                return Optional.ofNullable(clazz.cast(this.transcriptFilter()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("s3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("pathFormat", PATH_FORMAT_FIELD);
        map.put("transcriptFormat", TRANSCRIPT_FORMAT_FIELD);
        map.put("transcriptFilter", TRANSCRIPT_FILTER_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3BucketTranscriptSource, T> g) {
        return obj -> g.apply((S3BucketTranscriptSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3BucketName;
        private PathFormat pathFormat;
        private String transcriptFormat;
        private TranscriptFilter transcriptFilter;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketTranscriptSource model) {
            this.s3BucketName(model.s3BucketName);
            this.pathFormat(model.pathFormat);
            this.transcriptFormat(model.transcriptFormat);
            this.transcriptFilter(model.transcriptFilter);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final PathFormat.Builder getPathFormat() {
            return this.pathFormat != null ? this.pathFormat.toBuilder() : null;
        }

        public final void setPathFormat(PathFormat.BuilderImpl pathFormat) {
            this.pathFormat = pathFormat != null ? pathFormat.build() : null;
        }

        @Override
        public final Builder pathFormat(PathFormat pathFormat) {
            this.pathFormat = pathFormat;
            return this;
        }

        public final String getTranscriptFormat() {
            return this.transcriptFormat;
        }

        public final void setTranscriptFormat(String transcriptFormat) {
            this.transcriptFormat = transcriptFormat;
        }

        @Override
        public final Builder transcriptFormat(String transcriptFormat) {
            this.transcriptFormat = transcriptFormat;
            return this;
        }

        @Override
        public final Builder transcriptFormat(TranscriptFormat transcriptFormat) {
            this.transcriptFormat(transcriptFormat == null ? null : transcriptFormat.toString());
            return this;
        }

        public final TranscriptFilter.Builder getTranscriptFilter() {
            return this.transcriptFilter != null ? this.transcriptFilter.toBuilder() : null;
        }

        public final void setTranscriptFilter(TranscriptFilter.BuilderImpl transcriptFilter) {
            this.transcriptFilter = transcriptFilter != null ? transcriptFilter.build() : null;
        }

        @Override
        public final Builder transcriptFilter(TranscriptFilter transcriptFilter) {
            this.transcriptFilter = transcriptFilter;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public S3BucketTranscriptSource build() {
            return new S3BucketTranscriptSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3BucketTranscriptSource> {
        public Builder s3BucketName(String var1);

        public Builder pathFormat(PathFormat var1);

        default public Builder pathFormat(Consumer<PathFormat.Builder> pathFormat) {
            return this.pathFormat((PathFormat)((PathFormat.Builder)PathFormat.builder().applyMutation(pathFormat)).build());
        }

        public Builder transcriptFormat(String var1);

        public Builder transcriptFormat(TranscriptFormat var1);

        public Builder transcriptFilter(TranscriptFilter var1);

        default public Builder transcriptFilter(Consumer<TranscriptFilter.Builder> transcriptFilter) {
            return this.transcriptFilter((TranscriptFilter)((TranscriptFilter.Builder)TranscriptFilter.builder().applyMutation(transcriptFilter)).build());
        }

        public Builder kmsKeyArn(String var1);
    }
}

