/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexmodelsv2.model.RuntimeHintValue;
import software.amazon.awssdk.services.lexmodelsv2.model.RuntimeHintValuesListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotHintsSlotMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuntimeHintDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuntimeHintDetails> {
    private static final SdkField<List<RuntimeHintValue>> RUNTIME_HINT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("runtimeHintValues").getter(RuntimeHintDetails.getter(RuntimeHintDetails::runtimeHintValues)).setter(RuntimeHintDetails.setter(Builder::runtimeHintValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeHintValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuntimeHintValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, RuntimeHintDetails>> SUB_SLOT_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("subSlotHints").getter(RuntimeHintDetails.getter(RuntimeHintDetails::subSlotHints)).setter(RuntimeHintDetails.setter(Builder::subSlotHints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subSlotHints").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuntimeHintDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNTIME_HINT_VALUES_FIELD, SUB_SLOT_HINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuntimeHintDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<RuntimeHintValue> runtimeHintValues;
    private final Map<String, RuntimeHintDetails> subSlotHints;

    private RuntimeHintDetails(BuilderImpl builder) {
        this.runtimeHintValues = builder.runtimeHintValues;
        this.subSlotHints = builder.subSlotHints;
    }

    public final boolean hasRuntimeHintValues() {
        return this.runtimeHintValues != null && !(this.runtimeHintValues instanceof SdkAutoConstructList);
    }

    public final List<RuntimeHintValue> runtimeHintValues() {
        return this.runtimeHintValues;
    }

    public final boolean hasSubSlotHints() {
        return this.subSlotHints != null && !(this.subSlotHints instanceof SdkAutoConstructMap);
    }

    public final Map<String, RuntimeHintDetails> subSlotHints() {
        return this.subSlotHints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuntimeHintValues() ? this.runtimeHintValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubSlotHints() ? this.subSlotHints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeHintDetails)) {
            return false;
        }
        RuntimeHintDetails other = (RuntimeHintDetails)obj;
        return this.hasRuntimeHintValues() == other.hasRuntimeHintValues() && Objects.equals(this.runtimeHintValues(), other.runtimeHintValues()) && this.hasSubSlotHints() == other.hasSubSlotHints() && Objects.equals(this.subSlotHints(), other.subSlotHints());
    }

    public final String toString() {
        return ToString.builder((String)"RuntimeHintDetails").add("RuntimeHintValues", this.hasRuntimeHintValues() ? this.runtimeHintValues() : null).add("SubSlotHints", this.hasSubSlotHints() ? this.subSlotHints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "runtimeHintValues": {
                return Optional.ofNullable(clazz.cast(this.runtimeHintValues()));
            }
            case "subSlotHints": {
                return Optional.ofNullable(clazz.cast(this.subSlotHints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("runtimeHintValues", RUNTIME_HINT_VALUES_FIELD);
        map.put("subSlotHints", SUB_SLOT_HINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuntimeHintDetails, T> g) {
        return obj -> g.apply((RuntimeHintDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RuntimeHintValue> runtimeHintValues = DefaultSdkAutoConstructList.getInstance();
        private Map<String, RuntimeHintDetails> subSlotHints = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimeHintDetails model) {
            this.runtimeHintValues(model.runtimeHintValues);
            this.subSlotHints(model.subSlotHints);
        }

        public final List<RuntimeHintValue.Builder> getRuntimeHintValues() {
            List<RuntimeHintValue.Builder> result = RuntimeHintValuesListCopier.copyToBuilder(this.runtimeHintValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuntimeHintValues(Collection<RuntimeHintValue.BuilderImpl> runtimeHintValues) {
            this.runtimeHintValues = RuntimeHintValuesListCopier.copyFromBuilder(runtimeHintValues);
        }

        @Override
        public final Builder runtimeHintValues(Collection<RuntimeHintValue> runtimeHintValues) {
            this.runtimeHintValues = RuntimeHintValuesListCopier.copy(runtimeHintValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimeHintValues(RuntimeHintValue ... runtimeHintValues) {
            this.runtimeHintValues(Arrays.asList(runtimeHintValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimeHintValues(Consumer<RuntimeHintValue.Builder> ... runtimeHintValues) {
            this.runtimeHintValues(Stream.of(runtimeHintValues).map(c -> (RuntimeHintValue)((RuntimeHintValue.Builder)RuntimeHintValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, Builder> getSubSlotHints() {
            Map<String, Builder> result = SlotHintsSlotMapCopier.copyToBuilder(this.subSlotHints);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSubSlotHints(Map<String, BuilderImpl> subSlotHints) {
            this.subSlotHints = SlotHintsSlotMapCopier.copyFromBuilder(subSlotHints);
        }

        @Override
        public final Builder subSlotHints(Map<String, RuntimeHintDetails> subSlotHints) {
            this.subSlotHints = SlotHintsSlotMapCopier.copy(subSlotHints);
            return this;
        }

        public RuntimeHintDetails build() {
            return new RuntimeHintDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuntimeHintDetails> {
        public Builder runtimeHintValues(Collection<RuntimeHintValue> var1);

        public Builder runtimeHintValues(RuntimeHintValue ... var1);

        public Builder runtimeHintValues(Consumer<RuntimeHintValue.Builder> ... var1);

        public Builder subSlotHints(Map<String, RuntimeHintDetails> var1);
    }
}

