/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexmodelsv2.model.ActiveContext;
import software.amazon.awssdk.services.lexmodelsv2.model.ActiveContextListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.RuntimeHints;
import software.amazon.awssdk.services.lexmodelsv2.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputSessionStateSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputSessionStateSpecification> {
    private static final SdkField<Map<String, String>> SESSION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sessionAttributes").getter(InputSessionStateSpecification.getter(InputSessionStateSpecification::sessionAttributes)).setter(InputSessionStateSpecification.setter(Builder::sessionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<ActiveContext>> ACTIVE_CONTEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("activeContexts").getter(InputSessionStateSpecification.getter(InputSessionStateSpecification::activeContexts)).setter(InputSessionStateSpecification.setter(Builder::activeContexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeContexts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActiveContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RuntimeHints> RUNTIME_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("runtimeHints").getter(InputSessionStateSpecification.getter(InputSessionStateSpecification::runtimeHints)).setter(InputSessionStateSpecification.setter(Builder::runtimeHints)).constructor(RuntimeHints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeHints").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ATTRIBUTES_FIELD, ACTIVE_CONTEXTS_FIELD, RUNTIME_HINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InputSessionStateSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> sessionAttributes;
    private final List<ActiveContext> activeContexts;
    private final RuntimeHints runtimeHints;

    private InputSessionStateSpecification(BuilderImpl builder) {
        this.sessionAttributes = builder.sessionAttributes;
        this.activeContexts = builder.activeContexts;
        this.runtimeHints = builder.runtimeHints;
    }

    public final boolean hasSessionAttributes() {
        return this.sessionAttributes != null && !(this.sessionAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sessionAttributes() {
        return this.sessionAttributes;
    }

    public final boolean hasActiveContexts() {
        return this.activeContexts != null && !(this.activeContexts instanceof SdkAutoConstructList);
    }

    public final List<ActiveContext> activeContexts() {
        return this.activeContexts;
    }

    public final RuntimeHints runtimeHints() {
        return this.runtimeHints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionAttributes() ? this.sessionAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActiveContexts() ? this.activeContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeHints());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSessionStateSpecification)) {
            return false;
        }
        InputSessionStateSpecification other = (InputSessionStateSpecification)obj;
        return this.hasSessionAttributes() == other.hasSessionAttributes() && Objects.equals(this.sessionAttributes(), other.sessionAttributes()) && this.hasActiveContexts() == other.hasActiveContexts() && Objects.equals(this.activeContexts(), other.activeContexts()) && Objects.equals(this.runtimeHints(), other.runtimeHints());
    }

    public final String toString() {
        return ToString.builder((String)"InputSessionStateSpecification").add("SessionAttributes", this.hasSessionAttributes() ? this.sessionAttributes() : null).add("ActiveContexts", this.hasActiveContexts() ? this.activeContexts() : null).add("RuntimeHints", (Object)this.runtimeHints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionAttributes": {
                return Optional.ofNullable(clazz.cast(this.sessionAttributes()));
            }
            case "activeContexts": {
                return Optional.ofNullable(clazz.cast(this.activeContexts()));
            }
            case "runtimeHints": {
                return Optional.ofNullable(clazz.cast(this.runtimeHints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionAttributes", SESSION_ATTRIBUTES_FIELD);
        map.put("activeContexts", ACTIVE_CONTEXTS_FIELD);
        map.put("runtimeHints", RUNTIME_HINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputSessionStateSpecification, T> g) {
        return obj -> g.apply((InputSessionStateSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> sessionAttributes = DefaultSdkAutoConstructMap.getInstance();
        private List<ActiveContext> activeContexts = DefaultSdkAutoConstructList.getInstance();
        private RuntimeHints runtimeHints;

        private BuilderImpl() {
        }

        private BuilderImpl(InputSessionStateSpecification model) {
            this.sessionAttributes(model.sessionAttributes);
            this.activeContexts(model.activeContexts);
            this.runtimeHints(model.runtimeHints);
        }

        public final Map<String, String> getSessionAttributes() {
            if (this.sessionAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sessionAttributes;
        }

        public final void setSessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
        }

        @Override
        public final Builder sessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
            return this;
        }

        public final List<ActiveContext.Builder> getActiveContexts() {
            List<ActiveContext.Builder> result = ActiveContextListCopier.copyToBuilder(this.activeContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActiveContexts(Collection<ActiveContext.BuilderImpl> activeContexts) {
            this.activeContexts = ActiveContextListCopier.copyFromBuilder(activeContexts);
        }

        @Override
        public final Builder activeContexts(Collection<ActiveContext> activeContexts) {
            this.activeContexts = ActiveContextListCopier.copy(activeContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeContexts(ActiveContext ... activeContexts) {
            this.activeContexts(Arrays.asList(activeContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeContexts(Consumer<ActiveContext.Builder> ... activeContexts) {
            this.activeContexts(Stream.of(activeContexts).map(c -> (ActiveContext)((ActiveContext.Builder)ActiveContext.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RuntimeHints.Builder getRuntimeHints() {
            return this.runtimeHints != null ? this.runtimeHints.toBuilder() : null;
        }

        public final void setRuntimeHints(RuntimeHints.BuilderImpl runtimeHints) {
            this.runtimeHints = runtimeHints != null ? runtimeHints.build() : null;
        }

        @Override
        public final Builder runtimeHints(RuntimeHints runtimeHints) {
            this.runtimeHints = runtimeHints;
            return this;
        }

        public InputSessionStateSpecification build() {
            return new InputSessionStateSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputSessionStateSpecification> {
        public Builder sessionAttributes(Map<String, String> var1);

        public Builder activeContexts(Collection<ActiveContext> var1);

        public Builder activeContexts(ActiveContext ... var1);

        public Builder activeContexts(Consumer<ActiveContext.Builder> ... var1);

        public Builder runtimeHints(RuntimeHints var1);

        default public Builder runtimeHints(Consumer<RuntimeHints.Builder> runtimeHints) {
            return this.runtimeHints((RuntimeHints)((RuntimeHints.Builder)RuntimeHints.builder().applyMutation(runtimeHints)).build());
        }
    }
}

