/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsModality;
import software.amazon.awssdk.services.lexmodelsv2.model.ConversationEndState;
import software.amazon.awssdk.services.lexmodelsv2.model.InvokedIntentSample;
import software.amazon.awssdk.services.lexmodelsv2.model.InvokedIntentSamplesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionSpecification> {
    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botAliasId").getter(SessionSpecification.getter(SessionSpecification::botAliasId)).setter(SessionSpecification.setter(Builder::botAliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(SessionSpecification.getter(SessionSpecification::botVersion)).setter(SessionSpecification.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(SessionSpecification.getter(SessionSpecification::localeId)).setter(SessionSpecification.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final SdkField<String> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channel").getter(SessionSpecification.getter(SessionSpecification::channel)).setter(SessionSpecification.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(SessionSpecification.getter(SessionSpecification::sessionId)).setter(SessionSpecification.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<Instant> CONVERSATION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("conversationStartTime").getter(SessionSpecification.getter(SessionSpecification::conversationStartTime)).setter(SessionSpecification.setter(Builder::conversationStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationStartTime").build()}).build();
    private static final SdkField<Instant> CONVERSATION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("conversationEndTime").getter(SessionSpecification.getter(SessionSpecification::conversationEndTime)).setter(SessionSpecification.setter(Builder::conversationEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationEndTime").build()}).build();
    private static final SdkField<Long> CONVERSATION_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("conversationDurationSeconds").getter(SessionSpecification.getter(SessionSpecification::conversationDurationSeconds)).setter(SessionSpecification.setter(Builder::conversationDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationDurationSeconds").build()}).build();
    private static final SdkField<String> CONVERSATION_END_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conversationEndState").getter(SessionSpecification.getter(SessionSpecification::conversationEndStateAsString)).setter(SessionSpecification.setter(Builder::conversationEndState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationEndState").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mode").getter(SessionSpecification.getter(SessionSpecification::modeAsString)).setter(SessionSpecification.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final SdkField<Long> NUMBER_OF_TURNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numberOfTurns").getter(SessionSpecification.getter(SessionSpecification::numberOfTurns)).setter(SessionSpecification.setter(Builder::numberOfTurns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfTurns").build()}).build();
    private static final SdkField<List<InvokedIntentSample>> INVOKED_INTENT_SAMPLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("invokedIntentSamples").getter(SessionSpecification.getter(SessionSpecification::invokedIntentSamples)).setter(SessionSpecification.setter(Builder::invokedIntentSamples)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invokedIntentSamples").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InvokedIntentSample::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ORIGINATING_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originatingRequestId").getter(SessionSpecification.getter(SessionSpecification::originatingRequestId)).setter(SessionSpecification.setter(Builder::originatingRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originatingRequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIAS_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, CHANNEL_FIELD, SESSION_ID_FIELD, CONVERSATION_START_TIME_FIELD, CONVERSATION_END_TIME_FIELD, CONVERSATION_DURATION_SECONDS_FIELD, CONVERSATION_END_STATE_FIELD, MODE_FIELD, NUMBER_OF_TURNS_FIELD, INVOKED_INTENT_SAMPLES_FIELD, ORIGINATING_REQUEST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("botAliasId", BOT_ALIAS_ID_FIELD);
            this.put("botVersion", BOT_VERSION_FIELD);
            this.put("localeId", LOCALE_ID_FIELD);
            this.put("channel", CHANNEL_FIELD);
            this.put("sessionId", SESSION_ID_FIELD);
            this.put("conversationStartTime", CONVERSATION_START_TIME_FIELD);
            this.put("conversationEndTime", CONVERSATION_END_TIME_FIELD);
            this.put("conversationDurationSeconds", CONVERSATION_DURATION_SECONDS_FIELD);
            this.put("conversationEndState", CONVERSATION_END_STATE_FIELD);
            this.put("mode", MODE_FIELD);
            this.put("numberOfTurns", NUMBER_OF_TURNS_FIELD);
            this.put("invokedIntentSamples", INVOKED_INTENT_SAMPLES_FIELD);
            this.put("originatingRequestId", ORIGINATING_REQUEST_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String botAliasId;
    private final String botVersion;
    private final String localeId;
    private final String channel;
    private final String sessionId;
    private final Instant conversationStartTime;
    private final Instant conversationEndTime;
    private final Long conversationDurationSeconds;
    private final String conversationEndState;
    private final String mode;
    private final Long numberOfTurns;
    private final List<InvokedIntentSample> invokedIntentSamples;
    private final String originatingRequestId;

    private SessionSpecification(BuilderImpl builder) {
        this.botAliasId = builder.botAliasId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.channel = builder.channel;
        this.sessionId = builder.sessionId;
        this.conversationStartTime = builder.conversationStartTime;
        this.conversationEndTime = builder.conversationEndTime;
        this.conversationDurationSeconds = builder.conversationDurationSeconds;
        this.conversationEndState = builder.conversationEndState;
        this.mode = builder.mode;
        this.numberOfTurns = builder.numberOfTurns;
        this.invokedIntentSamples = builder.invokedIntentSamples;
        this.originatingRequestId = builder.originatingRequestId;
    }

    public final String botAliasId() {
        return this.botAliasId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final String channel() {
        return this.channel;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final Instant conversationStartTime() {
        return this.conversationStartTime;
    }

    public final Instant conversationEndTime() {
        return this.conversationEndTime;
    }

    public final Long conversationDurationSeconds() {
        return this.conversationDurationSeconds;
    }

    public final ConversationEndState conversationEndState() {
        return ConversationEndState.fromValue(this.conversationEndState);
    }

    public final String conversationEndStateAsString() {
        return this.conversationEndState;
    }

    public final AnalyticsModality mode() {
        return AnalyticsModality.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final Long numberOfTurns() {
        return this.numberOfTurns;
    }

    public final boolean hasInvokedIntentSamples() {
        return this.invokedIntentSamples != null && !(this.invokedIntentSamples instanceof SdkAutoConstructList);
    }

    public final List<InvokedIntentSample> invokedIntentSamples() {
        return this.invokedIntentSamples;
    }

    public final String originatingRequestId() {
        return this.originatingRequestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.channel());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationEndStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfTurns());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvokedIntentSamples() ? this.invokedIntentSamples() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.originatingRequestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionSpecification)) {
            return false;
        }
        SessionSpecification other = (SessionSpecification)obj;
        return Objects.equals(this.botAliasId(), other.botAliasId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.channel(), other.channel()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.conversationStartTime(), other.conversationStartTime()) && Objects.equals(this.conversationEndTime(), other.conversationEndTime()) && Objects.equals(this.conversationDurationSeconds(), other.conversationDurationSeconds()) && Objects.equals(this.conversationEndStateAsString(), other.conversationEndStateAsString()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.numberOfTurns(), other.numberOfTurns()) && this.hasInvokedIntentSamples() == other.hasInvokedIntentSamples() && Objects.equals(this.invokedIntentSamples(), other.invokedIntentSamples()) && Objects.equals(this.originatingRequestId(), other.originatingRequestId());
    }

    public final String toString() {
        return ToString.builder((String)"SessionSpecification").add("BotAliasId", (Object)this.botAliasId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("Channel", (Object)this.channel()).add("SessionId", (Object)this.sessionId()).add("ConversationStartTime", (Object)this.conversationStartTime()).add("ConversationEndTime", (Object)this.conversationEndTime()).add("ConversationDurationSeconds", (Object)this.conversationDurationSeconds()).add("ConversationEndState", (Object)this.conversationEndStateAsString()).add("Mode", (Object)this.modeAsString()).add("NumberOfTurns", (Object)this.numberOfTurns()).add("InvokedIntentSamples", this.hasInvokedIntentSamples() ? this.invokedIntentSamples() : null).add("OriginatingRequestId", (Object)this.originatingRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botAliasId": {
                return Optional.ofNullable(clazz.cast(this.botAliasId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "channel": {
                return Optional.ofNullable(clazz.cast(this.channel()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "conversationStartTime": {
                return Optional.ofNullable(clazz.cast(this.conversationStartTime()));
            }
            case "conversationEndTime": {
                return Optional.ofNullable(clazz.cast(this.conversationEndTime()));
            }
            case "conversationDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.conversationDurationSeconds()));
            }
            case "conversationEndState": {
                return Optional.ofNullable(clazz.cast(this.conversationEndStateAsString()));
            }
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "numberOfTurns": {
                return Optional.ofNullable(clazz.cast(this.numberOfTurns()));
            }
            case "invokedIntentSamples": {
                return Optional.ofNullable(clazz.cast(this.invokedIntentSamples()));
            }
            case "originatingRequestId": {
                return Optional.ofNullable(clazz.cast(this.originatingRequestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SessionSpecification, T> g) {
        return obj -> g.apply((SessionSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String botAliasId;
        private String botVersion;
        private String localeId;
        private String channel;
        private String sessionId;
        private Instant conversationStartTime;
        private Instant conversationEndTime;
        private Long conversationDurationSeconds;
        private String conversationEndState;
        private String mode;
        private Long numberOfTurns;
        private List<InvokedIntentSample> invokedIntentSamples = DefaultSdkAutoConstructList.getInstance();
        private String originatingRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionSpecification model) {
            this.botAliasId(model.botAliasId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.channel(model.channel);
            this.sessionId(model.sessionId);
            this.conversationStartTime(model.conversationStartTime);
            this.conversationEndTime(model.conversationEndTime);
            this.conversationDurationSeconds(model.conversationDurationSeconds);
            this.conversationEndState(model.conversationEndState);
            this.mode(model.mode);
            this.numberOfTurns(model.numberOfTurns);
            this.invokedIntentSamples(model.invokedIntentSamples);
            this.originatingRequestId(model.originatingRequestId);
        }

        public final String getBotAliasId() {
            return this.botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getChannel() {
            return this.channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Instant getConversationStartTime() {
            return this.conversationStartTime;
        }

        public final void setConversationStartTime(Instant conversationStartTime) {
            this.conversationStartTime = conversationStartTime;
        }

        @Override
        public final Builder conversationStartTime(Instant conversationStartTime) {
            this.conversationStartTime = conversationStartTime;
            return this;
        }

        public final Instant getConversationEndTime() {
            return this.conversationEndTime;
        }

        public final void setConversationEndTime(Instant conversationEndTime) {
            this.conversationEndTime = conversationEndTime;
        }

        @Override
        public final Builder conversationEndTime(Instant conversationEndTime) {
            this.conversationEndTime = conversationEndTime;
            return this;
        }

        public final Long getConversationDurationSeconds() {
            return this.conversationDurationSeconds;
        }

        public final void setConversationDurationSeconds(Long conversationDurationSeconds) {
            this.conversationDurationSeconds = conversationDurationSeconds;
        }

        @Override
        public final Builder conversationDurationSeconds(Long conversationDurationSeconds) {
            this.conversationDurationSeconds = conversationDurationSeconds;
            return this;
        }

        public final String getConversationEndState() {
            return this.conversationEndState;
        }

        public final void setConversationEndState(String conversationEndState) {
            this.conversationEndState = conversationEndState;
        }

        @Override
        public final Builder conversationEndState(String conversationEndState) {
            this.conversationEndState = conversationEndState;
            return this;
        }

        @Override
        public final Builder conversationEndState(ConversationEndState conversationEndState) {
            this.conversationEndState(conversationEndState == null ? null : conversationEndState.toString());
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(AnalyticsModality mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Long getNumberOfTurns() {
            return this.numberOfTurns;
        }

        public final void setNumberOfTurns(Long numberOfTurns) {
            this.numberOfTurns = numberOfTurns;
        }

        @Override
        public final Builder numberOfTurns(Long numberOfTurns) {
            this.numberOfTurns = numberOfTurns;
            return this;
        }

        public final List<InvokedIntentSample.Builder> getInvokedIntentSamples() {
            List<InvokedIntentSample.Builder> result = InvokedIntentSamplesCopier.copyToBuilder(this.invokedIntentSamples);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvokedIntentSamples(Collection<InvokedIntentSample.BuilderImpl> invokedIntentSamples) {
            this.invokedIntentSamples = InvokedIntentSamplesCopier.copyFromBuilder(invokedIntentSamples);
        }

        @Override
        public final Builder invokedIntentSamples(Collection<InvokedIntentSample> invokedIntentSamples) {
            this.invokedIntentSamples = InvokedIntentSamplesCopier.copy(invokedIntentSamples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invokedIntentSamples(InvokedIntentSample ... invokedIntentSamples) {
            this.invokedIntentSamples(Arrays.asList(invokedIntentSamples));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invokedIntentSamples(Consumer<InvokedIntentSample.Builder> ... invokedIntentSamples) {
            this.invokedIntentSamples(Stream.of(invokedIntentSamples).map(c -> (InvokedIntentSample)((InvokedIntentSample.Builder)InvokedIntentSample.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOriginatingRequestId() {
            return this.originatingRequestId;
        }

        public final void setOriginatingRequestId(String originatingRequestId) {
            this.originatingRequestId = originatingRequestId;
        }

        @Override
        public final Builder originatingRequestId(String originatingRequestId) {
            this.originatingRequestId = originatingRequestId;
            return this;
        }

        public SessionSpecification build() {
            return new SessionSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionSpecification> {
        public Builder botAliasId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder channel(String var1);

        public Builder sessionId(String var1);

        public Builder conversationStartTime(Instant var1);

        public Builder conversationEndTime(Instant var1);

        public Builder conversationDurationSeconds(Long var1);

        public Builder conversationEndState(String var1);

        public Builder conversationEndState(ConversationEndState var1);

        public Builder mode(String var1);

        public Builder mode(AnalyticsModality var1);

        public Builder numberOfTurns(Long var1);

        public Builder invokedIntentSamples(Collection<InvokedIntentSample> var1);

        public Builder invokedIntentSamples(InvokedIntentSample ... var1);

        public Builder invokedIntentSamples(Consumer<InvokedIntentSample.Builder> ... var1);

        public Builder originatingRequestId(String var1);
    }
}

