/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatusCountMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OverallTestResultItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OverallTestResultItem> {
    private static final SdkField<Boolean> MULTI_TURN_CONVERSATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("multiTurnConversation").getter(OverallTestResultItem.getter(OverallTestResultItem::multiTurnConversation)).setter(OverallTestResultItem.setter(Builder::multiTurnConversation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiTurnConversation").build()}).build();
    private static final SdkField<Integer> TOTAL_RESULT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalResultCount").getter(OverallTestResultItem.getter(OverallTestResultItem::totalResultCount)).setter(OverallTestResultItem.setter(Builder::totalResultCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResultCount").build()}).build();
    private static final SdkField<Map<String, Integer>> SPEECH_TRANSCRIPTION_RESULT_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("speechTranscriptionResultCounts").getter(OverallTestResultItem.getter(OverallTestResultItem::speechTranscriptionResultCountsAsStrings)).setter(OverallTestResultItem.setter(Builder::speechTranscriptionResultCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechTranscriptionResultCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Integer>> END_TO_END_RESULT_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("endToEndResultCounts").getter(OverallTestResultItem.getter(OverallTestResultItem::endToEndResultCountsAsStrings)).setter(OverallTestResultItem.setter(Builder::endToEndResultCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endToEndResultCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTI_TURN_CONVERSATION_FIELD, TOTAL_RESULT_COUNT_FIELD, SPEECH_TRANSCRIPTION_RESULT_COUNTS_FIELD, END_TO_END_RESULT_COUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("multiTurnConversation", MULTI_TURN_CONVERSATION_FIELD);
            this.put("totalResultCount", TOTAL_RESULT_COUNT_FIELD);
            this.put("speechTranscriptionResultCounts", SPEECH_TRANSCRIPTION_RESULT_COUNTS_FIELD);
            this.put("endToEndResultCounts", END_TO_END_RESULT_COUNTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean multiTurnConversation;
    private final Integer totalResultCount;
    private final Map<String, Integer> speechTranscriptionResultCounts;
    private final Map<String, Integer> endToEndResultCounts;

    private OverallTestResultItem(BuilderImpl builder) {
        this.multiTurnConversation = builder.multiTurnConversation;
        this.totalResultCount = builder.totalResultCount;
        this.speechTranscriptionResultCounts = builder.speechTranscriptionResultCounts;
        this.endToEndResultCounts = builder.endToEndResultCounts;
    }

    public final Boolean multiTurnConversation() {
        return this.multiTurnConversation;
    }

    public final Integer totalResultCount() {
        return this.totalResultCount;
    }

    public final Map<TestResultMatchStatus, Integer> speechTranscriptionResultCounts() {
        return TestResultMatchStatusCountMapCopier.copyStringToEnum(this.speechTranscriptionResultCounts);
    }

    public final boolean hasSpeechTranscriptionResultCounts() {
        return this.speechTranscriptionResultCounts != null && !(this.speechTranscriptionResultCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> speechTranscriptionResultCountsAsStrings() {
        return this.speechTranscriptionResultCounts;
    }

    public final Map<TestResultMatchStatus, Integer> endToEndResultCounts() {
        return TestResultMatchStatusCountMapCopier.copyStringToEnum(this.endToEndResultCounts);
    }

    public final boolean hasEndToEndResultCounts() {
        return this.endToEndResultCounts != null && !(this.endToEndResultCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> endToEndResultCountsAsStrings() {
        return this.endToEndResultCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.multiTurnConversation());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResultCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpeechTranscriptionResultCounts() ? this.speechTranscriptionResultCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndToEndResultCounts() ? this.endToEndResultCountsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OverallTestResultItem)) {
            return false;
        }
        OverallTestResultItem other = (OverallTestResultItem)obj;
        return Objects.equals(this.multiTurnConversation(), other.multiTurnConversation()) && Objects.equals(this.totalResultCount(), other.totalResultCount()) && this.hasSpeechTranscriptionResultCounts() == other.hasSpeechTranscriptionResultCounts() && Objects.equals(this.speechTranscriptionResultCountsAsStrings(), other.speechTranscriptionResultCountsAsStrings()) && this.hasEndToEndResultCounts() == other.hasEndToEndResultCounts() && Objects.equals(this.endToEndResultCountsAsStrings(), other.endToEndResultCountsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"OverallTestResultItem").add("MultiTurnConversation", (Object)this.multiTurnConversation()).add("TotalResultCount", (Object)this.totalResultCount()).add("SpeechTranscriptionResultCounts", this.hasSpeechTranscriptionResultCounts() ? this.speechTranscriptionResultCountsAsStrings() : null).add("EndToEndResultCounts", this.hasEndToEndResultCounts() ? this.endToEndResultCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "multiTurnConversation": {
                return Optional.ofNullable(clazz.cast(this.multiTurnConversation()));
            }
            case "totalResultCount": {
                return Optional.ofNullable(clazz.cast(this.totalResultCount()));
            }
            case "speechTranscriptionResultCounts": {
                return Optional.ofNullable(clazz.cast(this.speechTranscriptionResultCountsAsStrings()));
            }
            case "endToEndResultCounts": {
                return Optional.ofNullable(clazz.cast(this.endToEndResultCountsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OverallTestResultItem, T> g) {
        return obj -> g.apply((OverallTestResultItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean multiTurnConversation;
        private Integer totalResultCount;
        private Map<String, Integer> speechTranscriptionResultCounts = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Integer> endToEndResultCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OverallTestResultItem model) {
            this.multiTurnConversation(model.multiTurnConversation);
            this.totalResultCount(model.totalResultCount);
            this.speechTranscriptionResultCountsWithStrings(model.speechTranscriptionResultCounts);
            this.endToEndResultCountsWithStrings(model.endToEndResultCounts);
        }

        public final Boolean getMultiTurnConversation() {
            return this.multiTurnConversation;
        }

        public final void setMultiTurnConversation(Boolean multiTurnConversation) {
            this.multiTurnConversation = multiTurnConversation;
        }

        @Override
        public final Builder multiTurnConversation(Boolean multiTurnConversation) {
            this.multiTurnConversation = multiTurnConversation;
            return this;
        }

        public final Integer getTotalResultCount() {
            return this.totalResultCount;
        }

        public final void setTotalResultCount(Integer totalResultCount) {
            this.totalResultCount = totalResultCount;
        }

        @Override
        public final Builder totalResultCount(Integer totalResultCount) {
            this.totalResultCount = totalResultCount;
            return this;
        }

        public final Map<String, Integer> getSpeechTranscriptionResultCounts() {
            if (this.speechTranscriptionResultCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.speechTranscriptionResultCounts;
        }

        public final void setSpeechTranscriptionResultCounts(Map<String, Integer> speechTranscriptionResultCounts) {
            this.speechTranscriptionResultCounts = TestResultMatchStatusCountMapCopier.copy(speechTranscriptionResultCounts);
        }

        @Override
        public final Builder speechTranscriptionResultCountsWithStrings(Map<String, Integer> speechTranscriptionResultCounts) {
            this.speechTranscriptionResultCounts = TestResultMatchStatusCountMapCopier.copy(speechTranscriptionResultCounts);
            return this;
        }

        @Override
        public final Builder speechTranscriptionResultCounts(Map<TestResultMatchStatus, Integer> speechTranscriptionResultCounts) {
            this.speechTranscriptionResultCounts = TestResultMatchStatusCountMapCopier.copyEnumToString(speechTranscriptionResultCounts);
            return this;
        }

        public final Map<String, Integer> getEndToEndResultCounts() {
            if (this.endToEndResultCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.endToEndResultCounts;
        }

        public final void setEndToEndResultCounts(Map<String, Integer> endToEndResultCounts) {
            this.endToEndResultCounts = TestResultMatchStatusCountMapCopier.copy(endToEndResultCounts);
        }

        @Override
        public final Builder endToEndResultCountsWithStrings(Map<String, Integer> endToEndResultCounts) {
            this.endToEndResultCounts = TestResultMatchStatusCountMapCopier.copy(endToEndResultCounts);
            return this;
        }

        @Override
        public final Builder endToEndResultCounts(Map<TestResultMatchStatus, Integer> endToEndResultCounts) {
            this.endToEndResultCounts = TestResultMatchStatusCountMapCopier.copyEnumToString(endToEndResultCounts);
            return this;
        }

        public OverallTestResultItem build() {
            return new OverallTestResultItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OverallTestResultItem> {
        public Builder multiTurnConversation(Boolean var1);

        public Builder totalResultCount(Integer var1);

        public Builder speechTranscriptionResultCountsWithStrings(Map<String, Integer> var1);

        public Builder speechTranscriptionResultCounts(Map<TestResultMatchStatus, Integer> var1);

        public Builder endToEndResultCountsWithStrings(Map<String, Integer> var1);

        public Builder endToEndResultCounts(Map<TestResultMatchStatus, Integer> var1);
    }
}

