/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.ConditionalSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.DialogCodeHookInvocationSetting;
import software.amazon.awssdk.services.lexmodelsv2.model.DialogState;
import software.amazon.awssdk.services.lexmodelsv2.model.ElicitationCodeHookInvocationSetting;
import software.amazon.awssdk.services.lexmodelsv2.model.PromptSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.ResponseSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IntentConfirmationSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IntentConfirmationSetting> {
    private static final SdkField<PromptSpecification> PROMPT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("promptSpecification").getter(IntentConfirmationSetting.getter(IntentConfirmationSetting::promptSpecification)).setter(IntentConfirmationSetting.setter(Builder::promptSpecification)).constructor(PromptSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptSpecification").build()}).build();
    private static final SdkField<ResponseSpecification> DECLINATION_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("declinationResponse").getter(IntentConfirmationSetting.getter(IntentConfirmationSetting::declinationResponse)).setter(IntentConfirmationSetting.setter(Builder::declinationResponse)).constructor(ResponseSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("declinationResponse").build()}).build();
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("active").getter(IntentConfirmationSetting.getter(IntentConfirmationSetting::active)).setter(IntentConfirmationSetting.setter(Builder::active)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()}).build();
    private static final SdkField<ResponseSpecification> CONFIRMATION_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("confirmationResponse").getter(IntentConfirmationSetting.getter(IntentConfirmationSetting::confirmationResponse)).setter(IntentConfirmationSetting.setter(Builder::confirmationResponse)).constructor(ResponseSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationResponse").build()}).build();
    private static final SdkField<DialogState> CONFIRMATION_NEXT_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("confirmationNextStep").getter(IntentConfirmationSetting.getter(IntentConfirmationSetting::confirmationNextStep)).setter(IntentConfirmationSetting.setter(Builder::confirmationNextStep)).constructor(DialogState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationNextStep").build()}).build();
    private static final SdkField<ConditionalSpecification> CONFIRMATION_CONDITIONAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("confirmationConditional").getter(IntentConfirmationSetting.getter(IntentConfirmationSetting::confirmationConditional)).setter(IntentConfirmationSetting.setter(Builder::confirmationConditional)).constructor(ConditionalSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationConditional").build()}).build();
    private static final SdkField<DialogState> DECLINATION_NEXT_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("declinationNextStep").getter(IntentConfirmationSetting.getter(IntentConfirmationSetting::declinationNextStep)).setter(IntentConfirmationSetting.setter(Builder::declinationNextStep)).constructor(DialogState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("declinationNextStep").build()}).build();
    private static final SdkField<ConditionalSpecification> DECLINATION_CONDITIONAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("declinationConditional").getter(IntentConfirmationSetting.getter(IntentConfirmationSetting::declinationConditional)).setter(IntentConfirmationSetting.setter(Builder::declinationConditional)).constructor(ConditionalSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("declinationConditional").build()}).build();
    private static final SdkField<ResponseSpecification> FAILURE_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("failureResponse").getter(IntentConfirmationSetting.getter(IntentConfirmationSetting::failureResponse)).setter(IntentConfirmationSetting.setter(Builder::failureResponse)).constructor(ResponseSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureResponse").build()}).build();
    private static final SdkField<DialogState> FAILURE_NEXT_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("failureNextStep").getter(IntentConfirmationSetting.getter(IntentConfirmationSetting::failureNextStep)).setter(IntentConfirmationSetting.setter(Builder::failureNextStep)).constructor(DialogState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureNextStep").build()}).build();
    private static final SdkField<ConditionalSpecification> FAILURE_CONDITIONAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("failureConditional").getter(IntentConfirmationSetting.getter(IntentConfirmationSetting::failureConditional)).setter(IntentConfirmationSetting.setter(Builder::failureConditional)).constructor(ConditionalSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureConditional").build()}).build();
    private static final SdkField<DialogCodeHookInvocationSetting> CODE_HOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("codeHook").getter(IntentConfirmationSetting.getter(IntentConfirmationSetting::codeHook)).setter(IntentConfirmationSetting.setter(Builder::codeHook)).constructor(DialogCodeHookInvocationSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeHook").build()}).build();
    private static final SdkField<ElicitationCodeHookInvocationSetting> ELICITATION_CODE_HOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("elicitationCodeHook").getter(IntentConfirmationSetting.getter(IntentConfirmationSetting::elicitationCodeHook)).setter(IntentConfirmationSetting.setter(Builder::elicitationCodeHook)).constructor(ElicitationCodeHookInvocationSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elicitationCodeHook").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_SPECIFICATION_FIELD, DECLINATION_RESPONSE_FIELD, ACTIVE_FIELD, CONFIRMATION_RESPONSE_FIELD, CONFIRMATION_NEXT_STEP_FIELD, CONFIRMATION_CONDITIONAL_FIELD, DECLINATION_NEXT_STEP_FIELD, DECLINATION_CONDITIONAL_FIELD, FAILURE_RESPONSE_FIELD, FAILURE_NEXT_STEP_FIELD, FAILURE_CONDITIONAL_FIELD, CODE_HOOK_FIELD, ELICITATION_CODE_HOOK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("promptSpecification", PROMPT_SPECIFICATION_FIELD);
            this.put("declinationResponse", DECLINATION_RESPONSE_FIELD);
            this.put("active", ACTIVE_FIELD);
            this.put("confirmationResponse", CONFIRMATION_RESPONSE_FIELD);
            this.put("confirmationNextStep", CONFIRMATION_NEXT_STEP_FIELD);
            this.put("confirmationConditional", CONFIRMATION_CONDITIONAL_FIELD);
            this.put("declinationNextStep", DECLINATION_NEXT_STEP_FIELD);
            this.put("declinationConditional", DECLINATION_CONDITIONAL_FIELD);
            this.put("failureResponse", FAILURE_RESPONSE_FIELD);
            this.put("failureNextStep", FAILURE_NEXT_STEP_FIELD);
            this.put("failureConditional", FAILURE_CONDITIONAL_FIELD);
            this.put("codeHook", CODE_HOOK_FIELD);
            this.put("elicitationCodeHook", ELICITATION_CODE_HOOK_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final PromptSpecification promptSpecification;
    private final ResponseSpecification declinationResponse;
    private final Boolean active;
    private final ResponseSpecification confirmationResponse;
    private final DialogState confirmationNextStep;
    private final ConditionalSpecification confirmationConditional;
    private final DialogState declinationNextStep;
    private final ConditionalSpecification declinationConditional;
    private final ResponseSpecification failureResponse;
    private final DialogState failureNextStep;
    private final ConditionalSpecification failureConditional;
    private final DialogCodeHookInvocationSetting codeHook;
    private final ElicitationCodeHookInvocationSetting elicitationCodeHook;

    private IntentConfirmationSetting(BuilderImpl builder) {
        this.promptSpecification = builder.promptSpecification;
        this.declinationResponse = builder.declinationResponse;
        this.active = builder.active;
        this.confirmationResponse = builder.confirmationResponse;
        this.confirmationNextStep = builder.confirmationNextStep;
        this.confirmationConditional = builder.confirmationConditional;
        this.declinationNextStep = builder.declinationNextStep;
        this.declinationConditional = builder.declinationConditional;
        this.failureResponse = builder.failureResponse;
        this.failureNextStep = builder.failureNextStep;
        this.failureConditional = builder.failureConditional;
        this.codeHook = builder.codeHook;
        this.elicitationCodeHook = builder.elicitationCodeHook;
    }

    public final PromptSpecification promptSpecification() {
        return this.promptSpecification;
    }

    public final ResponseSpecification declinationResponse() {
        return this.declinationResponse;
    }

    public final Boolean active() {
        return this.active;
    }

    public final ResponseSpecification confirmationResponse() {
        return this.confirmationResponse;
    }

    public final DialogState confirmationNextStep() {
        return this.confirmationNextStep;
    }

    public final ConditionalSpecification confirmationConditional() {
        return this.confirmationConditional;
    }

    public final DialogState declinationNextStep() {
        return this.declinationNextStep;
    }

    public final ConditionalSpecification declinationConditional() {
        return this.declinationConditional;
    }

    public final ResponseSpecification failureResponse() {
        return this.failureResponse;
    }

    public final DialogState failureNextStep() {
        return this.failureNextStep;
    }

    public final ConditionalSpecification failureConditional() {
        return this.failureConditional;
    }

    public final DialogCodeHookInvocationSetting codeHook() {
        return this.codeHook;
    }

    public final ElicitationCodeHookInvocationSetting elicitationCodeHook() {
        return this.elicitationCodeHook;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.promptSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.declinationResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.active());
        hashCode = 31 * hashCode + Objects.hashCode(this.confirmationResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.confirmationNextStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.confirmationConditional());
        hashCode = 31 * hashCode + Objects.hashCode(this.declinationNextStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.declinationConditional());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureNextStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureConditional());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeHook());
        hashCode = 31 * hashCode + Objects.hashCode(this.elicitationCodeHook());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntentConfirmationSetting)) {
            return false;
        }
        IntentConfirmationSetting other = (IntentConfirmationSetting)obj;
        return Objects.equals(this.promptSpecification(), other.promptSpecification()) && Objects.equals(this.declinationResponse(), other.declinationResponse()) && Objects.equals(this.active(), other.active()) && Objects.equals(this.confirmationResponse(), other.confirmationResponse()) && Objects.equals(this.confirmationNextStep(), other.confirmationNextStep()) && Objects.equals(this.confirmationConditional(), other.confirmationConditional()) && Objects.equals(this.declinationNextStep(), other.declinationNextStep()) && Objects.equals(this.declinationConditional(), other.declinationConditional()) && Objects.equals(this.failureResponse(), other.failureResponse()) && Objects.equals(this.failureNextStep(), other.failureNextStep()) && Objects.equals(this.failureConditional(), other.failureConditional()) && Objects.equals(this.codeHook(), other.codeHook()) && Objects.equals(this.elicitationCodeHook(), other.elicitationCodeHook());
    }

    public final String toString() {
        return ToString.builder((String)"IntentConfirmationSetting").add("PromptSpecification", (Object)this.promptSpecification()).add("DeclinationResponse", (Object)this.declinationResponse()).add("Active", (Object)this.active()).add("ConfirmationResponse", (Object)this.confirmationResponse()).add("ConfirmationNextStep", (Object)this.confirmationNextStep()).add("ConfirmationConditional", (Object)this.confirmationConditional()).add("DeclinationNextStep", (Object)this.declinationNextStep()).add("DeclinationConditional", (Object)this.declinationConditional()).add("FailureResponse", (Object)this.failureResponse()).add("FailureNextStep", (Object)this.failureNextStep()).add("FailureConditional", (Object)this.failureConditional()).add("CodeHook", (Object)this.codeHook()).add("ElicitationCodeHook", (Object)this.elicitationCodeHook()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "promptSpecification": {
                return Optional.ofNullable(clazz.cast(this.promptSpecification()));
            }
            case "declinationResponse": {
                return Optional.ofNullable(clazz.cast(this.declinationResponse()));
            }
            case "active": {
                return Optional.ofNullable(clazz.cast(this.active()));
            }
            case "confirmationResponse": {
                return Optional.ofNullable(clazz.cast(this.confirmationResponse()));
            }
            case "confirmationNextStep": {
                return Optional.ofNullable(clazz.cast(this.confirmationNextStep()));
            }
            case "confirmationConditional": {
                return Optional.ofNullable(clazz.cast(this.confirmationConditional()));
            }
            case "declinationNextStep": {
                return Optional.ofNullable(clazz.cast(this.declinationNextStep()));
            }
            case "declinationConditional": {
                return Optional.ofNullable(clazz.cast(this.declinationConditional()));
            }
            case "failureResponse": {
                return Optional.ofNullable(clazz.cast(this.failureResponse()));
            }
            case "failureNextStep": {
                return Optional.ofNullable(clazz.cast(this.failureNextStep()));
            }
            case "failureConditional": {
                return Optional.ofNullable(clazz.cast(this.failureConditional()));
            }
            case "codeHook": {
                return Optional.ofNullable(clazz.cast(this.codeHook()));
            }
            case "elicitationCodeHook": {
                return Optional.ofNullable(clazz.cast(this.elicitationCodeHook()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IntentConfirmationSetting, T> g) {
        return obj -> g.apply((IntentConfirmationSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PromptSpecification promptSpecification;
        private ResponseSpecification declinationResponse;
        private Boolean active;
        private ResponseSpecification confirmationResponse;
        private DialogState confirmationNextStep;
        private ConditionalSpecification confirmationConditional;
        private DialogState declinationNextStep;
        private ConditionalSpecification declinationConditional;
        private ResponseSpecification failureResponse;
        private DialogState failureNextStep;
        private ConditionalSpecification failureConditional;
        private DialogCodeHookInvocationSetting codeHook;
        private ElicitationCodeHookInvocationSetting elicitationCodeHook;

        private BuilderImpl() {
        }

        private BuilderImpl(IntentConfirmationSetting model) {
            this.promptSpecification(model.promptSpecification);
            this.declinationResponse(model.declinationResponse);
            this.active(model.active);
            this.confirmationResponse(model.confirmationResponse);
            this.confirmationNextStep(model.confirmationNextStep);
            this.confirmationConditional(model.confirmationConditional);
            this.declinationNextStep(model.declinationNextStep);
            this.declinationConditional(model.declinationConditional);
            this.failureResponse(model.failureResponse);
            this.failureNextStep(model.failureNextStep);
            this.failureConditional(model.failureConditional);
            this.codeHook(model.codeHook);
            this.elicitationCodeHook(model.elicitationCodeHook);
        }

        public final PromptSpecification.Builder getPromptSpecification() {
            return this.promptSpecification != null ? this.promptSpecification.toBuilder() : null;
        }

        public final void setPromptSpecification(PromptSpecification.BuilderImpl promptSpecification) {
            this.promptSpecification = promptSpecification != null ? promptSpecification.build() : null;
        }

        @Override
        public final Builder promptSpecification(PromptSpecification promptSpecification) {
            this.promptSpecification = promptSpecification;
            return this;
        }

        public final ResponseSpecification.Builder getDeclinationResponse() {
            return this.declinationResponse != null ? this.declinationResponse.toBuilder() : null;
        }

        public final void setDeclinationResponse(ResponseSpecification.BuilderImpl declinationResponse) {
            this.declinationResponse = declinationResponse != null ? declinationResponse.build() : null;
        }

        @Override
        public final Builder declinationResponse(ResponseSpecification declinationResponse) {
            this.declinationResponse = declinationResponse;
            return this;
        }

        public final Boolean getActive() {
            return this.active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final ResponseSpecification.Builder getConfirmationResponse() {
            return this.confirmationResponse != null ? this.confirmationResponse.toBuilder() : null;
        }

        public final void setConfirmationResponse(ResponseSpecification.BuilderImpl confirmationResponse) {
            this.confirmationResponse = confirmationResponse != null ? confirmationResponse.build() : null;
        }

        @Override
        public final Builder confirmationResponse(ResponseSpecification confirmationResponse) {
            this.confirmationResponse = confirmationResponse;
            return this;
        }

        public final DialogState.Builder getConfirmationNextStep() {
            return this.confirmationNextStep != null ? this.confirmationNextStep.toBuilder() : null;
        }

        public final void setConfirmationNextStep(DialogState.BuilderImpl confirmationNextStep) {
            this.confirmationNextStep = confirmationNextStep != null ? confirmationNextStep.build() : null;
        }

        @Override
        public final Builder confirmationNextStep(DialogState confirmationNextStep) {
            this.confirmationNextStep = confirmationNextStep;
            return this;
        }

        public final ConditionalSpecification.Builder getConfirmationConditional() {
            return this.confirmationConditional != null ? this.confirmationConditional.toBuilder() : null;
        }

        public final void setConfirmationConditional(ConditionalSpecification.BuilderImpl confirmationConditional) {
            this.confirmationConditional = confirmationConditional != null ? confirmationConditional.build() : null;
        }

        @Override
        public final Builder confirmationConditional(ConditionalSpecification confirmationConditional) {
            this.confirmationConditional = confirmationConditional;
            return this;
        }

        public final DialogState.Builder getDeclinationNextStep() {
            return this.declinationNextStep != null ? this.declinationNextStep.toBuilder() : null;
        }

        public final void setDeclinationNextStep(DialogState.BuilderImpl declinationNextStep) {
            this.declinationNextStep = declinationNextStep != null ? declinationNextStep.build() : null;
        }

        @Override
        public final Builder declinationNextStep(DialogState declinationNextStep) {
            this.declinationNextStep = declinationNextStep;
            return this;
        }

        public final ConditionalSpecification.Builder getDeclinationConditional() {
            return this.declinationConditional != null ? this.declinationConditional.toBuilder() : null;
        }

        public final void setDeclinationConditional(ConditionalSpecification.BuilderImpl declinationConditional) {
            this.declinationConditional = declinationConditional != null ? declinationConditional.build() : null;
        }

        @Override
        public final Builder declinationConditional(ConditionalSpecification declinationConditional) {
            this.declinationConditional = declinationConditional;
            return this;
        }

        public final ResponseSpecification.Builder getFailureResponse() {
            return this.failureResponse != null ? this.failureResponse.toBuilder() : null;
        }

        public final void setFailureResponse(ResponseSpecification.BuilderImpl failureResponse) {
            this.failureResponse = failureResponse != null ? failureResponse.build() : null;
        }

        @Override
        public final Builder failureResponse(ResponseSpecification failureResponse) {
            this.failureResponse = failureResponse;
            return this;
        }

        public final DialogState.Builder getFailureNextStep() {
            return this.failureNextStep != null ? this.failureNextStep.toBuilder() : null;
        }

        public final void setFailureNextStep(DialogState.BuilderImpl failureNextStep) {
            this.failureNextStep = failureNextStep != null ? failureNextStep.build() : null;
        }

        @Override
        public final Builder failureNextStep(DialogState failureNextStep) {
            this.failureNextStep = failureNextStep;
            return this;
        }

        public final ConditionalSpecification.Builder getFailureConditional() {
            return this.failureConditional != null ? this.failureConditional.toBuilder() : null;
        }

        public final void setFailureConditional(ConditionalSpecification.BuilderImpl failureConditional) {
            this.failureConditional = failureConditional != null ? failureConditional.build() : null;
        }

        @Override
        public final Builder failureConditional(ConditionalSpecification failureConditional) {
            this.failureConditional = failureConditional;
            return this;
        }

        public final DialogCodeHookInvocationSetting.Builder getCodeHook() {
            return this.codeHook != null ? this.codeHook.toBuilder() : null;
        }

        public final void setCodeHook(DialogCodeHookInvocationSetting.BuilderImpl codeHook) {
            this.codeHook = codeHook != null ? codeHook.build() : null;
        }

        @Override
        public final Builder codeHook(DialogCodeHookInvocationSetting codeHook) {
            this.codeHook = codeHook;
            return this;
        }

        public final ElicitationCodeHookInvocationSetting.Builder getElicitationCodeHook() {
            return this.elicitationCodeHook != null ? this.elicitationCodeHook.toBuilder() : null;
        }

        public final void setElicitationCodeHook(ElicitationCodeHookInvocationSetting.BuilderImpl elicitationCodeHook) {
            this.elicitationCodeHook = elicitationCodeHook != null ? elicitationCodeHook.build() : null;
        }

        @Override
        public final Builder elicitationCodeHook(ElicitationCodeHookInvocationSetting elicitationCodeHook) {
            this.elicitationCodeHook = elicitationCodeHook;
            return this;
        }

        public IntentConfirmationSetting build() {
            return new IntentConfirmationSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IntentConfirmationSetting> {
        public Builder promptSpecification(PromptSpecification var1);

        default public Builder promptSpecification(Consumer<PromptSpecification.Builder> promptSpecification) {
            return this.promptSpecification((PromptSpecification)((PromptSpecification.Builder)PromptSpecification.builder().applyMutation(promptSpecification)).build());
        }

        public Builder declinationResponse(ResponseSpecification var1);

        default public Builder declinationResponse(Consumer<ResponseSpecification.Builder> declinationResponse) {
            return this.declinationResponse((ResponseSpecification)((ResponseSpecification.Builder)ResponseSpecification.builder().applyMutation(declinationResponse)).build());
        }

        public Builder active(Boolean var1);

        public Builder confirmationResponse(ResponseSpecification var1);

        default public Builder confirmationResponse(Consumer<ResponseSpecification.Builder> confirmationResponse) {
            return this.confirmationResponse((ResponseSpecification)((ResponseSpecification.Builder)ResponseSpecification.builder().applyMutation(confirmationResponse)).build());
        }

        public Builder confirmationNextStep(DialogState var1);

        default public Builder confirmationNextStep(Consumer<DialogState.Builder> confirmationNextStep) {
            return this.confirmationNextStep((DialogState)((DialogState.Builder)DialogState.builder().applyMutation(confirmationNextStep)).build());
        }

        public Builder confirmationConditional(ConditionalSpecification var1);

        default public Builder confirmationConditional(Consumer<ConditionalSpecification.Builder> confirmationConditional) {
            return this.confirmationConditional((ConditionalSpecification)((ConditionalSpecification.Builder)ConditionalSpecification.builder().applyMutation(confirmationConditional)).build());
        }

        public Builder declinationNextStep(DialogState var1);

        default public Builder declinationNextStep(Consumer<DialogState.Builder> declinationNextStep) {
            return this.declinationNextStep((DialogState)((DialogState.Builder)DialogState.builder().applyMutation(declinationNextStep)).build());
        }

        public Builder declinationConditional(ConditionalSpecification var1);

        default public Builder declinationConditional(Consumer<ConditionalSpecification.Builder> declinationConditional) {
            return this.declinationConditional((ConditionalSpecification)((ConditionalSpecification.Builder)ConditionalSpecification.builder().applyMutation(declinationConditional)).build());
        }

        public Builder failureResponse(ResponseSpecification var1);

        default public Builder failureResponse(Consumer<ResponseSpecification.Builder> failureResponse) {
            return this.failureResponse((ResponseSpecification)((ResponseSpecification.Builder)ResponseSpecification.builder().applyMutation(failureResponse)).build());
        }

        public Builder failureNextStep(DialogState var1);

        default public Builder failureNextStep(Consumer<DialogState.Builder> failureNextStep) {
            return this.failureNextStep((DialogState)((DialogState.Builder)DialogState.builder().applyMutation(failureNextStep)).build());
        }

        public Builder failureConditional(ConditionalSpecification var1);

        default public Builder failureConditional(Consumer<ConditionalSpecification.Builder> failureConditional) {
            return this.failureConditional((ConditionalSpecification)((ConditionalSpecification.Builder)ConditionalSpecification.builder().applyMutation(failureConditional)).build());
        }

        public Builder codeHook(DialogCodeHookInvocationSetting var1);

        default public Builder codeHook(Consumer<DialogCodeHookInvocationSetting.Builder> codeHook) {
            return this.codeHook((DialogCodeHookInvocationSetting)((DialogCodeHookInvocationSetting.Builder)DialogCodeHookInvocationSetting.builder().applyMutation(codeHook)).build());
        }

        public Builder elicitationCodeHook(ElicitationCodeHookInvocationSetting var1);

        default public Builder elicitationCodeHook(Consumer<ElicitationCodeHookInvocationSetting.Builder> elicitationCodeHook) {
            return this.elicitationCodeHook((ElicitationCodeHookInvocationSetting)((ElicitationCodeHookInvocationSetting.Builder)ElicitationCodeHookInvocationSetting.builder().applyMutation(elicitationCodeHook)).build());
        }
    }
}

