/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsNodeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalyticsIntentNodeSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalyticsIntentNodeSummary> {
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intentName").getter(AnalyticsIntentNodeSummary.getter(AnalyticsIntentNodeSummary::intentName)).setter(AnalyticsIntentNodeSummary.setter(Builder::intentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()}).build();
    private static final SdkField<String> INTENT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intentPath").getter(AnalyticsIntentNodeSummary.getter(AnalyticsIntentNodeSummary::intentPath)).setter(AnalyticsIntentNodeSummary.setter(Builder::intentPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentPath").build()}).build();
    private static final SdkField<Integer> INTENT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("intentCount").getter(AnalyticsIntentNodeSummary.getter(AnalyticsIntentNodeSummary::intentCount)).setter(AnalyticsIntentNodeSummary.setter(Builder::intentCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentCount").build()}).build();
    private static final SdkField<Integer> INTENT_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("intentLevel").getter(AnalyticsIntentNodeSummary.getter(AnalyticsIntentNodeSummary::intentLevel)).setter(AnalyticsIntentNodeSummary.setter(Builder::intentLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentLevel").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeType").getter(AnalyticsIntentNodeSummary.getter(AnalyticsIntentNodeSummary::nodeTypeAsString)).setter(AnalyticsIntentNodeSummary.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_NAME_FIELD, INTENT_PATH_FIELD, INTENT_COUNT_FIELD, INTENT_LEVEL_FIELD, NODE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("intentName", INTENT_NAME_FIELD);
            this.put("intentPath", INTENT_PATH_FIELD);
            this.put("intentCount", INTENT_COUNT_FIELD);
            this.put("intentLevel", INTENT_LEVEL_FIELD);
            this.put("nodeType", NODE_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String intentName;
    private final String intentPath;
    private final Integer intentCount;
    private final Integer intentLevel;
    private final String nodeType;

    private AnalyticsIntentNodeSummary(BuilderImpl builder) {
        this.intentName = builder.intentName;
        this.intentPath = builder.intentPath;
        this.intentCount = builder.intentCount;
        this.intentLevel = builder.intentLevel;
        this.nodeType = builder.nodeType;
    }

    public final String intentName() {
        return this.intentName;
    }

    public final String intentPath() {
        return this.intentPath;
    }

    public final Integer intentCount() {
        return this.intentCount;
    }

    public final Integer intentLevel() {
        return this.intentLevel;
    }

    public final AnalyticsNodeType nodeType() {
        return AnalyticsNodeType.fromValue(this.nodeType);
    }

    public final String nodeTypeAsString() {
        return this.nodeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsIntentNodeSummary)) {
            return false;
        }
        AnalyticsIntentNodeSummary other = (AnalyticsIntentNodeSummary)obj;
        return Objects.equals(this.intentName(), other.intentName()) && Objects.equals(this.intentPath(), other.intentPath()) && Objects.equals(this.intentCount(), other.intentCount()) && Objects.equals(this.intentLevel(), other.intentLevel()) && Objects.equals(this.nodeTypeAsString(), other.nodeTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AnalyticsIntentNodeSummary").add("IntentName", (Object)this.intentName()).add("IntentPath", (Object)this.intentPath()).add("IntentCount", (Object)this.intentCount()).add("IntentLevel", (Object)this.intentLevel()).add("NodeType", (Object)this.nodeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "intentName": {
                return Optional.ofNullable(clazz.cast(this.intentName()));
            }
            case "intentPath": {
                return Optional.ofNullable(clazz.cast(this.intentPath()));
            }
            case "intentCount": {
                return Optional.ofNullable(clazz.cast(this.intentCount()));
            }
            case "intentLevel": {
                return Optional.ofNullable(clazz.cast(this.intentLevel()));
            }
            case "nodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsIntentNodeSummary, T> g) {
        return obj -> g.apply((AnalyticsIntentNodeSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String intentName;
        private String intentPath;
        private Integer intentCount;
        private Integer intentLevel;
        private String nodeType;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsIntentNodeSummary model) {
            this.intentName(model.intentName);
            this.intentPath(model.intentPath);
            this.intentCount(model.intentCount);
            this.intentLevel(model.intentLevel);
            this.nodeType(model.nodeType);
        }

        public final String getIntentName() {
            return this.intentName;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final String getIntentPath() {
            return this.intentPath;
        }

        public final void setIntentPath(String intentPath) {
            this.intentPath = intentPath;
        }

        @Override
        public final Builder intentPath(String intentPath) {
            this.intentPath = intentPath;
            return this;
        }

        public final Integer getIntentCount() {
            return this.intentCount;
        }

        public final void setIntentCount(Integer intentCount) {
            this.intentCount = intentCount;
        }

        @Override
        public final Builder intentCount(Integer intentCount) {
            this.intentCount = intentCount;
            return this;
        }

        public final Integer getIntentLevel() {
            return this.intentLevel;
        }

        public final void setIntentLevel(Integer intentLevel) {
            this.intentLevel = intentLevel;
        }

        @Override
        public final Builder intentLevel(Integer intentLevel) {
            this.intentLevel = intentLevel;
            return this;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        @Override
        public final Builder nodeType(AnalyticsNodeType nodeType) {
            this.nodeType(nodeType == null ? null : nodeType.toString());
            return this;
        }

        public AnalyticsIntentNodeSummary build() {
            return new AnalyticsIntentNodeSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalyticsIntentNodeSummary> {
        public Builder intentName(String var1);

        public Builder intentPath(String var1);

        public Builder intentCount(Integer var1);

        public Builder intentLevel(Integer var1);

        public Builder nodeType(String var1);

        public Builder nodeType(AnalyticsNodeType var1);
    }
}

