/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.GenerationSortBy;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBotResourceGenerationsRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, ListBotResourceGenerationsRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListBotResourceGenerationsRequest.getter(ListBotResourceGenerationsRequest::botId)).setter(ListBotResourceGenerationsRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(ListBotResourceGenerationsRequest.getter(ListBotResourceGenerationsRequest::botVersion)).setter(ListBotResourceGenerationsRequest.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(ListBotResourceGenerationsRequest.getter(ListBotResourceGenerationsRequest::localeId)).setter(ListBotResourceGenerationsRequest.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()}).build();
    private static final SdkField<GenerationSortBy> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sortBy").getter(ListBotResourceGenerationsRequest.getter(ListBotResourceGenerationsRequest::sortBy)).setter(ListBotResourceGenerationsRequest.setter(Builder::sortBy)).constructor(GenerationSortBy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListBotResourceGenerationsRequest.getter(ListBotResourceGenerationsRequest::maxResults)).setter(ListBotResourceGenerationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBotResourceGenerationsRequest.getter(ListBotResourceGenerationsRequest::nextToken)).setter(ListBotResourceGenerationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, SORT_BY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String botId;
    private final String botVersion;
    private final String localeId;
    private final GenerationSortBy sortBy;
    private final Integer maxResults;
    private final String nextToken;

    private ListBotResourceGenerationsRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.sortBy = builder.sortBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final GenerationSortBy sortBy() {
        return this.sortBy;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotResourceGenerationsRequest)) {
            return false;
        }
        ListBotResourceGenerationsRequest other = (ListBotResourceGenerationsRequest)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.sortBy(), other.sortBy()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBotResourceGenerationsRequest").add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("SortBy", (Object)this.sortBy()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortBy()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBotResourceGenerationsRequest, T> g) {
        return obj -> g.apply((ListBotResourceGenerationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private String botId;
        private String botVersion;
        private String localeId;
        private GenerationSortBy sortBy;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotResourceGenerationsRequest model) {
            super(model);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.sortBy(model.sortBy);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final GenerationSortBy.Builder getSortBy() {
            return this.sortBy != null ? this.sortBy.toBuilder() : null;
        }

        public final void setSortBy(GenerationSortBy.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(GenerationSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBotResourceGenerationsRequest build() {
            return new ListBotResourceGenerationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBotResourceGenerationsRequest> {
        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder sortBy(GenerationSortBy var1);

        default public Builder sortBy(Consumer<GenerationSortBy.Builder> sortBy) {
            return this.sortBy((GenerationSortBy)((GenerationSortBy.Builder)GenerationSortBy.builder().applyMutation(sortBy)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

