/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.GenerationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GenerationSummary> {
    private static final SdkField<String> GENERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generationId").getter(GenerationSummary.getter(GenerationSummary::generationId)).setter(GenerationSummary.setter(Builder::generationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationId").build()}).build();
    private static final SdkField<String> GENERATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generationStatus").getter(GenerationSummary.getter(GenerationSummary::generationStatusAsString)).setter(GenerationSummary.setter(Builder::generationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationStatus").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(GenerationSummary.getter(GenerationSummary::creationDateTime)).setter(GenerationSummary.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(GenerationSummary.getter(GenerationSummary::lastUpdatedDateTime)).setter(GenerationSummary.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATION_ID_FIELD, GENERATION_STATUS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String generationId;
    private final String generationStatus;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;

    private GenerationSummary(BuilderImpl builder) {
        this.generationId = builder.generationId;
        this.generationStatus = builder.generationStatus;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final String generationId() {
        return this.generationId;
    }

    public final GenerationStatus generationStatus() {
        return GenerationStatus.fromValue(this.generationStatus);
    }

    public final String generationStatusAsString() {
        return this.generationStatus;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.generationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerationSummary)) {
            return false;
        }
        GenerationSummary other = (GenerationSummary)obj;
        return Objects.equals(this.generationId(), other.generationId()) && Objects.equals(this.generationStatusAsString(), other.generationStatusAsString()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"GenerationSummary").add("GenerationId", (Object)this.generationId()).add("GenerationStatus", (Object)this.generationStatusAsString()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "generationId": {
                return Optional.ofNullable(clazz.cast(this.generationId()));
            }
            case "generationStatus": {
                return Optional.ofNullable(clazz.cast(this.generationStatusAsString()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerationSummary, T> g) {
        return obj -> g.apply((GenerationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String generationId;
        private String generationStatus;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerationSummary model) {
            this.generationId(model.generationId);
            this.generationStatus(model.generationStatus);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getGenerationId() {
            return this.generationId;
        }

        public final void setGenerationId(String generationId) {
            this.generationId = generationId;
        }

        @Override
        public final Builder generationId(String generationId) {
            this.generationId = generationId;
            return this;
        }

        public final String getGenerationStatus() {
            return this.generationStatus;
        }

        public final void setGenerationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
        }

        @Override
        public final Builder generationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
            return this;
        }

        @Override
        public final Builder generationStatus(GenerationStatus generationStatus) {
            this.generationStatus(generationStatus == null ? null : generationStatus.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public GenerationSummary build() {
            return new GenerationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GenerationSummary> {
        public Builder generationId(String var1);

        public Builder generationStatus(String var1);

        public Builder generationStatus(GenerationStatus var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

