/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the errors in the test set discrepancy report
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestSetDiscrepancyErrors implements SdkPojo, Serializable,
        ToCopyableBuilder<TestSetDiscrepancyErrors.Builder, TestSetDiscrepancyErrors> {
    private static final SdkField<List<TestSetIntentDiscrepancyItem>> INTENT_DISCREPANCIES_FIELD = SdkField
            .<List<TestSetIntentDiscrepancyItem>> builder(MarshallingType.LIST)
            .memberName("intentDiscrepancies")
            .getter(getter(TestSetDiscrepancyErrors::intentDiscrepancies))
            .setter(setter(Builder::intentDiscrepancies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentDiscrepancies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TestSetIntentDiscrepancyItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(TestSetIntentDiscrepancyItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TestSetSlotDiscrepancyItem>> SLOT_DISCREPANCIES_FIELD = SdkField
            .<List<TestSetSlotDiscrepancyItem>> builder(MarshallingType.LIST)
            .memberName("slotDiscrepancies")
            .getter(getter(TestSetDiscrepancyErrors::slotDiscrepancies))
            .setter(setter(Builder::slotDiscrepancies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotDiscrepancies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TestSetSlotDiscrepancyItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(TestSetSlotDiscrepancyItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_DISCREPANCIES_FIELD,
            SLOT_DISCREPANCIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<TestSetIntentDiscrepancyItem> intentDiscrepancies;

    private final List<TestSetSlotDiscrepancyItem> slotDiscrepancies;

    private TestSetDiscrepancyErrors(BuilderImpl builder) {
        this.intentDiscrepancies = builder.intentDiscrepancies;
        this.slotDiscrepancies = builder.slotDiscrepancies;
    }

    /**
     * For responses, this returns true if the service returned a value for the IntentDiscrepancies property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIntentDiscrepancies() {
        return intentDiscrepancies != null && !(intentDiscrepancies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about discrepancies found for intents between the test set and the bot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntentDiscrepancies} method.
     * </p>
     * 
     * @return Contains information about discrepancies found for intents between the test set and the bot.
     */
    public final List<TestSetIntentDiscrepancyItem> intentDiscrepancies() {
        return intentDiscrepancies;
    }

    /**
     * For responses, this returns true if the service returned a value for the SlotDiscrepancies property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSlotDiscrepancies() {
        return slotDiscrepancies != null && !(slotDiscrepancies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about discrepancies found for slots between the test set and the bot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlotDiscrepancies} method.
     * </p>
     * 
     * @return Contains information about discrepancies found for slots between the test set and the bot.
     */
    public final List<TestSetSlotDiscrepancyItem> slotDiscrepancies() {
        return slotDiscrepancies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIntentDiscrepancies() ? intentDiscrepancies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSlotDiscrepancies() ? slotDiscrepancies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestSetDiscrepancyErrors)) {
            return false;
        }
        TestSetDiscrepancyErrors other = (TestSetDiscrepancyErrors) obj;
        return hasIntentDiscrepancies() == other.hasIntentDiscrepancies()
                && Objects.equals(intentDiscrepancies(), other.intentDiscrepancies())
                && hasSlotDiscrepancies() == other.hasSlotDiscrepancies()
                && Objects.equals(slotDiscrepancies(), other.slotDiscrepancies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestSetDiscrepancyErrors")
                .add("IntentDiscrepancies", hasIntentDiscrepancies() ? intentDiscrepancies() : null)
                .add("SlotDiscrepancies", hasSlotDiscrepancies() ? slotDiscrepancies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intentDiscrepancies":
            return Optional.ofNullable(clazz.cast(intentDiscrepancies()));
        case "slotDiscrepancies":
            return Optional.ofNullable(clazz.cast(slotDiscrepancies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestSetDiscrepancyErrors, T> g) {
        return obj -> g.apply((TestSetDiscrepancyErrors) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestSetDiscrepancyErrors> {
        /**
         * <p>
         * Contains information about discrepancies found for intents between the test set and the bot.
         * </p>
         * 
         * @param intentDiscrepancies
         *        Contains information about discrepancies found for intents between the test set and the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentDiscrepancies(Collection<TestSetIntentDiscrepancyItem> intentDiscrepancies);

        /**
         * <p>
         * Contains information about discrepancies found for intents between the test set and the bot.
         * </p>
         * 
         * @param intentDiscrepancies
         *        Contains information about discrepancies found for intents between the test set and the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentDiscrepancies(TestSetIntentDiscrepancyItem... intentDiscrepancies);

        /**
         * <p>
         * Contains information about discrepancies found for intents between the test set and the bot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.TestSetIntentDiscrepancyItem.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.TestSetIntentDiscrepancyItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.TestSetIntentDiscrepancyItem.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #intentDiscrepancies(List<TestSetIntentDiscrepancyItem>)}.
         * 
         * @param intentDiscrepancies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.TestSetIntentDiscrepancyItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intentDiscrepancies(java.util.Collection<TestSetIntentDiscrepancyItem>)
         */
        Builder intentDiscrepancies(Consumer<TestSetIntentDiscrepancyItem.Builder>... intentDiscrepancies);

        /**
         * <p>
         * Contains information about discrepancies found for slots between the test set and the bot.
         * </p>
         * 
         * @param slotDiscrepancies
         *        Contains information about discrepancies found for slots between the test set and the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotDiscrepancies(Collection<TestSetSlotDiscrepancyItem> slotDiscrepancies);

        /**
         * <p>
         * Contains information about discrepancies found for slots between the test set and the bot.
         * </p>
         * 
         * @param slotDiscrepancies
         *        Contains information about discrepancies found for slots between the test set and the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotDiscrepancies(TestSetSlotDiscrepancyItem... slotDiscrepancies);

        /**
         * <p>
         * Contains information about discrepancies found for slots between the test set and the bot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.TestSetSlotDiscrepancyItem.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.TestSetSlotDiscrepancyItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.TestSetSlotDiscrepancyItem.Builder#build()} is
         * called immediately and its result is passed to {@link #slotDiscrepancies(List<TestSetSlotDiscrepancyItem>)}.
         * 
         * @param slotDiscrepancies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.TestSetSlotDiscrepancyItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotDiscrepancies(java.util.Collection<TestSetSlotDiscrepancyItem>)
         */
        Builder slotDiscrepancies(Consumer<TestSetSlotDiscrepancyItem.Builder>... slotDiscrepancies);
    }

    static final class BuilderImpl implements Builder {
        private List<TestSetIntentDiscrepancyItem> intentDiscrepancies = DefaultSdkAutoConstructList.getInstance();

        private List<TestSetSlotDiscrepancyItem> slotDiscrepancies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestSetDiscrepancyErrors model) {
            intentDiscrepancies(model.intentDiscrepancies);
            slotDiscrepancies(model.slotDiscrepancies);
        }

        public final List<TestSetIntentDiscrepancyItem.Builder> getIntentDiscrepancies() {
            List<TestSetIntentDiscrepancyItem.Builder> result = TestSetIntentDiscrepancyListCopier
                    .copyToBuilder(this.intentDiscrepancies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntentDiscrepancies(Collection<TestSetIntentDiscrepancyItem.BuilderImpl> intentDiscrepancies) {
            this.intentDiscrepancies = TestSetIntentDiscrepancyListCopier.copyFromBuilder(intentDiscrepancies);
        }

        @Override
        public final Builder intentDiscrepancies(Collection<TestSetIntentDiscrepancyItem> intentDiscrepancies) {
            this.intentDiscrepancies = TestSetIntentDiscrepancyListCopier.copy(intentDiscrepancies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intentDiscrepancies(TestSetIntentDiscrepancyItem... intentDiscrepancies) {
            intentDiscrepancies(Arrays.asList(intentDiscrepancies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intentDiscrepancies(Consumer<TestSetIntentDiscrepancyItem.Builder>... intentDiscrepancies) {
            intentDiscrepancies(Stream.of(intentDiscrepancies)
                    .map(c -> TestSetIntentDiscrepancyItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TestSetSlotDiscrepancyItem.Builder> getSlotDiscrepancies() {
            List<TestSetSlotDiscrepancyItem.Builder> result = TestSetSlotDiscrepancyListCopier
                    .copyToBuilder(this.slotDiscrepancies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlotDiscrepancies(Collection<TestSetSlotDiscrepancyItem.BuilderImpl> slotDiscrepancies) {
            this.slotDiscrepancies = TestSetSlotDiscrepancyListCopier.copyFromBuilder(slotDiscrepancies);
        }

        @Override
        public final Builder slotDiscrepancies(Collection<TestSetSlotDiscrepancyItem> slotDiscrepancies) {
            this.slotDiscrepancies = TestSetSlotDiscrepancyListCopier.copy(slotDiscrepancies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotDiscrepancies(TestSetSlotDiscrepancyItem... slotDiscrepancies) {
            slotDiscrepancies(Arrays.asList(slotDiscrepancies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotDiscrepancies(Consumer<TestSetSlotDiscrepancyItem.Builder>... slotDiscrepancies) {
            slotDiscrepancies(Stream.of(slotDiscrepancies)
                    .map(c -> TestSetSlotDiscrepancyItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TestSetDiscrepancyErrors build() {
            return new TestSetDiscrepancyErrors(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
