/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTestExecutionResponse extends LexModelsV2Response implements
        ToCopyableBuilder<StartTestExecutionResponse.Builder, StartTestExecutionResponse> {
    private static final SdkField<String> TEST_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testExecutionId").getter(getter(StartTestExecutionResponse::testExecutionId))
            .setter(setter(Builder::testExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testExecutionId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(StartTestExecutionResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<String> TEST_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSetId").getter(getter(StartTestExecutionResponse::testSetId)).setter(setter(Builder::testSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetId").build()).build();

    private static final SdkField<TestExecutionTarget> TARGET_FIELD = SdkField
            .<TestExecutionTarget> builder(MarshallingType.SDK_POJO).memberName("target")
            .getter(getter(StartTestExecutionResponse::target)).setter(setter(Builder::target))
            .constructor(TestExecutionTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<String> API_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiMode").getter(getter(StartTestExecutionResponse::apiModeAsString)).setter(setter(Builder::apiMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiMode").build()).build();

    private static final SdkField<String> TEST_EXECUTION_MODALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testExecutionModality").getter(getter(StartTestExecutionResponse::testExecutionModalityAsString))
            .setter(setter(Builder::testExecutionModality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testExecutionModality").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_EXECUTION_ID_FIELD,
            CREATION_DATE_TIME_FIELD, TEST_SET_ID_FIELD, TARGET_FIELD, API_MODE_FIELD, TEST_EXECUTION_MODALITY_FIELD));

    private final String testExecutionId;

    private final Instant creationDateTime;

    private final String testSetId;

    private final TestExecutionTarget target;

    private final String apiMode;

    private final String testExecutionModality;

    private StartTestExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.testExecutionId = builder.testExecutionId;
        this.creationDateTime = builder.creationDateTime;
        this.testSetId = builder.testSetId;
        this.target = builder.target;
        this.apiMode = builder.apiMode;
        this.testExecutionModality = builder.testExecutionModality;
    }

    /**
     * <p>
     * The unique identifier of the test set execution.
     * </p>
     * 
     * @return The unique identifier of the test set execution.
     */
    public final String testExecutionId() {
        return testExecutionId;
    }

    /**
     * <p>
     * The creation date and time for the test set execution.
     * </p>
     * 
     * @return The creation date and time for the test set execution.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The test set Id for the test set execution.
     * </p>
     * 
     * @return The test set Id for the test set execution.
     */
    public final String testSetId() {
        return testSetId;
    }

    /**
     * <p>
     * The target bot for the test set execution.
     * </p>
     * 
     * @return The target bot for the test set execution.
     */
    public final TestExecutionTarget target() {
        return target;
    }

    /**
     * <p>
     * Indicates whether we use streaming or non-streaming APIs for the test set execution. For streaming,
     * StartConversation Amazon Lex Runtime API is used. Whereas for non-streaming, RecognizeUtterance and RecognizeText
     * Amazon Lex Runtime API are used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiMode} will
     * return {@link TestExecutionApiMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #apiModeAsString}.
     * </p>
     * 
     * @return Indicates whether we use streaming or non-streaming APIs for the test set execution. For streaming,
     *         StartConversation Amazon Lex Runtime API is used. Whereas for non-streaming, RecognizeUtterance and
     *         RecognizeText Amazon Lex Runtime API are used.
     * @see TestExecutionApiMode
     */
    public final TestExecutionApiMode apiMode() {
        return TestExecutionApiMode.fromValue(apiMode);
    }

    /**
     * <p>
     * Indicates whether we use streaming or non-streaming APIs for the test set execution. For streaming,
     * StartConversation Amazon Lex Runtime API is used. Whereas for non-streaming, RecognizeUtterance and RecognizeText
     * Amazon Lex Runtime API are used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiMode} will
     * return {@link TestExecutionApiMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #apiModeAsString}.
     * </p>
     * 
     * @return Indicates whether we use streaming or non-streaming APIs for the test set execution. For streaming,
     *         StartConversation Amazon Lex Runtime API is used. Whereas for non-streaming, RecognizeUtterance and
     *         RecognizeText Amazon Lex Runtime API are used.
     * @see TestExecutionApiMode
     */
    public final String apiModeAsString() {
        return apiMode;
    }

    /**
     * <p>
     * Indicates whether audio or text is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #testExecutionModality} will return {@link TestExecutionModality#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #testExecutionModalityAsString}.
     * </p>
     * 
     * @return Indicates whether audio or text is used.
     * @see TestExecutionModality
     */
    public final TestExecutionModality testExecutionModality() {
        return TestExecutionModality.fromValue(testExecutionModality);
    }

    /**
     * <p>
     * Indicates whether audio or text is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #testExecutionModality} will return {@link TestExecutionModality#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #testExecutionModalityAsString}.
     * </p>
     * 
     * @return Indicates whether audio or text is used.
     * @see TestExecutionModality
     */
    public final String testExecutionModalityAsString() {
        return testExecutionModality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(testSetId());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(apiModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(testExecutionModalityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTestExecutionResponse)) {
            return false;
        }
        StartTestExecutionResponse other = (StartTestExecutionResponse) obj;
        return Objects.equals(testExecutionId(), other.testExecutionId())
                && Objects.equals(creationDateTime(), other.creationDateTime()) && Objects.equals(testSetId(), other.testSetId())
                && Objects.equals(target(), other.target()) && Objects.equals(apiModeAsString(), other.apiModeAsString())
                && Objects.equals(testExecutionModalityAsString(), other.testExecutionModalityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTestExecutionResponse").add("TestExecutionId", testExecutionId())
                .add("CreationDateTime", creationDateTime()).add("TestSetId", testSetId()).add("Target", target())
                .add("ApiMode", apiModeAsString()).add("TestExecutionModality", testExecutionModalityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testExecutionId":
            return Optional.ofNullable(clazz.cast(testExecutionId()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "testSetId":
            return Optional.ofNullable(clazz.cast(testSetId()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "apiMode":
            return Optional.ofNullable(clazz.cast(apiModeAsString()));
        case "testExecutionModality":
            return Optional.ofNullable(clazz.cast(testExecutionModalityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTestExecutionResponse, T> g) {
        return obj -> g.apply((StartTestExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, StartTestExecutionResponse> {
        /**
         * <p>
         * The unique identifier of the test set execution.
         * </p>
         * 
         * @param testExecutionId
         *        The unique identifier of the test set execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testExecutionId(String testExecutionId);

        /**
         * <p>
         * The creation date and time for the test set execution.
         * </p>
         * 
         * @param creationDateTime
         *        The creation date and time for the test set execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The test set Id for the test set execution.
         * </p>
         * 
         * @param testSetId
         *        The test set Id for the test set execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetId(String testSetId);

        /**
         * <p>
         * The target bot for the test set execution.
         * </p>
         * 
         * @param target
         *        The target bot for the test set execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(TestExecutionTarget target);

        /**
         * <p>
         * The target bot for the test set execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestExecutionTarget.Builder} avoiding the
         * need to create one manually via {@link TestExecutionTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestExecutionTarget.Builder#build()} is called immediately and
         * its result is passed to {@link #target(TestExecutionTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link TestExecutionTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(TestExecutionTarget)
         */
        default Builder target(Consumer<TestExecutionTarget.Builder> target) {
            return target(TestExecutionTarget.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * Indicates whether we use streaming or non-streaming APIs for the test set execution. For streaming,
         * StartConversation Amazon Lex Runtime API is used. Whereas for non-streaming, RecognizeUtterance and
         * RecognizeText Amazon Lex Runtime API are used.
         * </p>
         * 
         * @param apiMode
         *        Indicates whether we use streaming or non-streaming APIs for the test set execution. For streaming,
         *        StartConversation Amazon Lex Runtime API is used. Whereas for non-streaming, RecognizeUtterance and
         *        RecognizeText Amazon Lex Runtime API are used.
         * @see TestExecutionApiMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestExecutionApiMode
         */
        Builder apiMode(String apiMode);

        /**
         * <p>
         * Indicates whether we use streaming or non-streaming APIs for the test set execution. For streaming,
         * StartConversation Amazon Lex Runtime API is used. Whereas for non-streaming, RecognizeUtterance and
         * RecognizeText Amazon Lex Runtime API are used.
         * </p>
         * 
         * @param apiMode
         *        Indicates whether we use streaming or non-streaming APIs for the test set execution. For streaming,
         *        StartConversation Amazon Lex Runtime API is used. Whereas for non-streaming, RecognizeUtterance and
         *        RecognizeText Amazon Lex Runtime API are used.
         * @see TestExecutionApiMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestExecutionApiMode
         */
        Builder apiMode(TestExecutionApiMode apiMode);

        /**
         * <p>
         * Indicates whether audio or text is used.
         * </p>
         * 
         * @param testExecutionModality
         *        Indicates whether audio or text is used.
         * @see TestExecutionModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestExecutionModality
         */
        Builder testExecutionModality(String testExecutionModality);

        /**
         * <p>
         * Indicates whether audio or text is used.
         * </p>
         * 
         * @param testExecutionModality
         *        Indicates whether audio or text is used.
         * @see TestExecutionModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestExecutionModality
         */
        Builder testExecutionModality(TestExecutionModality testExecutionModality);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String testExecutionId;

        private Instant creationDateTime;

        private String testSetId;

        private TestExecutionTarget target;

        private String apiMode;

        private String testExecutionModality;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTestExecutionResponse model) {
            super(model);
            testExecutionId(model.testExecutionId);
            creationDateTime(model.creationDateTime);
            testSetId(model.testSetId);
            target(model.target);
            apiMode(model.apiMode);
            testExecutionModality(model.testExecutionModality);
        }

        public final String getTestExecutionId() {
            return testExecutionId;
        }

        public final void setTestExecutionId(String testExecutionId) {
            this.testExecutionId = testExecutionId;
        }

        @Override
        public final Builder testExecutionId(String testExecutionId) {
            this.testExecutionId = testExecutionId;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getTestSetId() {
            return testSetId;
        }

        public final void setTestSetId(String testSetId) {
            this.testSetId = testSetId;
        }

        @Override
        public final Builder testSetId(String testSetId) {
            this.testSetId = testSetId;
            return this;
        }

        public final TestExecutionTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(TestExecutionTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(TestExecutionTarget target) {
            this.target = target;
            return this;
        }

        public final String getApiMode() {
            return apiMode;
        }

        public final void setApiMode(String apiMode) {
            this.apiMode = apiMode;
        }

        @Override
        public final Builder apiMode(String apiMode) {
            this.apiMode = apiMode;
            return this;
        }

        @Override
        public final Builder apiMode(TestExecutionApiMode apiMode) {
            this.apiMode(apiMode == null ? null : apiMode.toString());
            return this;
        }

        public final String getTestExecutionModality() {
            return testExecutionModality;
        }

        public final void setTestExecutionModality(String testExecutionModality) {
            this.testExecutionModality = testExecutionModality;
        }

        @Override
        public final Builder testExecutionModality(String testExecutionModality) {
            this.testExecutionModality = testExecutionModality;
            return this;
        }

        @Override
        public final Builder testExecutionModality(TestExecutionModality testExecutionModality) {
            this.testExecutionModality(testExecutionModality == null ? null : testExecutionModality.toString());
            return this;
        }

        @Override
        public StartTestExecutionResponse build() {
            return new StartTestExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
