/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTestSetRecordsResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListTestSetRecordsResponse.Builder, ListTestSetRecordsResponse> {
    private static final SdkField<List<TestSetTurnRecord>> TEST_SET_RECORDS_FIELD = SdkField
            .<List<TestSetTurnRecord>> builder(MarshallingType.LIST)
            .memberName("testSetRecords")
            .getter(getter(ListTestSetRecordsResponse::testSetRecords))
            .setter(setter(Builder::testSetRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TestSetTurnRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(TestSetTurnRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTestSetRecordsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SET_RECORDS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TestSetTurnRecord> testSetRecords;

    private final String nextToken;

    private ListTestSetRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.testSetRecords = builder.testSetRecords;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TestSetRecords property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTestSetRecords() {
        return testSetRecords != null && !(testSetRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of records from the test set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTestSetRecords} method.
     * </p>
     * 
     * @return The list of records from the test set.
     */
    public final List<TestSetTurnRecord> testSetRecords() {
        return testSetRecords;
    }

    /**
     * <p>
     * A token that indicates whether there are more records to return in a response to the ListTestSetRecords
     * operation. If the nextToken field is present, you send the contents as the nextToken parameter of a
     * ListTestSetRecords operation request to get the next page of records.
     * </p>
     * 
     * @return A token that indicates whether there are more records to return in a response to the ListTestSetRecords
     *         operation. If the nextToken field is present, you send the contents as the nextToken parameter of a
     *         ListTestSetRecords operation request to get the next page of records.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTestSetRecords() ? testSetRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestSetRecordsResponse)) {
            return false;
        }
        ListTestSetRecordsResponse other = (ListTestSetRecordsResponse) obj;
        return hasTestSetRecords() == other.hasTestSetRecords() && Objects.equals(testSetRecords(), other.testSetRecords())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTestSetRecordsResponse")
                .add("TestSetRecords", hasTestSetRecords() ? testSetRecords() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testSetRecords":
            return Optional.ofNullable(clazz.cast(testSetRecords()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestSetRecordsResponse, T> g) {
        return obj -> g.apply((ListTestSetRecordsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListTestSetRecordsResponse> {
        /**
         * <p>
         * The list of records from the test set.
         * </p>
         * 
         * @param testSetRecords
         *        The list of records from the test set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetRecords(Collection<TestSetTurnRecord> testSetRecords);

        /**
         * <p>
         * The list of records from the test set.
         * </p>
         * 
         * @param testSetRecords
         *        The list of records from the test set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetRecords(TestSetTurnRecord... testSetRecords);

        /**
         * <p>
         * The list of records from the test set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.TestSetTurnRecord.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.TestSetTurnRecord#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.TestSetTurnRecord.Builder#build()} is called
         * immediately and its result is passed to {@link #testSetRecords(List<TestSetTurnRecord>)}.
         * 
         * @param testSetRecords
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.TestSetTurnRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testSetRecords(java.util.Collection<TestSetTurnRecord>)
         */
        Builder testSetRecords(Consumer<TestSetTurnRecord.Builder>... testSetRecords);

        /**
         * <p>
         * A token that indicates whether there are more records to return in a response to the ListTestSetRecords
         * operation. If the nextToken field is present, you send the contents as the nextToken parameter of a
         * ListTestSetRecords operation request to get the next page of records.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates whether there are more records to return in a response to the
         *        ListTestSetRecords operation. If the nextToken field is present, you send the contents as the
         *        nextToken parameter of a ListTestSetRecords operation request to get the next page of records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private List<TestSetTurnRecord> testSetRecords = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestSetRecordsResponse model) {
            super(model);
            testSetRecords(model.testSetRecords);
            nextToken(model.nextToken);
        }

        public final List<TestSetTurnRecord.Builder> getTestSetRecords() {
            List<TestSetTurnRecord.Builder> result = TestSetTurnRecordListCopier.copyToBuilder(this.testSetRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestSetRecords(Collection<TestSetTurnRecord.BuilderImpl> testSetRecords) {
            this.testSetRecords = TestSetTurnRecordListCopier.copyFromBuilder(testSetRecords);
        }

        @Override
        public final Builder testSetRecords(Collection<TestSetTurnRecord> testSetRecords) {
            this.testSetRecords = TestSetTurnRecordListCopier.copy(testSetRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testSetRecords(TestSetTurnRecord... testSetRecords) {
            testSetRecords(Arrays.asList(testSetRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testSetRecords(Consumer<TestSetTurnRecord.Builder>... testSetRecords) {
            testSetRecords(Stream.of(testSetRecords).map(c -> TestSetTurnRecord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTestSetRecordsResponse build() {
            return new ListTestSetRecordsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
