/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.BotVersionSummary;
import software.amazon.awssdk.services.lexmodelsv2.model.BotVersionSummaryListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBotVersionsResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListBotVersionsResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListBotVersionsResponse.getter(ListBotVersionsResponse::botId)).setter(ListBotVersionsResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<List<BotVersionSummary>> BOT_VERSION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("botVersionSummaries").getter(ListBotVersionsResponse.getter(ListBotVersionsResponse::botVersionSummaries)).setter(ListBotVersionsResponse.setter(Builder::botVersionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BotVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBotVersionsResponse.getter(ListBotVersionsResponse::nextToken)).setter(ListBotVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final String botId;
    private final List<BotVersionSummary> botVersionSummaries;
    private final String nextToken;

    private ListBotVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersionSummaries = builder.botVersionSummaries;
        this.nextToken = builder.nextToken;
    }

    public final String botId() {
        return this.botId;
    }

    public final boolean hasBotVersionSummaries() {
        return this.botVersionSummaries != null && !(this.botVersionSummaries instanceof SdkAutoConstructList);
    }

    public final List<BotVersionSummary> botVersionSummaries() {
        return this.botVersionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBotVersionSummaries() ? this.botVersionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotVersionsResponse)) {
            return false;
        }
        ListBotVersionsResponse other = (ListBotVersionsResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && this.hasBotVersionSummaries() == other.hasBotVersionSummaries() && Objects.equals(this.botVersionSummaries(), other.botVersionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBotVersionsResponse").add("BotId", (Object)this.botId()).add("BotVersionSummaries", this.hasBotVersionSummaries() ? this.botVersionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersionSummaries": {
                return Optional.ofNullable(clazz.cast(this.botVersionSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBotVersionsResponse, T> g) {
        return obj -> g.apply((ListBotVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private List<BotVersionSummary> botVersionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotVersionsResponse model) {
            super(model);
            this.botId(model.botId);
            this.botVersionSummaries(model.botVersionSummaries);
            this.nextToken(model.nextToken);
        }

        public final String getBotId() {
            return this.botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        public final List<BotVersionSummary.Builder> getBotVersionSummaries() {
            List<BotVersionSummary.Builder> result = BotVersionSummaryListCopier.copyToBuilder(this.botVersionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder botVersionSummaries(Collection<BotVersionSummary> botVersionSummaries) {
            this.botVersionSummaries = BotVersionSummaryListCopier.copy(botVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botVersionSummaries(BotVersionSummary ... botVersionSummaries) {
            this.botVersionSummaries(Arrays.asList(botVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botVersionSummaries(Consumer<BotVersionSummary.Builder> ... botVersionSummaries) {
            this.botVersionSummaries(Stream.of(botVersionSummaries).map(c -> (BotVersionSummary)((BotVersionSummary.Builder)BotVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBotVersionSummaries(Collection<BotVersionSummary.BuilderImpl> botVersionSummaries) {
            this.botVersionSummaries = BotVersionSummaryListCopier.copyFromBuilder(botVersionSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListBotVersionsResponse build() {
            return new ListBotVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBotVersionsResponse> {
        public Builder botId(String var1);

        public Builder botVersionSummaries(Collection<BotVersionSummary> var1);

        public Builder botVersionSummaries(BotVersionSummary ... var1);

        public Builder botVersionSummaries(Consumer<BotVersionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

