/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SentimentAnalysisSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<SentimentAnalysisSettings.Builder, SentimentAnalysisSettings> {
    private static final SdkField<Boolean> DETECT_SENTIMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("detectSentiment").getter(getter(SentimentAnalysisSettings::detectSentiment))
            .setter(setter(Builder::detectSentiment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectSentiment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECT_SENTIMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean detectSentiment;

    private SentimentAnalysisSettings(BuilderImpl builder) {
        this.detectSentiment = builder.detectSentiment;
    }

    /**
     * <p>
     * Sets whether Amazon Lex uses Amazon Comprehend to detect the sentiment of user utterances.
     * </p>
     * 
     * @return Sets whether Amazon Lex uses Amazon Comprehend to detect the sentiment of user utterances.
     */
    public final Boolean detectSentiment() {
        return detectSentiment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detectSentiment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SentimentAnalysisSettings)) {
            return false;
        }
        SentimentAnalysisSettings other = (SentimentAnalysisSettings) obj;
        return Objects.equals(detectSentiment(), other.detectSentiment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SentimentAnalysisSettings").add("DetectSentiment", detectSentiment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectSentiment":
            return Optional.ofNullable(clazz.cast(detectSentiment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SentimentAnalysisSettings, T> g) {
        return obj -> g.apply((SentimentAnalysisSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SentimentAnalysisSettings> {
        /**
         * <p>
         * Sets whether Amazon Lex uses Amazon Comprehend to detect the sentiment of user utterances.
         * </p>
         * 
         * @param detectSentiment
         *        Sets whether Amazon Lex uses Amazon Comprehend to detect the sentiment of user utterances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectSentiment(Boolean detectSentiment);
    }

    static final class BuilderImpl implements Builder {
        private Boolean detectSentiment;

        private BuilderImpl() {
        }

        private BuilderImpl(SentimentAnalysisSettings model) {
            detectSentiment(model.detectSentiment);
        }

        public final Boolean getDetectSentiment() {
            return detectSentiment;
        }

        @Override
        public final Builder detectSentiment(Boolean detectSentiment) {
            this.detectSentiment = detectSentiment;
            return this;
        }

        public final void setDetectSentiment(Boolean detectSentiment) {
            this.detectSentiment = detectSentiment;
        }

        @Override
        public SentimentAnalysisSettings build() {
            return new SentimentAnalysisSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
