/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters the response from the <code>ListIntents</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntentFilter implements SdkPojo, Serializable, ToCopyableBuilder<IntentFilter.Builder, IntentFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(IntentFilter::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(IntentFilter::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operator").getter(getter(IntentFilter::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUES_FIELD,
            OPERATOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> values;

    private final String operator;

    private IntentFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.values = builder.values;
        this.operator = builder.operator;
    }

    /**
     * <p>
     * The name of the field to use for the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link IntentFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the field to use for the filter.
     * @see IntentFilterName
     */
    public final IntentFilterName name() {
        return IntentFilterName.fromValue(name);
    }

    /**
     * <p>
     * The name of the field to use for the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link IntentFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the field to use for the filter.
     * @see IntentFilterName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * Returns true if the Values property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value to use for the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value to use for the filter.
     */
    public final List<String> values() {
        return values;
    }

    /**
     * <p>
     * The operator to use for the filter. Specify <code>EQ</code> when the <code>ListIntents</code> operation should
     * return only aliases that equal the specified value. Specify <code>CO</code> when the <code>ListIntents</code>
     * operation should return aliases that contain the specified value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link IntentFilterOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatorAsString}.
     * </p>
     * 
     * @return The operator to use for the filter. Specify <code>EQ</code> when the <code>ListIntents</code> operation
     *         should return only aliases that equal the specified value. Specify <code>CO</code> when the
     *         <code>ListIntents</code> operation should return aliases that contain the specified value.
     * @see IntentFilterOperator
     */
    public final IntentFilterOperator operator() {
        return IntentFilterOperator.fromValue(operator);
    }

    /**
     * <p>
     * The operator to use for the filter. Specify <code>EQ</code> when the <code>ListIntents</code> operation should
     * return only aliases that equal the specified value. Specify <code>CO</code> when the <code>ListIntents</code>
     * operation should return aliases that contain the specified value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link IntentFilterOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatorAsString}.
     * </p>
     * 
     * @return The operator to use for the filter. Specify <code>EQ</code> when the <code>ListIntents</code> operation
     *         should return only aliases that equal the specified value. Specify <code>CO</code> when the
     *         <code>ListIntents</code> operation should return aliases that contain the specified value.
     * @see IntentFilterOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntentFilter)) {
            return false;
        }
        IntentFilter other = (IntentFilter) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values()) && Objects.equals(operatorAsString(), other.operatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntentFilter").add("Name", nameAsString()).add("Values", hasValues() ? values() : null)
                .add("Operator", operatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        case "operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntentFilter, T> g) {
        return obj -> g.apply((IntentFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntentFilter> {
        /**
         * <p>
         * The name of the field to use for the filter.
         * </p>
         * 
         * @param name
         *        The name of the field to use for the filter.
         * @see IntentFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntentFilterName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the field to use for the filter.
         * </p>
         * 
         * @param name
         *        The name of the field to use for the filter.
         * @see IntentFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntentFilterName
         */
        Builder name(IntentFilterName name);

        /**
         * <p>
         * The value to use for the filter.
         * </p>
         * 
         * @param values
         *        The value to use for the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The value to use for the filter.
         * </p>
         * 
         * @param values
         *        The value to use for the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * The operator to use for the filter. Specify <code>EQ</code> when the <code>ListIntents</code> operation
         * should return only aliases that equal the specified value. Specify <code>CO</code> when the
         * <code>ListIntents</code> operation should return aliases that contain the specified value.
         * </p>
         * 
         * @param operator
         *        The operator to use for the filter. Specify <code>EQ</code> when the <code>ListIntents</code>
         *        operation should return only aliases that equal the specified value. Specify <code>CO</code> when the
         *        <code>ListIntents</code> operation should return aliases that contain the specified value.
         * @see IntentFilterOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntentFilterOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The operator to use for the filter. Specify <code>EQ</code> when the <code>ListIntents</code> operation
         * should return only aliases that equal the specified value. Specify <code>CO</code> when the
         * <code>ListIntents</code> operation should return aliases that contain the specified value.
         * </p>
         * 
         * @param operator
         *        The operator to use for the filter. Specify <code>EQ</code> when the <code>ListIntents</code>
         *        operation should return only aliases that equal the specified value. Specify <code>CO</code> when the
         *        <code>ListIntents</code> operation should return aliases that contain the specified value.
         * @see IntentFilterOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntentFilterOperator
         */
        Builder operator(IntentFilterOperator operator);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(IntentFilter model) {
            name(model.name);
            values(model.values);
            operator(model.operator);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(IntentFilterName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = FilterValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = FilterValuesCopier.copy(values);
        }

        public final String getOperator() {
            return operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(IntentFilterOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public IntentFilter build() {
            return new IntentFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
