/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSlotTypeResponse extends LexModelsV2Response implements
        ToCopyableBuilder<DescribeSlotTypeResponse.Builder, DescribeSlotTypeResponse> {
    private static final SdkField<String> SLOT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotTypeId").getter(getter(DescribeSlotTypeResponse::slotTypeId)).setter(setter(Builder::slotTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeId").build()).build();

    private static final SdkField<String> SLOT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotTypeName").getter(getter(DescribeSlotTypeResponse::slotTypeName))
            .setter(setter(Builder::slotTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DescribeSlotTypeResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<SlotTypeValue>> SLOT_TYPE_VALUES_FIELD = SdkField
            .<List<SlotTypeValue>> builder(MarshallingType.LIST)
            .memberName("slotTypeValues")
            .getter(getter(DescribeSlotTypeResponse::slotTypeValues))
            .setter(setter(Builder::slotTypeValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlotTypeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlotTypeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SlotValueSelectionSetting> VALUE_SELECTION_SETTING_FIELD = SdkField
            .<SlotValueSelectionSetting> builder(MarshallingType.SDK_POJO).memberName("valueSelectionSetting")
            .getter(getter(DescribeSlotTypeResponse::valueSelectionSetting)).setter(setter(Builder::valueSelectionSetting))
            .constructor(SlotValueSelectionSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueSelectionSetting").build())
            .build();

    private static final SdkField<String> PARENT_SLOT_TYPE_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentSlotTypeSignature").getter(getter(DescribeSlotTypeResponse::parentSlotTypeSignature))
            .setter(setter(Builder::parentSlotTypeSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentSlotTypeSignature").build())
            .build();

    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(DescribeSlotTypeResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(DescribeSlotTypeResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(DescribeSlotTypeResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(DescribeSlotTypeResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(DescribeSlotTypeResponse::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_TYPE_ID_FIELD,
            SLOT_TYPE_NAME_FIELD, DESCRIPTION_FIELD, SLOT_TYPE_VALUES_FIELD, VALUE_SELECTION_SETTING_FIELD,
            PARENT_SLOT_TYPE_SIGNATURE_FIELD, BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, CREATION_DATE_TIME_FIELD,
            LAST_UPDATED_DATE_TIME_FIELD));

    private final String slotTypeId;

    private final String slotTypeName;

    private final String description;

    private final List<SlotTypeValue> slotTypeValues;

    private final SlotValueSelectionSetting valueSelectionSetting;

    private final String parentSlotTypeSignature;

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private DescribeSlotTypeResponse(BuilderImpl builder) {
        super(builder);
        this.slotTypeId = builder.slotTypeId;
        this.slotTypeName = builder.slotTypeName;
        this.description = builder.description;
        this.slotTypeValues = builder.slotTypeValues;
        this.valueSelectionSetting = builder.valueSelectionSetting;
        this.parentSlotTypeSignature = builder.parentSlotTypeSignature;
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The unique identifier for the slot type.
     * </p>
     * 
     * @return The unique identifier for the slot type.
     */
    public final String slotTypeId() {
        return slotTypeId;
    }

    /**
     * <p>
     * The name specified for the slot type.
     * </p>
     * 
     * @return The name specified for the slot type.
     */
    public final String slotTypeName() {
        return slotTypeName;
    }

    /**
     * <p>
     * The description specified for the slot type.
     * </p>
     * 
     * @return The description specified for the slot type.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the SlotTypeValues property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSlotTypeValues() {
        return slotTypeValues != null && !(slotTypeValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values that the slot type can take. Includes any synonyms for the slot type values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSlotTypeValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The values that the slot type can take. Includes any synonyms for the slot type values.
     */
    public final List<SlotTypeValue> slotTypeValues() {
        return slotTypeValues;
    }

    /**
     * <p>
     * The strategy that Amazon Lex uses to choose a value from a list of possible values.
     * </p>
     * 
     * @return The strategy that Amazon Lex uses to choose a value from a list of possible values.
     */
    public final SlotValueSelectionSetting valueSelectionSetting() {
        return valueSelectionSetting;
    }

    /**
     * <p>
     * The built in slot type used as a parent to this slot type.
     * </p>
     * 
     * @return The built in slot type used as a parent to this slot type.
     */
    public final String parentSlotTypeSignature() {
        return parentSlotTypeSignature;
    }

    /**
     * <p>
     * The identifier of the bot associated with the slot type.
     * </p>
     * 
     * @return The identifier of the bot associated with the slot type.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot associated with the slot type.
     * </p>
     * 
     * @return The version of the bot associated with the slot type.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The language and locale specified for the slot type.
     * </p>
     * 
     * @return The language and locale specified for the slot type.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * A timestamp of the date and time that the slot type was created.
     * </p>
     * 
     * @return A timestamp of the date and time that the slot type was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * A timestamp of the date and time that the slot type was last updated.
     * </p>
     * 
     * @return A timestamp of the date and time that the slot type was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(slotTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(slotTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasSlotTypeValues() ? slotTypeValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(valueSelectionSetting());
        hashCode = 31 * hashCode + Objects.hashCode(parentSlotTypeSignature());
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSlotTypeResponse)) {
            return false;
        }
        DescribeSlotTypeResponse other = (DescribeSlotTypeResponse) obj;
        return Objects.equals(slotTypeId(), other.slotTypeId()) && Objects.equals(slotTypeName(), other.slotTypeName())
                && Objects.equals(description(), other.description()) && hasSlotTypeValues() == other.hasSlotTypeValues()
                && Objects.equals(slotTypeValues(), other.slotTypeValues())
                && Objects.equals(valueSelectionSetting(), other.valueSelectionSetting())
                && Objects.equals(parentSlotTypeSignature(), other.parentSlotTypeSignature())
                && Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId()) && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSlotTypeResponse").add("SlotTypeId", slotTypeId()).add("SlotTypeName", slotTypeName())
                .add("Description", description()).add("SlotTypeValues", hasSlotTypeValues() ? slotTypeValues() : null)
                .add("ValueSelectionSetting", valueSelectionSetting()).add("ParentSlotTypeSignature", parentSlotTypeSignature())
                .add("BotId", botId()).add("BotVersion", botVersion()).add("LocaleId", localeId())
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slotTypeId":
            return Optional.ofNullable(clazz.cast(slotTypeId()));
        case "slotTypeName":
            return Optional.ofNullable(clazz.cast(slotTypeName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "slotTypeValues":
            return Optional.ofNullable(clazz.cast(slotTypeValues()));
        case "valueSelectionSetting":
            return Optional.ofNullable(clazz.cast(valueSelectionSetting()));
        case "parentSlotTypeSignature":
            return Optional.ofNullable(clazz.cast(parentSlotTypeSignature()));
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSlotTypeResponse, T> g) {
        return obj -> g.apply((DescribeSlotTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSlotTypeResponse> {
        /**
         * <p>
         * The unique identifier for the slot type.
         * </p>
         * 
         * @param slotTypeId
         *        The unique identifier for the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeId(String slotTypeId);

        /**
         * <p>
         * The name specified for the slot type.
         * </p>
         * 
         * @param slotTypeName
         *        The name specified for the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeName(String slotTypeName);

        /**
         * <p>
         * The description specified for the slot type.
         * </p>
         * 
         * @param description
         *        The description specified for the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The values that the slot type can take. Includes any synonyms for the slot type values.
         * </p>
         * 
         * @param slotTypeValues
         *        The values that the slot type can take. Includes any synonyms for the slot type values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeValues(Collection<SlotTypeValue> slotTypeValues);

        /**
         * <p>
         * The values that the slot type can take. Includes any synonyms for the slot type values.
         * </p>
         * 
         * @param slotTypeValues
         *        The values that the slot type can take. Includes any synonyms for the slot type values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeValues(SlotTypeValue... slotTypeValues);

        /**
         * <p>
         * The values that the slot type can take. Includes any synonyms for the slot type values.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SlotTypeValue>.Builder} avoiding the need
         * to create one manually via {@link List<SlotTypeValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SlotTypeValue>.Builder#build()} is called immediately and
         * its result is passed to {@link #slotTypeValues(List<SlotTypeValue>)}.
         * 
         * @param slotTypeValues
         *        a consumer that will call methods on {@link List<SlotTypeValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotTypeValues(List<SlotTypeValue>)
         */
        Builder slotTypeValues(Consumer<SlotTypeValue.Builder>... slotTypeValues);

        /**
         * <p>
         * The strategy that Amazon Lex uses to choose a value from a list of possible values.
         * </p>
         * 
         * @param valueSelectionSetting
         *        The strategy that Amazon Lex uses to choose a value from a list of possible values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueSelectionSetting(SlotValueSelectionSetting valueSelectionSetting);

        /**
         * <p>
         * The strategy that Amazon Lex uses to choose a value from a list of possible values.
         * </p>
         * This is a convenience that creates an instance of the {@link SlotValueSelectionSetting.Builder} avoiding the
         * need to create one manually via {@link SlotValueSelectionSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link SlotValueSelectionSetting.Builder#build()} is called immediately
         * and its result is passed to {@link #valueSelectionSetting(SlotValueSelectionSetting)}.
         * 
         * @param valueSelectionSetting
         *        a consumer that will call methods on {@link SlotValueSelectionSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueSelectionSetting(SlotValueSelectionSetting)
         */
        default Builder valueSelectionSetting(Consumer<SlotValueSelectionSetting.Builder> valueSelectionSetting) {
            return valueSelectionSetting(SlotValueSelectionSetting.builder().applyMutation(valueSelectionSetting).build());
        }

        /**
         * <p>
         * The built in slot type used as a parent to this slot type.
         * </p>
         * 
         * @param parentSlotTypeSignature
         *        The built in slot type used as a parent to this slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentSlotTypeSignature(String parentSlotTypeSignature);

        /**
         * <p>
         * The identifier of the bot associated with the slot type.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot associated with the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot associated with the slot type.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot associated with the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The language and locale specified for the slot type.
         * </p>
         * 
         * @param localeId
         *        The language and locale specified for the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * A timestamp of the date and time that the slot type was created.
         * </p>
         * 
         * @param creationDateTime
         *        A timestamp of the date and time that the slot type was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * A timestamp of the date and time that the slot type was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        A timestamp of the date and time that the slot type was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String slotTypeId;

        private String slotTypeName;

        private String description;

        private List<SlotTypeValue> slotTypeValues = DefaultSdkAutoConstructList.getInstance();

        private SlotValueSelectionSetting valueSelectionSetting;

        private String parentSlotTypeSignature;

        private String botId;

        private String botVersion;

        private String localeId;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSlotTypeResponse model) {
            super(model);
            slotTypeId(model.slotTypeId);
            slotTypeName(model.slotTypeName);
            description(model.description);
            slotTypeValues(model.slotTypeValues);
            valueSelectionSetting(model.valueSelectionSetting);
            parentSlotTypeSignature(model.parentSlotTypeSignature);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getSlotTypeId() {
            return slotTypeId;
        }

        @Override
        public final Builder slotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
            return this;
        }

        public final void setSlotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
        }

        public final String getSlotTypeName() {
            return slotTypeName;
        }

        @Override
        public final Builder slotTypeName(String slotTypeName) {
            this.slotTypeName = slotTypeName;
            return this;
        }

        public final void setSlotTypeName(String slotTypeName) {
            this.slotTypeName = slotTypeName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<SlotTypeValue.Builder> getSlotTypeValues() {
            if (slotTypeValues instanceof SdkAutoConstructList) {
                return null;
            }
            return slotTypeValues != null ? slotTypeValues.stream().map(SlotTypeValue::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder slotTypeValues(Collection<SlotTypeValue> slotTypeValues) {
            this.slotTypeValues = SlotTypeValuesCopier.copy(slotTypeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypeValues(SlotTypeValue... slotTypeValues) {
            slotTypeValues(Arrays.asList(slotTypeValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypeValues(Consumer<SlotTypeValue.Builder>... slotTypeValues) {
            slotTypeValues(Stream.of(slotTypeValues).map(c -> SlotTypeValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSlotTypeValues(Collection<SlotTypeValue.BuilderImpl> slotTypeValues) {
            this.slotTypeValues = SlotTypeValuesCopier.copyFromBuilder(slotTypeValues);
        }

        public final SlotValueSelectionSetting.Builder getValueSelectionSetting() {
            return valueSelectionSetting != null ? valueSelectionSetting.toBuilder() : null;
        }

        @Override
        public final Builder valueSelectionSetting(SlotValueSelectionSetting valueSelectionSetting) {
            this.valueSelectionSetting = valueSelectionSetting;
            return this;
        }

        public final void setValueSelectionSetting(SlotValueSelectionSetting.BuilderImpl valueSelectionSetting) {
            this.valueSelectionSetting = valueSelectionSetting != null ? valueSelectionSetting.build() : null;
        }

        public final String getParentSlotTypeSignature() {
            return parentSlotTypeSignature;
        }

        @Override
        public final Builder parentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
            return this;
        }

        public final void setParentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
        }

        public final String getBotId() {
            return botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final String getLocaleId() {
            return localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public DescribeSlotTypeResponse build() {
            return new DescribeSlotTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
