/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures conversation logging that saves audio, text, and metadata for the conversations with your users.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConversationLogSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ConversationLogSettings.Builder, ConversationLogSettings> {
    private static final SdkField<List<TextLogSetting>> TEXT_LOG_SETTINGS_FIELD = SdkField
            .<List<TextLogSetting>> builder(MarshallingType.LIST)
            .memberName("textLogSettings")
            .getter(getter(ConversationLogSettings::textLogSettings))
            .setter(setter(Builder::textLogSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textLogSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TextLogSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(TextLogSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AudioLogSetting>> AUDIO_LOG_SETTINGS_FIELD = SdkField
            .<List<AudioLogSetting>> builder(MarshallingType.LIST)
            .memberName("audioLogSettings")
            .getter(getter(ConversationLogSettings::audioLogSettings))
            .setter(setter(Builder::audioLogSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioLogSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AudioLogSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(AudioLogSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_LOG_SETTINGS_FIELD,
            AUDIO_LOG_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<TextLogSetting> textLogSettings;

    private final List<AudioLogSetting> audioLogSettings;

    private ConversationLogSettings(BuilderImpl builder) {
        this.textLogSettings = builder.textLogSettings;
        this.audioLogSettings = builder.audioLogSettings;
    }

    /**
     * Returns true if the TextLogSettings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTextLogSettings() {
        return textLogSettings != null && !(textLogSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon CloudWatch Logs settings for logging text and metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTextLogSettings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon CloudWatch Logs settings for logging text and metadata.
     */
    public final List<TextLogSetting> textLogSettings() {
        return textLogSettings;
    }

    /**
     * Returns true if the AudioLogSettings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAudioLogSettings() {
        return audioLogSettings != null && !(audioLogSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon S3 settings for logging audio to an S3 bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAudioLogSettings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon S3 settings for logging audio to an S3 bucket.
     */
    public final List<AudioLogSetting> audioLogSettings() {
        return audioLogSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTextLogSettings() ? textLogSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAudioLogSettings() ? audioLogSettings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversationLogSettings)) {
            return false;
        }
        ConversationLogSettings other = (ConversationLogSettings) obj;
        return hasTextLogSettings() == other.hasTextLogSettings() && Objects.equals(textLogSettings(), other.textLogSettings())
                && hasAudioLogSettings() == other.hasAudioLogSettings()
                && Objects.equals(audioLogSettings(), other.audioLogSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConversationLogSettings")
                .add("TextLogSettings", hasTextLogSettings() ? textLogSettings() : null)
                .add("AudioLogSettings", hasAudioLogSettings() ? audioLogSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "textLogSettings":
            return Optional.ofNullable(clazz.cast(textLogSettings()));
        case "audioLogSettings":
            return Optional.ofNullable(clazz.cast(audioLogSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConversationLogSettings, T> g) {
        return obj -> g.apply((ConversationLogSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConversationLogSettings> {
        /**
         * <p>
         * The Amazon CloudWatch Logs settings for logging text and metadata.
         * </p>
         * 
         * @param textLogSettings
         *        The Amazon CloudWatch Logs settings for logging text and metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textLogSettings(Collection<TextLogSetting> textLogSettings);

        /**
         * <p>
         * The Amazon CloudWatch Logs settings for logging text and metadata.
         * </p>
         * 
         * @param textLogSettings
         *        The Amazon CloudWatch Logs settings for logging text and metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textLogSettings(TextLogSetting... textLogSettings);

        /**
         * <p>
         * The Amazon CloudWatch Logs settings for logging text and metadata.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TextLogSetting>.Builder} avoiding the need
         * to create one manually via {@link List<TextLogSetting>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TextLogSetting>.Builder#build()} is called immediately and
         * its result is passed to {@link #textLogSettings(List<TextLogSetting>)}.
         * 
         * @param textLogSettings
         *        a consumer that will call methods on {@link List<TextLogSetting>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textLogSettings(List<TextLogSetting>)
         */
        Builder textLogSettings(Consumer<TextLogSetting.Builder>... textLogSettings);

        /**
         * <p>
         * The Amazon S3 settings for logging audio to an S3 bucket.
         * </p>
         * 
         * @param audioLogSettings
         *        The Amazon S3 settings for logging audio to an S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioLogSettings(Collection<AudioLogSetting> audioLogSettings);

        /**
         * <p>
         * The Amazon S3 settings for logging audio to an S3 bucket.
         * </p>
         * 
         * @param audioLogSettings
         *        The Amazon S3 settings for logging audio to an S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioLogSettings(AudioLogSetting... audioLogSettings);

        /**
         * <p>
         * The Amazon S3 settings for logging audio to an S3 bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AudioLogSetting>.Builder} avoiding the need
         * to create one manually via {@link List<AudioLogSetting>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AudioLogSetting>.Builder#build()} is called immediately and
         * its result is passed to {@link #audioLogSettings(List<AudioLogSetting>)}.
         * 
         * @param audioLogSettings
         *        a consumer that will call methods on {@link List<AudioLogSetting>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioLogSettings(List<AudioLogSetting>)
         */
        Builder audioLogSettings(Consumer<AudioLogSetting.Builder>... audioLogSettings);
    }

    static final class BuilderImpl implements Builder {
        private List<TextLogSetting> textLogSettings = DefaultSdkAutoConstructList.getInstance();

        private List<AudioLogSetting> audioLogSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConversationLogSettings model) {
            textLogSettings(model.textLogSettings);
            audioLogSettings(model.audioLogSettings);
        }

        public final Collection<TextLogSetting.Builder> getTextLogSettings() {
            if (textLogSettings instanceof SdkAutoConstructList) {
                return null;
            }
            return textLogSettings != null ? textLogSettings.stream().map(TextLogSetting::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder textLogSettings(Collection<TextLogSetting> textLogSettings) {
            this.textLogSettings = TextLogSettingsListCopier.copy(textLogSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textLogSettings(TextLogSetting... textLogSettings) {
            textLogSettings(Arrays.asList(textLogSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textLogSettings(Consumer<TextLogSetting.Builder>... textLogSettings) {
            textLogSettings(Stream.of(textLogSettings).map(c -> TextLogSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTextLogSettings(Collection<TextLogSetting.BuilderImpl> textLogSettings) {
            this.textLogSettings = TextLogSettingsListCopier.copyFromBuilder(textLogSettings);
        }

        public final Collection<AudioLogSetting.Builder> getAudioLogSettings() {
            if (audioLogSettings instanceof SdkAutoConstructList) {
                return null;
            }
            return audioLogSettings != null ? audioLogSettings.stream().map(AudioLogSetting::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder audioLogSettings(Collection<AudioLogSetting> audioLogSettings) {
            this.audioLogSettings = AudioLogSettingsListCopier.copy(audioLogSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioLogSettings(AudioLogSetting... audioLogSettings) {
            audioLogSettings(Arrays.asList(audioLogSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioLogSettings(Consumer<AudioLogSetting.Builder>... audioLogSettings) {
            audioLogSettings(Stream.of(audioLogSettings).map(c -> AudioLogSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAudioLogSettings(Collection<AudioLogSetting.BuilderImpl> audioLogSettings) {
            this.audioLogSettings = AudioLogSettingsListCopier.copyFromBuilder(audioLogSettings);
        }

        @Override
        public ConversationLogSettings build() {
            return new ConversationLogSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
