/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about code hooks that Amazon Lex calls during a conversation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeHookSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeHookSpecification.Builder, CodeHookSpecification> {
    private static final SdkField<LambdaCodeHook> LAMBDA_CODE_HOOK_FIELD = SdkField
            .<LambdaCodeHook> builder(MarshallingType.SDK_POJO).memberName("lambdaCodeHook")
            .getter(getter(CodeHookSpecification::lambdaCodeHook)).setter(setter(Builder::lambdaCodeHook))
            .constructor(LambdaCodeHook::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaCodeHook").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_CODE_HOOK_FIELD));

    private static final long serialVersionUID = 1L;

    private final LambdaCodeHook lambdaCodeHook;

    private CodeHookSpecification(BuilderImpl builder) {
        this.lambdaCodeHook = builder.lambdaCodeHook;
    }

    /**
     * Returns the value of the LambdaCodeHook property for this object.
     * 
     * @return The value of the LambdaCodeHook property for this object.
     */
    public final LambdaCodeHook lambdaCodeHook() {
        return lambdaCodeHook;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambdaCodeHook());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeHookSpecification)) {
            return false;
        }
        CodeHookSpecification other = (CodeHookSpecification) obj;
        return Objects.equals(lambdaCodeHook(), other.lambdaCodeHook());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeHookSpecification").add("LambdaCodeHook", lambdaCodeHook()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lambdaCodeHook":
            return Optional.ofNullable(clazz.cast(lambdaCodeHook()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeHookSpecification, T> g) {
        return obj -> g.apply((CodeHookSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeHookSpecification> {
        /**
         * Sets the value of the LambdaCodeHook property for this object.
         *
         * @param lambdaCodeHook
         *        The new value for the LambdaCodeHook property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaCodeHook(LambdaCodeHook lambdaCodeHook);

        /**
         * Sets the value of the LambdaCodeHook property for this object.
         *
         * This is a convenience that creates an instance of the {@link LambdaCodeHook.Builder} avoiding the need to
         * create one manually via {@link LambdaCodeHook#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaCodeHook.Builder#build()} is called immediately and its
         * result is passed to {@link #lambdaCodeHook(LambdaCodeHook)}.
         * 
         * @param lambdaCodeHook
         *        a consumer that will call methods on {@link LambdaCodeHook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaCodeHook(LambdaCodeHook)
         */
        default Builder lambdaCodeHook(Consumer<LambdaCodeHook.Builder> lambdaCodeHook) {
            return lambdaCodeHook(LambdaCodeHook.builder().applyMutation(lambdaCodeHook).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LambdaCodeHook lambdaCodeHook;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeHookSpecification model) {
            lambdaCodeHook(model.lambdaCodeHook);
        }

        public final LambdaCodeHook.Builder getLambdaCodeHook() {
            return lambdaCodeHook != null ? lambdaCodeHook.toBuilder() : null;
        }

        @Override
        public final Builder lambdaCodeHook(LambdaCodeHook lambdaCodeHook) {
            this.lambdaCodeHook = lambdaCodeHook;
            return this;
        }

        public final void setLambdaCodeHook(LambdaCodeHook.BuilderImpl lambdaCodeHook) {
            this.lambdaCodeHook = lambdaCodeHook != null ? lambdaCodeHook.build() : null;
        }

        @Override
        public CodeHookSpecification build() {
            return new CodeHookSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
