/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingException;
import software.amazon.awssdk.services.lexmodelbuilding.model.ReferenceType;
import software.amazon.awssdk.services.lexmodelbuilding.model.ResourceReference;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceInUseException
extends LexModelBuildingException
implements ToCopyableBuilder<Builder, ResourceInUseException> {
    private static final SdkField<String> REFERENCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceType").getter(ResourceInUseException.getter(ResourceInUseException::referenceTypeAsString)).setter(ResourceInUseException.setter(Builder::referenceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceType").build()}).build();
    private static final SdkField<ResourceReference> EXAMPLE_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("exampleReference").getter(ResourceInUseException.getter(ResourceInUseException::exampleReference)).setter(ResourceInUseException.setter(Builder::exampleReference)).constructor(ResourceReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exampleReference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_TYPE_FIELD, EXAMPLE_REFERENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceInUseException.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String referenceType;
    private final ResourceReference exampleReference;

    private ResourceInUseException(BuilderImpl builder) {
        super(builder);
        this.referenceType = builder.referenceType;
        this.exampleReference = builder.exampleReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public ReferenceType referenceType() {
        return ReferenceType.fromValue(this.referenceType);
    }

    public String referenceTypeAsString() {
        return this.referenceType;
    }

    public ResourceReference exampleReference() {
        return this.exampleReference;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("referenceType", REFERENCE_TYPE_FIELD);
        map.put("exampleReference", EXAMPLE_REFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceInUseException, T> g) {
        return obj -> g.apply((ResourceInUseException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingException.BuilderImpl
    implements Builder {
        private String referenceType;
        private ResourceReference exampleReference;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceInUseException model) {
            super(model);
            this.referenceType(model.referenceType);
            this.exampleReference(model.exampleReference);
        }

        public final String getReferenceType() {
            return this.referenceType;
        }

        public final void setReferenceType(String referenceType) {
            this.referenceType = referenceType;
        }

        @Override
        public final Builder referenceType(String referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        @Override
        public final Builder referenceType(ReferenceType referenceType) {
            this.referenceType(referenceType == null ? null : referenceType.toString());
            return this;
        }

        public final ResourceReference.Builder getExampleReference() {
            return this.exampleReference != null ? this.exampleReference.toBuilder() : null;
        }

        public final void setExampleReference(ResourceReference.BuilderImpl exampleReference) {
            this.exampleReference = exampleReference != null ? exampleReference.build() : null;
        }

        @Override
        public final Builder exampleReference(ResourceReference exampleReference) {
            this.exampleReference = exampleReference;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public ResourceInUseException build() {
            return new ResourceInUseException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceInUseException>,
    LexModelBuildingException.Builder {
        public Builder referenceType(String var1);

        public Builder referenceType(ReferenceType var1);

        public Builder exampleReference(ResourceReference var1);

        default public Builder exampleReference(Consumer<ResourceReference.Builder> exampleReference) {
            return this.exampleReference((ResourceReference)((ResourceReference.Builder)ResourceReference.builder().applyMutation(exampleReference)).build());
        }

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);

        @Override
        public Builder numAttempts(Integer var1);
    }
}

