/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingAsyncClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentsResponse;

public class GetBuiltinIntentsPublisher
implements SdkPublisher<GetBuiltinIntentsResponse> {
    private final LexModelBuildingAsyncClient client;
    private final GetBuiltinIntentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetBuiltinIntentsPublisher(LexModelBuildingAsyncClient client, GetBuiltinIntentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetBuiltinIntentsPublisher(LexModelBuildingAsyncClient client, GetBuiltinIntentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetBuiltinIntentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetBuiltinIntentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetBuiltinIntentsResponseFetcher
    implements AsyncPageFetcher<GetBuiltinIntentsResponse> {
        private GetBuiltinIntentsResponseFetcher() {
        }

        public boolean hasNextPage(GetBuiltinIntentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetBuiltinIntentsResponse> nextPage(GetBuiltinIntentsResponse previousPage) {
            if (previousPage == null) {
                return GetBuiltinIntentsPublisher.this.client.getBuiltinIntents(GetBuiltinIntentsPublisher.this.firstRequest);
            }
            return GetBuiltinIntentsPublisher.this.client.getBuiltinIntents((GetBuiltinIntentsRequest)((Object)GetBuiltinIntentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

