/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelbuilding.model.ContentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Message
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Message> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(Message.getter(Message::contentTypeAsString)).setter(Message.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("content").getter(Message.getter(Message::content)).setter(Message.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<Integer> GROUP_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("groupNumber").getter(Message.getter(Message::groupNumber)).setter(Message.setter(Builder::groupNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD, CONTENT_FIELD, GROUP_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String contentType;
    private final String content;
    private final Integer groupNumber;

    private Message(BuilderImpl builder) {
        this.contentType = builder.contentType;
        this.content = builder.content;
        this.groupNumber = builder.groupNumber;
    }

    public final ContentType contentType() {
        return ContentType.fromValue(this.contentType);
    }

    public final String contentTypeAsString() {
        return this.contentType;
    }

    public final String content() {
        return this.content;
    }

    public final Integer groupNumber() {
        return this.groupNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        return Objects.equals(this.contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.groupNumber(), other.groupNumber());
    }

    public final String toString() {
        return ToString.builder((String)"Message").add("ContentType", (Object)this.contentTypeAsString()).add("Content", (Object)this.content()).add("GroupNumber", (Object)this.groupNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentTypeAsString()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "groupNumber": {
                return Optional.ofNullable(clazz.cast(this.groupNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Message, T> g) {
        return obj -> g.apply((Message)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contentType;
        private String content;
        private Integer groupNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            this.contentType(model.contentType);
            this.content(model.content);
            this.groupNumber(model.groupNumber);
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(ContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final Integer getGroupNumber() {
            return this.groupNumber;
        }

        @Override
        public final Builder groupNumber(Integer groupNumber) {
            this.groupNumber = groupNumber;
            return this;
        }

        public final void setGroupNumber(Integer groupNumber) {
            this.groupNumber = groupNumber;
        }

        public Message build() {
            return new Message(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Message> {
        public Builder contentType(String var1);

        public Builder contentType(ContentType var1);

        public Builder content(String var1);

        public Builder groupNumber(Integer var1);
    }
}

