/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotTypeMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotTypeMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSlotTypesResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, GetSlotTypesResponse> {
    private static final SdkField<List<SlotTypeMetadata>> SLOT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("slotTypes").getter(GetSlotTypesResponse.getter(GetSlotTypesResponse::slotTypes)).setter(GetSlotTypesResponse.setter(Builder::slotTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SlotTypeMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetSlotTypesResponse.getter(GetSlotTypesResponse::nextToken)).setter(GetSlotTypesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_TYPES_FIELD, NEXT_TOKEN_FIELD));
    private final List<SlotTypeMetadata> slotTypes;
    private final String nextToken;

    private GetSlotTypesResponse(BuilderImpl builder) {
        super(builder);
        this.slotTypes = builder.slotTypes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSlotTypes() {
        return this.slotTypes != null && !(this.slotTypes instanceof SdkAutoConstructList);
    }

    public final List<SlotTypeMetadata> slotTypes() {
        return this.slotTypes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSlotTypes() ? this.slotTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSlotTypesResponse)) {
            return false;
        }
        GetSlotTypesResponse other = (GetSlotTypesResponse)((Object)obj);
        return this.hasSlotTypes() == other.hasSlotTypes() && Objects.equals(this.slotTypes(), other.slotTypes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetSlotTypesResponse").add("SlotTypes", this.hasSlotTypes() ? this.slotTypes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "slotTypes": {
                return Optional.ofNullable(clazz.cast(this.slotTypes()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSlotTypesResponse, T> g) {
        return obj -> g.apply((GetSlotTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private List<SlotTypeMetadata> slotTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSlotTypesResponse model) {
            super(model);
            this.slotTypes(model.slotTypes);
            this.nextToken(model.nextToken);
        }

        public final List<SlotTypeMetadata.Builder> getSlotTypes() {
            List<SlotTypeMetadata.Builder> result = SlotTypeMetadataListCopier.copyToBuilder(this.slotTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder slotTypes(Collection<SlotTypeMetadata> slotTypes) {
            this.slotTypes = SlotTypeMetadataListCopier.copy(slotTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypes(SlotTypeMetadata ... slotTypes) {
            this.slotTypes(Arrays.asList(slotTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypes(Consumer<SlotTypeMetadata.Builder> ... slotTypes) {
            this.slotTypes(Stream.of(slotTypes).map(c -> (SlotTypeMetadata)((SlotTypeMetadata.Builder)SlotTypeMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSlotTypes(Collection<SlotTypeMetadata.BuilderImpl> slotTypes) {
            this.slotTypes = SlotTypeMetadataListCopier.copyFromBuilder(slotTypes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetSlotTypesResponse build() {
            return new GetSlotTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSlotTypesResponse> {
        public Builder slotTypes(Collection<SlotTypeMetadata> var1);

        public Builder slotTypes(SlotTypeMetadata ... var1);

        public Builder slotTypes(Consumer<SlotTypeMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

