/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings used to configure delivery mode and destination for conversation logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogSettingsRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<LogSettingsRequest.Builder, LogSettingsRequest> {
    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logType").getter(getter(LogSettingsRequest::logTypeAsString)).setter(setter(Builder::logType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logType").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destination").getter(getter(LogSettingsRequest::destinationAsString))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(LogSettingsRequest::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(LogSettingsRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_TYPE_FIELD,
            DESTINATION_FIELD, KMS_KEY_ARN_FIELD, RESOURCE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logType;

    private final String destination;

    private final String kmsKeyArn;

    private final String resourceArn;

    private LogSettingsRequest(BuilderImpl builder) {
        this.logType = builder.logType;
        this.destination = builder.destination;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * The type of logging to enable. Text logs are delivered to a CloudWatch Logs log group. Audio logs are delivered
     * to an S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link LogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return The type of logging to enable. Text logs are delivered to a CloudWatch Logs log group. Audio logs are
     *         delivered to an S3 bucket.
     * @see LogType
     */
    public final LogType logType() {
        return LogType.fromValue(logType);
    }

    /**
     * <p>
     * The type of logging to enable. Text logs are delivered to a CloudWatch Logs log group. Audio logs are delivered
     * to an S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link LogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return The type of logging to enable. Text logs are delivered to a CloudWatch Logs log group. Audio logs are
     *         delivered to an S3 bucket.
     * @see LogType
     */
    public final String logTypeAsString() {
        return logType;
    }

    /**
     * <p>
     * Where the logs will be delivered. Text logs are delivered to a CloudWatch Logs log group. Audio logs are
     * delivered to an S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link Destination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return Where the logs will be delivered. Text logs are delivered to a CloudWatch Logs log group. Audio logs are
     *         delivered to an S3 bucket.
     * @see Destination
     */
    public final Destination destination() {
        return Destination.fromValue(destination);
    }

    /**
     * <p>
     * Where the logs will be delivered. Text logs are delivered to a CloudWatch Logs log group. Audio logs are
     * delivered to an S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link Destination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return Where the logs will be delivered. Text logs are delivered to a CloudWatch Logs log group. Audio logs are
     *         delivered to an S3 bucket.
     * @see Destination
     */
    public final String destinationAsString() {
        return destination;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS KMS customer managed key for encrypting audio logs delivered to an S3
     * bucket. The key does not apply to CloudWatch Logs and is optional for S3 buckets.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS KMS customer managed key for encrypting audio logs delivered to
     *         an S3 bucket. The key does not apply to CloudWatch Logs and is optional for S3 buckets.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3 bucket where the logs should be delivered.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3 bucket where the logs should be
     *         delivered.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogSettingsRequest)) {
            return false;
        }
        LogSettingsRequest other = (LogSettingsRequest) obj;
        return Objects.equals(logTypeAsString(), other.logTypeAsString())
                && Objects.equals(destinationAsString(), other.destinationAsString())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogSettingsRequest").add("LogType", logTypeAsString()).add("Destination", destinationAsString())
                .add("KmsKeyArn", kmsKeyArn()).add("ResourceArn", resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logType":
            return Optional.ofNullable(clazz.cast(logTypeAsString()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destinationAsString()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogSettingsRequest, T> g) {
        return obj -> g.apply((LogSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogSettingsRequest> {
        /**
         * <p>
         * The type of logging to enable. Text logs are delivered to a CloudWatch Logs log group. Audio logs are
         * delivered to an S3 bucket.
         * </p>
         * 
         * @param logType
         *        The type of logging to enable. Text logs are delivered to a CloudWatch Logs log group. Audio logs are
         *        delivered to an S3 bucket.
         * @see LogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogType
         */
        Builder logType(String logType);

        /**
         * <p>
         * The type of logging to enable. Text logs are delivered to a CloudWatch Logs log group. Audio logs are
         * delivered to an S3 bucket.
         * </p>
         * 
         * @param logType
         *        The type of logging to enable. Text logs are delivered to a CloudWatch Logs log group. Audio logs are
         *        delivered to an S3 bucket.
         * @see LogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogType
         */
        Builder logType(LogType logType);

        /**
         * <p>
         * Where the logs will be delivered. Text logs are delivered to a CloudWatch Logs log group. Audio logs are
         * delivered to an S3 bucket.
         * </p>
         * 
         * @param destination
         *        Where the logs will be delivered. Text logs are delivered to a CloudWatch Logs log group. Audio logs
         *        are delivered to an S3 bucket.
         * @see Destination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Destination
         */
        Builder destination(String destination);

        /**
         * <p>
         * Where the logs will be delivered. Text logs are delivered to a CloudWatch Logs log group. Audio logs are
         * delivered to an S3 bucket.
         * </p>
         * 
         * @param destination
         *        Where the logs will be delivered. Text logs are delivered to a CloudWatch Logs log group. Audio logs
         *        are delivered to an S3 bucket.
         * @see Destination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Destination
         */
        Builder destination(Destination destination);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS KMS customer managed key for encrypting audio logs delivered to an
         * S3 bucket. The key does not apply to CloudWatch Logs and is optional for S3 buckets.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the AWS KMS customer managed key for encrypting audio logs delivered
         *        to an S3 bucket. The key does not apply to CloudWatch Logs and is optional for S3 buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3 bucket where the logs should be
         * delivered.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3 bucket where the logs should be
         *        delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);
    }

    static final class BuilderImpl implements Builder {
        private String logType;

        private String destination;

        private String kmsKeyArn;

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LogSettingsRequest model) {
            logType(model.logType);
            destination(model.destination);
            kmsKeyArn(model.kmsKeyArn);
            resourceArn(model.resourceArn);
        }

        public final String getLogType() {
            return logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        public final Builder logType(LogType logType) {
            this.logType(logType == null ? null : logType.toString());
            return this;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        public final String getDestination() {
            return destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination(destination == null ? null : destination.toString());
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public LogSettingsRequest build() {
            return new LogSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
