/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBotRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<GetBotRequest.Builder, GetBotRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetBotRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> VERSION_OR_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionOrAlias").getter(getter(GetBotRequest::versionOrAlias)).setter(setter(Builder::versionOrAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("versionoralias").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            VERSION_OR_ALIAS_FIELD));

    private final String name;

    private final String versionOrAlias;

    private GetBotRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.versionOrAlias = builder.versionOrAlias;
    }

    /**
     * <p>
     * The name of the bot. The name is case sensitive.
     * </p>
     * 
     * @return The name of the bot. The name is case sensitive.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The version or alias of the bot.
     * </p>
     * 
     * @return The version or alias of the bot.
     */
    public final String versionOrAlias() {
        return versionOrAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(versionOrAlias());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotRequest)) {
            return false;
        }
        GetBotRequest other = (GetBotRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(versionOrAlias(), other.versionOrAlias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBotRequest").add("Name", name()).add("VersionOrAlias", versionOrAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "versionOrAlias":
            return Optional.ofNullable(clazz.cast(versionOrAlias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBotRequest, T> g) {
        return obj -> g.apply((GetBotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetBotRequest> {
        /**
         * <p>
         * The name of the bot. The name is case sensitive.
         * </p>
         * 
         * @param name
         *        The name of the bot. The name is case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version or alias of the bot.
         * </p>
         * 
         * @param versionOrAlias
         *        The version or alias of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionOrAlias(String versionOrAlias);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String name;

        private String versionOrAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotRequest model) {
            super(model);
            name(model.name);
            versionOrAlias(model.versionOrAlias);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersionOrAlias() {
            return versionOrAlias;
        }

        @Override
        public final Builder versionOrAlias(String versionOrAlias) {
            this.versionOrAlias = versionOrAlias;
            return this;
        }

        public final void setVersionOrAlias(String versionOrAlias) {
            this.versionOrAlias = versionOrAlias;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBotRequest build() {
            return new GetBotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
