/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasesResponse;

public class GetBotAliasesIterable
implements SdkIterable<GetBotAliasesResponse> {
    private final LexModelBuildingClient client;
    private final GetBotAliasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetBotAliasesIterable(LexModelBuildingClient client, GetBotAliasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetBotAliasesResponseFetcher();
    }

    public Iterator<GetBotAliasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetBotAliasesResponseFetcher
    implements SyncPageFetcher<GetBotAliasesResponse> {
        private GetBotAliasesResponseFetcher() {
        }

        public boolean hasNextPage(GetBotAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetBotAliasesResponse nextPage(GetBotAliasesResponse previousPage) {
            if (previousPage == null) {
                return GetBotAliasesIterable.this.client.getBotAliases(GetBotAliasesIterable.this.firstRequest);
            }
            return GetBotAliasesIterable.this.client.getBotAliases((GetBotAliasesRequest)((Object)GetBotAliasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

