/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutBotRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<PutBotRequest.Builder, PutBotRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutBotRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutBotRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Intent>> INTENTS_FIELD = SdkField
            .<List<Intent>> builder(MarshallingType.LIST)
            .getter(getter(PutBotRequest::intents))
            .setter(setter(Builder::intents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Intent> builder(MarshallingType.SDK_POJO)
                                            .constructor(Intent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Prompt> CLARIFICATION_PROMPT_FIELD = SdkField.<Prompt> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutBotRequest::clarificationPrompt)).setter(setter(Builder::clarificationPrompt))
            .constructor(Prompt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clarificationPrompt").build())
            .build();

    private static final SdkField<Statement> ABORT_STATEMENT_FIELD = SdkField.<Statement> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutBotRequest::abortStatement)).setter(setter(Builder::abortStatement))
            .constructor(Statement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("abortStatement").build()).build();

    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(PutBotRequest::idleSessionTTLInSeconds))
            .setter(setter(Builder::idleSessionTTLInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build())
            .build();

    private static final SdkField<String> VOICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutBotRequest::voiceId)).setter(setter(Builder::voiceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voiceId").build()).build();

    private static final SdkField<String> CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutBotRequest::checksum)).setter(setter(Builder::checksum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()).build();

    private static final SdkField<String> PROCESS_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutBotRequest::processBehaviorAsString)).setter(setter(Builder::processBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processBehavior").build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutBotRequest::localeAsString)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()).build();

    private static final SdkField<Boolean> CHILD_DIRECTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PutBotRequest::childDirected)).setter(setter(Builder::childDirected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childDirected").build()).build();

    private static final SdkField<Boolean> DETECT_SENTIMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PutBotRequest::detectSentiment)).setter(setter(Builder::detectSentiment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectSentiment").build()).build();

    private static final SdkField<Boolean> CREATE_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PutBotRequest::createVersion)).setter(setter(Builder::createVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createVersion").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(PutBotRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            INTENTS_FIELD, CLARIFICATION_PROMPT_FIELD, ABORT_STATEMENT_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, VOICE_ID_FIELD,
            CHECKSUM_FIELD, PROCESS_BEHAVIOR_FIELD, LOCALE_FIELD, CHILD_DIRECTED_FIELD, DETECT_SENTIMENT_FIELD,
            CREATE_VERSION_FIELD, TAGS_FIELD));

    private final String name;

    private final String description;

    private final List<Intent> intents;

    private final Prompt clarificationPrompt;

    private final Statement abortStatement;

    private final Integer idleSessionTTLInSeconds;

    private final String voiceId;

    private final String checksum;

    private final String processBehavior;

    private final String locale;

    private final Boolean childDirected;

    private final Boolean detectSentiment;

    private final Boolean createVersion;

    private final List<Tag> tags;

    private PutBotRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.intents = builder.intents;
        this.clarificationPrompt = builder.clarificationPrompt;
        this.abortStatement = builder.abortStatement;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.voiceId = builder.voiceId;
        this.checksum = builder.checksum;
        this.processBehavior = builder.processBehavior;
        this.locale = builder.locale;
        this.childDirected = builder.childDirected;
        this.detectSentiment = builder.detectSentiment;
        this.createVersion = builder.createVersion;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the bot. The name is <i>not</i> case sensitive.
     * </p>
     * 
     * @return The name of the bot. The name is <i>not</i> case sensitive.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the bot.
     * </p>
     * 
     * @return A description of the bot.
     */
    public String description() {
        return description;
    }

    /**
     * Returns true if the Intents property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIntents() {
        return intents != null && !(intents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Intent</code> objects. Each intent represents a command that a user can express. For example, a
     * pizza ordering bot might support an OrderPizza intent. For more information, see <a>how-it-works</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIntents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>Intent</code> objects. Each intent represents a command that a user can express. For
     *         example, a pizza ordering bot might support an OrderPizza intent. For more information, see
     *         <a>how-it-works</a>.
     */
    public List<Intent> intents() {
        return intents;
    }

    /**
     * <p>
     * When Amazon Lex doesn't understand the user's intent, it uses this message to get clarification. To specify how
     * many times Amazon Lex should repeat the clarification prompt, use the <code>maxAttempts</code> field. If Amazon
     * Lex still doesn't understand, it sends the message in the <code>abortStatement</code> field.
     * </p>
     * <p>
     * When you create a clarification prompt, make sure that it suggests the correct response from the user. for
     * example, for a bot that orders pizza and drinks, you might create this clarification prompt:
     * "What would you like to do? You can say 'Order a pizza' or 'Order a drink.'"
     * </p>
     * <p>
     * If you have defined a fallback intent, it will be invoked if the clarification prompt is repeated the number of
     * times defined in the <code>maxAttempts</code> field. For more information, see <a
     * href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html"> AMAZON.FallbackIntent</a>.
     * </p>
     * <p>
     * If you don't define a clarification prompt, at runtime Amazon Lex will return a 400 Bad Request exception in
     * three cases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Follow-up prompt - When the user responds to a follow-up prompt but does not provide an intent. For example, in
     * response to a follow-up prompt that says "Would you like anything else today?" the user says "Yes." Amazon Lex
     * will return a 400 Bad Request exception because it does not have a clarification prompt to send to the user to
     * get an intent.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lambda function - When using a Lambda function, you return an <code>ElicitIntent</code> dialog type. Since Amazon
     * Lex does not have a clarification prompt to get an intent from the user, it returns a 400 Bad Request exception.
     * </p>
     * </li>
     * <li>
     * <p>
     * PutSession operation - When using the <code>PutSession</code> operation, you send an <code>ElicitIntent</code>
     * dialog type. Since Amazon Lex does not have a clarification prompt to get an intent from the user, it returns a
     * 400 Bad Request exception.
     * </p>
     * </li>
     * </ul>
     * 
     * @return When Amazon Lex doesn't understand the user's intent, it uses this message to get clarification. To
     *         specify how many times Amazon Lex should repeat the clarification prompt, use the
     *         <code>maxAttempts</code> field. If Amazon Lex still doesn't understand, it sends the message in the
     *         <code>abortStatement</code> field. </p>
     *         <p>
     *         When you create a clarification prompt, make sure that it suggests the correct response from the user.
     *         for example, for a bot that orders pizza and drinks, you might create this clarification prompt:
     *         "What would you like to do? You can say 'Order a pizza' or 'Order a drink.'"
     *         </p>
     *         <p>
     *         If you have defined a fallback intent, it will be invoked if the clarification prompt is repeated the
     *         number of times defined in the <code>maxAttempts</code> field. For more information, see <a
     *         href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html">
     *         AMAZON.FallbackIntent</a>.
     *         </p>
     *         <p>
     *         If you don't define a clarification prompt, at runtime Amazon Lex will return a 400 Bad Request exception
     *         in three cases:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Follow-up prompt - When the user responds to a follow-up prompt but does not provide an intent. For
     *         example, in response to a follow-up prompt that says "Would you like anything else today?" the user says
     *         "Yes." Amazon Lex will return a 400 Bad Request exception because it does not have a clarification prompt
     *         to send to the user to get an intent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Lambda function - When using a Lambda function, you return an <code>ElicitIntent</code> dialog type.
     *         Since Amazon Lex does not have a clarification prompt to get an intent from the user, it returns a 400
     *         Bad Request exception.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PutSession operation - When using the <code>PutSession</code> operation, you send an
     *         <code>ElicitIntent</code> dialog type. Since Amazon Lex does not have a clarification prompt to get an
     *         intent from the user, it returns a 400 Bad Request exception.
     *         </p>
     *         </li>
     */
    public Prompt clarificationPrompt() {
        return clarificationPrompt;
    }

    /**
     * <p>
     * When Amazon Lex can't understand the user's input in context, it tries to elicit the information a few times.
     * After that, Amazon Lex sends the message defined in <code>abortStatement</code> to the user, and then aborts the
     * conversation. To set the number of retries, use the <code>valueElicitationPrompt</code> field for the slot type.
     * </p>
     * <p>
     * For example, in a pizza ordering bot, Amazon Lex might ask a user "What type of crust would you like?" If the
     * user's response is not one of the expected responses (for example, "thin crust, "deep dish," etc.), Amazon Lex
     * tries to elicit a correct response a few more times.
     * </p>
     * <p>
     * For example, in a pizza ordering application, <code>OrderPizza</code> might be one of the intents. This intent
     * might require the <code>CrustType</code> slot. You specify the <code>valueElicitationPrompt</code> field when you
     * create the <code>CrustType</code> slot.
     * </p>
     * <p>
     * If you have defined a fallback intent the abort statement will not be sent to the user, the fallback intent is
     * used instead. For more information, see <a
     * href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html"> AMAZON.FallbackIntent</a>.
     * </p>
     * 
     * @return When Amazon Lex can't understand the user's input in context, it tries to elicit the information a few
     *         times. After that, Amazon Lex sends the message defined in <code>abortStatement</code> to the user, and
     *         then aborts the conversation. To set the number of retries, use the <code>valueElicitationPrompt</code>
     *         field for the slot type. </p>
     *         <p>
     *         For example, in a pizza ordering bot, Amazon Lex might ask a user "What type of crust would you like?" If
     *         the user's response is not one of the expected responses (for example, "thin crust, "deep dish," etc.),
     *         Amazon Lex tries to elicit a correct response a few more times.
     *         </p>
     *         <p>
     *         For example, in a pizza ordering application, <code>OrderPizza</code> might be one of the intents. This
     *         intent might require the <code>CrustType</code> slot. You specify the <code>valueElicitationPrompt</code>
     *         field when you create the <code>CrustType</code> slot.
     *         </p>
     *         <p>
     *         If you have defined a fallback intent the abort statement will not be sent to the user, the fallback
     *         intent is used instead. For more information, see <a
     *         href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html">
     *         AMAZON.FallbackIntent</a>.
     */
    public Statement abortStatement() {
        return abortStatement;
    }

    /**
     * <p>
     * The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.
     * </p>
     * <p>
     * A user interaction session remains active for the amount of time specified. If no conversation occurs during this
     * time, the session expires and Amazon Lex deletes any data provided before the timeout.
     * </p>
     * <p>
     * For example, suppose that a user chooses the OrderPizza intent, but gets sidetracked halfway through placing an
     * order. If the user doesn't complete the order within the specified time, Amazon Lex discards the slot information
     * that it gathered, and the user must start over.
     * </p>
     * <p>
     * If you don't include the <code>idleSessionTTLInSeconds</code> element in a <code>PutBot</code> operation request,
     * Amazon Lex uses the default value. This is also true if the request replaces an existing bot.
     * </p>
     * <p>
     * The default is 300 seconds (5 minutes).
     * </p>
     * 
     * @return The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.</p>
     *         <p>
     *         A user interaction session remains active for the amount of time specified. If no conversation occurs
     *         during this time, the session expires and Amazon Lex deletes any data provided before the timeout.
     *         </p>
     *         <p>
     *         For example, suppose that a user chooses the OrderPizza intent, but gets sidetracked halfway through
     *         placing an order. If the user doesn't complete the order within the specified time, Amazon Lex discards
     *         the slot information that it gathered, and the user must start over.
     *         </p>
     *         <p>
     *         If you don't include the <code>idleSessionTTLInSeconds</code> element in a <code>PutBot</code> operation
     *         request, Amazon Lex uses the default value. This is also true if the request replaces an existing bot.
     *         </p>
     *         <p>
     *         The default is 300 seconds (5 minutes).
     */
    public Integer idleSessionTTLInSeconds() {
        return idleSessionTTLInSeconds;
    }

    /**
     * <p>
     * The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The locale
     * configured for the voice must match the locale of the bot. For more information, see <a
     * href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Voices in Amazon Polly</a> in the <i>Amazon
     * Polly Developer Guide</i>.
     * </p>
     * 
     * @return The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The
     *         locale configured for the voice must match the locale of the bot. For more information, see <a
     *         href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Voices in Amazon Polly</a> in the
     *         <i>Amazon Polly Developer Guide</i>.
     */
    public String voiceId() {
        return voiceId;
    }

    /**
     * <p>
     * Identifies a specific revision of the <code>$LATEST</code> version.
     * </p>
     * <p>
     * When you create a new bot, leave the <code>checksum</code> field blank. If you specify a checksum you get a
     * <code>BadRequestException</code> exception.
     * </p>
     * <p>
     * When you want to update a bot, set the <code>checksum</code> field to the checksum of the most recent revision of
     * the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if the checksum does
     * not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.
     * </p>
     * 
     * @return Identifies a specific revision of the <code>$LATEST</code> version.</p>
     *         <p>
     *         When you create a new bot, leave the <code>checksum</code> field blank. If you specify a checksum you get
     *         a <code>BadRequestException</code> exception.
     *         </p>
     *         <p>
     *         When you want to update a bot, set the <code>checksum</code> field to the checksum of the most recent
     *         revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or
     *         if the checksum does not match the <code>$LATEST</code> version, you get a
     *         <code>PreconditionFailedException</code> exception.
     */
    public String checksum() {
        return checksum;
    }

    /**
     * <p>
     * If you set the <code>processBehavior</code> element to <code>BUILD</code>, Amazon Lex builds the bot so that it
     * can be run. If you set the element to <code>SAVE</code> Amazon Lex saves the bot, but doesn't build it.
     * </p>
     * <p>
     * If you don't specify this value, the default value is <code>BUILD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #processBehavior}
     * will return {@link ProcessBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #processBehaviorAsString}.
     * </p>
     * 
     * @return If you set the <code>processBehavior</code> element to <code>BUILD</code>, Amazon Lex builds the bot so
     *         that it can be run. If you set the element to <code>SAVE</code> Amazon Lex saves the bot, but doesn't
     *         build it. </p>
     *         <p>
     *         If you don't specify this value, the default value is <code>BUILD</code>.
     * @see ProcessBehavior
     */
    public ProcessBehavior processBehavior() {
        return ProcessBehavior.fromValue(processBehavior);
    }

    /**
     * <p>
     * If you set the <code>processBehavior</code> element to <code>BUILD</code>, Amazon Lex builds the bot so that it
     * can be run. If you set the element to <code>SAVE</code> Amazon Lex saves the bot, but doesn't build it.
     * </p>
     * <p>
     * If you don't specify this value, the default value is <code>BUILD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #processBehavior}
     * will return {@link ProcessBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #processBehaviorAsString}.
     * </p>
     * 
     * @return If you set the <code>processBehavior</code> element to <code>BUILD</code>, Amazon Lex builds the bot so
     *         that it can be run. If you set the element to <code>SAVE</code> Amazon Lex saves the bot, but doesn't
     *         build it. </p>
     *         <p>
     *         If you don't specify this value, the default value is <code>BUILD</code>.
     * @see ProcessBehavior
     */
    public String processBehaviorAsString() {
        return processBehavior;
    }

    /**
     * <p>
     * Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the
     * bot.
     * </p>
     * <p>
     * The default is <code>en-US</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of
     *         the bot. </p>
     *         <p>
     *         The default is <code>en-US</code>.
     * @see Locale
     */
    public Locale locale() {
        return Locale.fromValue(locale);
    }

    /**
     * <p>
     * Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the
     * bot.
     * </p>
     * <p>
     * The default is <code>en-US</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of
     *         the bot. </p>
     *         <p>
     *         The default is <code>en-US</code>.
     * @see Locale
     */
    public String localeAsString() {
        return locale;
    }

    /**
     * <p>
     * For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of
     * Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in
     * part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying
     * <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code>
     * in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website,
     * program, or other application that is directed or targeted, in whole or in part, to children under age 13 and
     * subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your
     * use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted,
     * in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the
     * <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a
     * website, program, or other application that is directed or targeted, in whole or in part, to children under age
     * 13 and subject to COPPA.
     * </p>
     * <p>
     * If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in
     * part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For
     * information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are
     * directed or targeted, in whole or in part, to children under age 13, see the <a
     * href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
     * </p>
     * 
     * @return For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your
     *         use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in
     *         whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act
     *         (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By
     *         specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon
     *         Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole
     *         or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the
     *         <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a
     *         website, program, or other application that is directed or targeted, in whole or in part, to children
     *         under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code>
     *         field that does not accurately reflect whether your use of Amazon Lex is related to a website, program,
     *         or other application that is directed or targeted, in whole or in part, to children under age 13 and
     *         subject to COPPA.</p>
     *         <p>
     *         If your use of Amazon Lex relates to a website, program, or other application that is directed in whole
     *         or in part, to children under age 13, you must obtain any required verifiable parental consent under
     *         COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other
     *         applications that are directed or targeted, in whole or in part, to children under age 13, see the <a
     *         href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
     */
    public Boolean childDirected() {
        return childDirected;
    }

    /**
     * <p>
     * When set to <code>true</code> user utterances are sent to Amazon Comprehend for sentiment analysis. If you don't
     * specify <code>detectSentiment</code>, the default is <code>false</code>.
     * </p>
     * 
     * @return When set to <code>true</code> user utterances are sent to Amazon Comprehend for sentiment analysis. If
     *         you don't specify <code>detectSentiment</code>, the default is <code>false</code>.
     */
    public Boolean detectSentiment() {
        return detectSentiment;
    }

    /**
     * <p>
     * When set to <code>true</code> a new numbered version of the bot is created. This is the same as calling the
     * <code>CreateBotVersion</code> operation. If you don't specify <code>createVersion</code>, the default is
     * <code>false</code>.
     * </p>
     * 
     * @return When set to <code>true</code> a new numbered version of the bot is created. This is the same as calling
     *         the <code>CreateBotVersion</code> operation. If you don't specify <code>createVersion</code>, the default
     *         is <code>false</code>.
     */
    public Boolean createVersion() {
        return createVersion;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to add to the bot. You can only add tags when you create a bot, you can't use the
     * <code>PutBot</code> operation to update the tags on a bot. To update tags, use the <code>TagResource</code>
     * operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags to add to the bot. You can only add tags when you create a bot, you can't use the
     *         <code>PutBot</code> operation to update the tags on a bot. To update tags, use the
     *         <code>TagResource</code> operation.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(intents());
        hashCode = 31 * hashCode + Objects.hashCode(clarificationPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(abortStatement());
        hashCode = 31 * hashCode + Objects.hashCode(idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(voiceId());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        hashCode = 31 * hashCode + Objects.hashCode(processBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(childDirected());
        hashCode = 31 * hashCode + Objects.hashCode(detectSentiment());
        hashCode = 31 * hashCode + Objects.hashCode(createVersion());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBotRequest)) {
            return false;
        }
        PutBotRequest other = (PutBotRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(intents(), other.intents())
                && Objects.equals(clarificationPrompt(), other.clarificationPrompt())
                && Objects.equals(abortStatement(), other.abortStatement())
                && Objects.equals(idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds())
                && Objects.equals(voiceId(), other.voiceId()) && Objects.equals(checksum(), other.checksum())
                && Objects.equals(processBehaviorAsString(), other.processBehaviorAsString())
                && Objects.equals(localeAsString(), other.localeAsString())
                && Objects.equals(childDirected(), other.childDirected())
                && Objects.equals(detectSentiment(), other.detectSentiment())
                && Objects.equals(createVersion(), other.createVersion()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutBotRequest").add("Name", name()).add("Description", description()).add("Intents", intents())
                .add("ClarificationPrompt", clarificationPrompt()).add("AbortStatement", abortStatement())
                .add("IdleSessionTTLInSeconds", idleSessionTTLInSeconds()).add("VoiceId", voiceId()).add("Checksum", checksum())
                .add("ProcessBehavior", processBehaviorAsString()).add("Locale", localeAsString())
                .add("ChildDirected", childDirected()).add("DetectSentiment", detectSentiment())
                .add("CreateVersion", createVersion()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "intents":
            return Optional.ofNullable(clazz.cast(intents()));
        case "clarificationPrompt":
            return Optional.ofNullable(clazz.cast(clarificationPrompt()));
        case "abortStatement":
            return Optional.ofNullable(clazz.cast(abortStatement()));
        case "idleSessionTTLInSeconds":
            return Optional.ofNullable(clazz.cast(idleSessionTTLInSeconds()));
        case "voiceId":
            return Optional.ofNullable(clazz.cast(voiceId()));
        case "checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        case "processBehavior":
            return Optional.ofNullable(clazz.cast(processBehaviorAsString()));
        case "locale":
            return Optional.ofNullable(clazz.cast(localeAsString()));
        case "childDirected":
            return Optional.ofNullable(clazz.cast(childDirected()));
        case "detectSentiment":
            return Optional.ofNullable(clazz.cast(detectSentiment()));
        case "createVersion":
            return Optional.ofNullable(clazz.cast(createVersion()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutBotRequest, T> g) {
        return obj -> g.apply((PutBotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutBotRequest> {
        /**
         * <p>
         * The name of the bot. The name is <i>not</i> case sensitive.
         * </p>
         * 
         * @param name
         *        The name of the bot. The name is <i>not</i> case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the bot.
         * </p>
         * 
         * @param description
         *        A description of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An array of <code>Intent</code> objects. Each intent represents a command that a user can express. For
         * example, a pizza ordering bot might support an OrderPizza intent. For more information, see
         * <a>how-it-works</a>.
         * </p>
         * 
         * @param intents
         *        An array of <code>Intent</code> objects. Each intent represents a command that a user can express. For
         *        example, a pizza ordering bot might support an OrderPizza intent. For more information, see
         *        <a>how-it-works</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intents(Collection<Intent> intents);

        /**
         * <p>
         * An array of <code>Intent</code> objects. Each intent represents a command that a user can express. For
         * example, a pizza ordering bot might support an OrderPizza intent. For more information, see
         * <a>how-it-works</a>.
         * </p>
         * 
         * @param intents
         *        An array of <code>Intent</code> objects. Each intent represents a command that a user can express. For
         *        example, a pizza ordering bot might support an OrderPizza intent. For more information, see
         *        <a>how-it-works</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intents(Intent... intents);

        /**
         * <p>
         * An array of <code>Intent</code> objects. Each intent represents a command that a user can express. For
         * example, a pizza ordering bot might support an OrderPizza intent. For more information, see
         * <a>how-it-works</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Intent>.Builder} avoiding the need to
         * create one manually via {@link List<Intent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Intent>.Builder#build()} is called immediately and its
         * result is passed to {@link #intents(List<Intent>)}.
         * 
         * @param intents
         *        a consumer that will call methods on {@link List<Intent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intents(List<Intent>)
         */
        Builder intents(Consumer<Intent.Builder>... intents);

        /**
         * <p>
         * When Amazon Lex doesn't understand the user's intent, it uses this message to get clarification. To specify
         * how many times Amazon Lex should repeat the clarification prompt, use the <code>maxAttempts</code> field. If
         * Amazon Lex still doesn't understand, it sends the message in the <code>abortStatement</code> field.
         * </p>
         * <p>
         * When you create a clarification prompt, make sure that it suggests the correct response from the user. for
         * example, for a bot that orders pizza and drinks, you might create this clarification prompt:
         * "What would you like to do? You can say 'Order a pizza' or 'Order a drink.'"
         * </p>
         * <p>
         * If you have defined a fallback intent, it will be invoked if the clarification prompt is repeated the number
         * of times defined in the <code>maxAttempts</code> field. For more information, see <a
         * href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html"> AMAZON.FallbackIntent</a>.
         * </p>
         * <p>
         * If you don't define a clarification prompt, at runtime Amazon Lex will return a 400 Bad Request exception in
         * three cases:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Follow-up prompt - When the user responds to a follow-up prompt but does not provide an intent. For example,
         * in response to a follow-up prompt that says "Would you like anything else today?" the user says "Yes." Amazon
         * Lex will return a 400 Bad Request exception because it does not have a clarification prompt to send to the
         * user to get an intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * Lambda function - When using a Lambda function, you return an <code>ElicitIntent</code> dialog type. Since
         * Amazon Lex does not have a clarification prompt to get an intent from the user, it returns a 400 Bad Request
         * exception.
         * </p>
         * </li>
         * <li>
         * <p>
         * PutSession operation - When using the <code>PutSession</code> operation, you send an
         * <code>ElicitIntent</code> dialog type. Since Amazon Lex does not have a clarification prompt to get an intent
         * from the user, it returns a 400 Bad Request exception.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clarificationPrompt
         *        When Amazon Lex doesn't understand the user's intent, it uses this message to get clarification. To
         *        specify how many times Amazon Lex should repeat the clarification prompt, use the
         *        <code>maxAttempts</code> field. If Amazon Lex still doesn't understand, it sends the message in the
         *        <code>abortStatement</code> field. </p>
         *        <p>
         *        When you create a clarification prompt, make sure that it suggests the correct response from the user.
         *        for example, for a bot that orders pizza and drinks, you might create this clarification prompt:
         *        "What would you like to do? You can say 'Order a pizza' or 'Order a drink.'"
         *        </p>
         *        <p>
         *        If you have defined a fallback intent, it will be invoked if the clarification prompt is repeated the
         *        number of times defined in the <code>maxAttempts</code> field. For more information, see <a
         *        href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html">
         *        AMAZON.FallbackIntent</a>.
         *        </p>
         *        <p>
         *        If you don't define a clarification prompt, at runtime Amazon Lex will return a 400 Bad Request
         *        exception in three cases:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Follow-up prompt - When the user responds to a follow-up prompt but does not provide an intent. For
         *        example, in response to a follow-up prompt that says "Would you like anything else today?" the user
         *        says "Yes." Amazon Lex will return a 400 Bad Request exception because it does not have a
         *        clarification prompt to send to the user to get an intent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Lambda function - When using a Lambda function, you return an <code>ElicitIntent</code> dialog type.
         *        Since Amazon Lex does not have a clarification prompt to get an intent from the user, it returns a 400
         *        Bad Request exception.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PutSession operation - When using the <code>PutSession</code> operation, you send an
         *        <code>ElicitIntent</code> dialog type. Since Amazon Lex does not have a clarification prompt to get an
         *        intent from the user, it returns a 400 Bad Request exception.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clarificationPrompt(Prompt clarificationPrompt);

        /**
         * <p>
         * When Amazon Lex doesn't understand the user's intent, it uses this message to get clarification. To specify
         * how many times Amazon Lex should repeat the clarification prompt, use the <code>maxAttempts</code> field. If
         * Amazon Lex still doesn't understand, it sends the message in the <code>abortStatement</code> field.
         * </p>
         * <p>
         * When you create a clarification prompt, make sure that it suggests the correct response from the user. for
         * example, for a bot that orders pizza and drinks, you might create this clarification prompt:
         * "What would you like to do? You can say 'Order a pizza' or 'Order a drink.'"
         * </p>
         * <p>
         * If you have defined a fallback intent, it will be invoked if the clarification prompt is repeated the number
         * of times defined in the <code>maxAttempts</code> field. For more information, see <a
         * href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html"> AMAZON.FallbackIntent</a>.
         * </p>
         * <p>
         * If you don't define a clarification prompt, at runtime Amazon Lex will return a 400 Bad Request exception in
         * three cases:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Follow-up prompt - When the user responds to a follow-up prompt but does not provide an intent. For example,
         * in response to a follow-up prompt that says "Would you like anything else today?" the user says "Yes." Amazon
         * Lex will return a 400 Bad Request exception because it does not have a clarification prompt to send to the
         * user to get an intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * Lambda function - When using a Lambda function, you return an <code>ElicitIntent</code> dialog type. Since
         * Amazon Lex does not have a clarification prompt to get an intent from the user, it returns a 400 Bad Request
         * exception.
         * </p>
         * </li>
         * <li>
         * <p>
         * PutSession operation - When using the <code>PutSession</code> operation, you send an
         * <code>ElicitIntent</code> dialog type. Since Amazon Lex does not have a clarification prompt to get an intent
         * from the user, it returns a 400 Bad Request exception.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link Prompt.Builder} avoiding the need to create one
         * manually via {@link Prompt#builder()}.
         *
         * When the {@link Consumer} completes, {@link Prompt.Builder#build()} is called immediately and its result is
         * passed to {@link #clarificationPrompt(Prompt)}.
         * 
         * @param clarificationPrompt
         *        a consumer that will call methods on {@link Prompt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clarificationPrompt(Prompt)
         */
        default Builder clarificationPrompt(Consumer<Prompt.Builder> clarificationPrompt) {
            return clarificationPrompt(Prompt.builder().applyMutation(clarificationPrompt).build());
        }

        /**
         * <p>
         * When Amazon Lex can't understand the user's input in context, it tries to elicit the information a few times.
         * After that, Amazon Lex sends the message defined in <code>abortStatement</code> to the user, and then aborts
         * the conversation. To set the number of retries, use the <code>valueElicitationPrompt</code> field for the
         * slot type.
         * </p>
         * <p>
         * For example, in a pizza ordering bot, Amazon Lex might ask a user "What type of crust would you like?" If the
         * user's response is not one of the expected responses (for example, "thin crust, "deep dish," etc.), Amazon
         * Lex tries to elicit a correct response a few more times.
         * </p>
         * <p>
         * For example, in a pizza ordering application, <code>OrderPizza</code> might be one of the intents. This
         * intent might require the <code>CrustType</code> slot. You specify the <code>valueElicitationPrompt</code>
         * field when you create the <code>CrustType</code> slot.
         * </p>
         * <p>
         * If you have defined a fallback intent the abort statement will not be sent to the user, the fallback intent
         * is used instead. For more information, see <a
         * href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html"> AMAZON.FallbackIntent</a>.
         * </p>
         * 
         * @param abortStatement
         *        When Amazon Lex can't understand the user's input in context, it tries to elicit the information a few
         *        times. After that, Amazon Lex sends the message defined in <code>abortStatement</code> to the user,
         *        and then aborts the conversation. To set the number of retries, use the
         *        <code>valueElicitationPrompt</code> field for the slot type. </p>
         *        <p>
         *        For example, in a pizza ordering bot, Amazon Lex might ask a user "What type of crust would you like?"
         *        If the user's response is not one of the expected responses (for example, "thin crust, "deep dish,"
         *        etc.), Amazon Lex tries to elicit a correct response a few more times.
         *        </p>
         *        <p>
         *        For example, in a pizza ordering application, <code>OrderPizza</code> might be one of the intents.
         *        This intent might require the <code>CrustType</code> slot. You specify the
         *        <code>valueElicitationPrompt</code> field when you create the <code>CrustType</code> slot.
         *        </p>
         *        <p>
         *        If you have defined a fallback intent the abort statement will not be sent to the user, the fallback
         *        intent is used instead. For more information, see <a
         *        href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html">
         *        AMAZON.FallbackIntent</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortStatement(Statement abortStatement);

        /**
         * <p>
         * When Amazon Lex can't understand the user's input in context, it tries to elicit the information a few times.
         * After that, Amazon Lex sends the message defined in <code>abortStatement</code> to the user, and then aborts
         * the conversation. To set the number of retries, use the <code>valueElicitationPrompt</code> field for the
         * slot type.
         * </p>
         * <p>
         * For example, in a pizza ordering bot, Amazon Lex might ask a user "What type of crust would you like?" If the
         * user's response is not one of the expected responses (for example, "thin crust, "deep dish," etc.), Amazon
         * Lex tries to elicit a correct response a few more times.
         * </p>
         * <p>
         * For example, in a pizza ordering application, <code>OrderPizza</code> might be one of the intents. This
         * intent might require the <code>CrustType</code> slot. You specify the <code>valueElicitationPrompt</code>
         * field when you create the <code>CrustType</code> slot.
         * </p>
         * <p>
         * If you have defined a fallback intent the abort statement will not be sent to the user, the fallback intent
         * is used instead. For more information, see <a
         * href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html"> AMAZON.FallbackIntent</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link Statement.Builder} avoiding the need to create
         * one manually via {@link Statement#builder()}.
         *
         * When the {@link Consumer} completes, {@link Statement.Builder#build()} is called immediately and its result
         * is passed to {@link #abortStatement(Statement)}.
         * 
         * @param abortStatement
         *        a consumer that will call methods on {@link Statement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abortStatement(Statement)
         */
        default Builder abortStatement(Consumer<Statement.Builder> abortStatement) {
            return abortStatement(Statement.builder().applyMutation(abortStatement).build());
        }

        /**
         * <p>
         * The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.
         * </p>
         * <p>
         * A user interaction session remains active for the amount of time specified. If no conversation occurs during
         * this time, the session expires and Amazon Lex deletes any data provided before the timeout.
         * </p>
         * <p>
         * For example, suppose that a user chooses the OrderPizza intent, but gets sidetracked halfway through placing
         * an order. If the user doesn't complete the order within the specified time, Amazon Lex discards the slot
         * information that it gathered, and the user must start over.
         * </p>
         * <p>
         * If you don't include the <code>idleSessionTTLInSeconds</code> element in a <code>PutBot</code> operation
         * request, Amazon Lex uses the default value. This is also true if the request replaces an existing bot.
         * </p>
         * <p>
         * The default is 300 seconds (5 minutes).
         * </p>
         * 
         * @param idleSessionTTLInSeconds
         *        The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.</p>
         *        <p>
         *        A user interaction session remains active for the amount of time specified. If no conversation occurs
         *        during this time, the session expires and Amazon Lex deletes any data provided before the timeout.
         *        </p>
         *        <p>
         *        For example, suppose that a user chooses the OrderPizza intent, but gets sidetracked halfway through
         *        placing an order. If the user doesn't complete the order within the specified time, Amazon Lex
         *        discards the slot information that it gathered, and the user must start over.
         *        </p>
         *        <p>
         *        If you don't include the <code>idleSessionTTLInSeconds</code> element in a <code>PutBot</code>
         *        operation request, Amazon Lex uses the default value. This is also true if the request replaces an
         *        existing bot.
         *        </p>
         *        <p>
         *        The default is 300 seconds (5 minutes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds);

        /**
         * <p>
         * The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The locale
         * configured for the voice must match the locale of the bot. For more information, see <a
         * href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Voices in Amazon Polly</a> in the <i>Amazon
         * Polly Developer Guide</i>.
         * </p>
         * 
         * @param voiceId
         *        The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The
         *        locale configured for the voice must match the locale of the bot. For more information, see <a
         *        href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Voices in Amazon Polly</a> in the
         *        <i>Amazon Polly Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceId(String voiceId);

        /**
         * <p>
         * Identifies a specific revision of the <code>$LATEST</code> version.
         * </p>
         * <p>
         * When you create a new bot, leave the <code>checksum</code> field blank. If you specify a checksum you get a
         * <code>BadRequestException</code> exception.
         * </p>
         * <p>
         * When you want to update a bot, set the <code>checksum</code> field to the checksum of the most recent
         * revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if
         * the checksum does not match the <code>$LATEST</code> version, you get a
         * <code>PreconditionFailedException</code> exception.
         * </p>
         * 
         * @param checksum
         *        Identifies a specific revision of the <code>$LATEST</code> version.</p>
         *        <p>
         *        When you create a new bot, leave the <code>checksum</code> field blank. If you specify a checksum you
         *        get a <code>BadRequestException</code> exception.
         *        </p>
         *        <p>
         *        When you want to update a bot, set the <code>checksum</code> field to the checksum of the most recent
         *        revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field,
         *        or if the checksum does not match the <code>$LATEST</code> version, you get a
         *        <code>PreconditionFailedException</code> exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * <p>
         * If you set the <code>processBehavior</code> element to <code>BUILD</code>, Amazon Lex builds the bot so that
         * it can be run. If you set the element to <code>SAVE</code> Amazon Lex saves the bot, but doesn't build it.
         * </p>
         * <p>
         * If you don't specify this value, the default value is <code>BUILD</code>.
         * </p>
         * 
         * @param processBehavior
         *        If you set the <code>processBehavior</code> element to <code>BUILD</code>, Amazon Lex builds the bot
         *        so that it can be run. If you set the element to <code>SAVE</code> Amazon Lex saves the bot, but
         *        doesn't build it. </p>
         *        <p>
         *        If you don't specify this value, the default value is <code>BUILD</code>.
         * @see ProcessBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessBehavior
         */
        Builder processBehavior(String processBehavior);

        /**
         * <p>
         * If you set the <code>processBehavior</code> element to <code>BUILD</code>, Amazon Lex builds the bot so that
         * it can be run. If you set the element to <code>SAVE</code> Amazon Lex saves the bot, but doesn't build it.
         * </p>
         * <p>
         * If you don't specify this value, the default value is <code>BUILD</code>.
         * </p>
         * 
         * @param processBehavior
         *        If you set the <code>processBehavior</code> element to <code>BUILD</code>, Amazon Lex builds the bot
         *        so that it can be run. If you set the element to <code>SAVE</code> Amazon Lex saves the bot, but
         *        doesn't build it. </p>
         *        <p>
         *        If you don't specify this value, the default value is <code>BUILD</code>.
         * @see ProcessBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessBehavior
         */
        Builder processBehavior(ProcessBehavior processBehavior);

        /**
         * <p>
         * Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the
         * bot.
         * </p>
         * <p>
         * The default is <code>en-US</code>.
         * </p>
         * 
         * @param locale
         *        Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale
         *        of the bot. </p>
         *        <p>
         *        The default is <code>en-US</code>.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(String locale);

        /**
         * <p>
         * Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the
         * bot.
         * </p>
         * <p>
         * The default is <code>en-US</code>.
         * </p>
         * 
         * @param locale
         *        Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale
         *        of the bot. </p>
         *        <p>
         *        The default is <code>en-US</code>.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(Locale locale);

        /**
         * <p>
         * For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use
         * of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole
         * or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by
         * specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying
         * <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b>
         * related to a website, program, or other application that is directed or targeted, in whole or in part, to
         * children under age 13 and subject to COPPA. By specifying <code>false</code> in the
         * <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website,
         * program, or other application that is directed or targeted, in whole or in part, to children under age 13 and
         * subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not
         * accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that
         * is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA.
         * </p>
         * <p>
         * If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in
         * part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For
         * information regarding the use of Amazon Lex in connection with websites, programs, or other applications that
         * are directed or targeted, in whole or in part, to children under age 13, see the <a
         * href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
         * </p>
         * 
         * @param childDirected
         *        For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether
         *        your use of Amazon Lex is related to a website, program, or other application that is directed or
         *        targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy
         *        Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the
         *        <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code>
         *        field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other
         *        application that is directed or targeted, in whole or in part, to children under age 13 and subject to
         *        COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your
         *        use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed
         *        or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a
         *        default value for the <code>childDirected</code> field that does not accurately reflect whether your
         *        use of Amazon Lex is related to a website, program, or other application that is directed or targeted,
         *        in whole or in part, to children under age 13 and subject to COPPA.</p>
         *        <p>
         *        If your use of Amazon Lex relates to a website, program, or other application that is directed in
         *        whole or in part, to children under age 13, you must obtain any required verifiable parental consent
         *        under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or
         *        other applications that are directed or targeted, in whole or in part, to children under age 13, see
         *        the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childDirected(Boolean childDirected);

        /**
         * <p>
         * When set to <code>true</code> user utterances are sent to Amazon Comprehend for sentiment analysis. If you
         * don't specify <code>detectSentiment</code>, the default is <code>false</code>.
         * </p>
         * 
         * @param detectSentiment
         *        When set to <code>true</code> user utterances are sent to Amazon Comprehend for sentiment analysis. If
         *        you don't specify <code>detectSentiment</code>, the default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectSentiment(Boolean detectSentiment);

        /**
         * <p>
         * When set to <code>true</code> a new numbered version of the bot is created. This is the same as calling the
         * <code>CreateBotVersion</code> operation. If you don't specify <code>createVersion</code>, the default is
         * <code>false</code>.
         * </p>
         * 
         * @param createVersion
         *        When set to <code>true</code> a new numbered version of the bot is created. This is the same as
         *        calling the <code>CreateBotVersion</code> operation. If you don't specify <code>createVersion</code>,
         *        the default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createVersion(Boolean createVersion);

        /**
         * <p>
         * A list of tags to add to the bot. You can only add tags when you create a bot, you can't use the
         * <code>PutBot</code> operation to update the tags on a bot. To update tags, use the <code>TagResource</code>
         * operation.
         * </p>
         * 
         * @param tags
         *        A list of tags to add to the bot. You can only add tags when you create a bot, you can't use the
         *        <code>PutBot</code> operation to update the tags on a bot. To update tags, use the
         *        <code>TagResource</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to add to the bot. You can only add tags when you create a bot, you can't use the
         * <code>PutBot</code> operation to update the tags on a bot. To update tags, use the <code>TagResource</code>
         * operation.
         * </p>
         * 
         * @param tags
         *        A list of tags to add to the bot. You can only add tags when you create a bot, you can't use the
         *        <code>PutBot</code> operation to update the tags on a bot. To update tags, use the
         *        <code>TagResource</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to add to the bot. You can only add tags when you create a bot, you can't use the
         * <code>PutBot</code> operation to update the tags on a bot. To update tags, use the <code>TagResource</code>
         * operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<Intent> intents = DefaultSdkAutoConstructList.getInstance();

        private Prompt clarificationPrompt;

        private Statement abortStatement;

        private Integer idleSessionTTLInSeconds;

        private String voiceId;

        private String checksum;

        private String processBehavior;

        private String locale;

        private Boolean childDirected;

        private Boolean detectSentiment;

        private Boolean createVersion;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutBotRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            intents(model.intents);
            clarificationPrompt(model.clarificationPrompt);
            abortStatement(model.abortStatement);
            idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            voiceId(model.voiceId);
            checksum(model.checksum);
            processBehavior(model.processBehavior);
            locale(model.locale);
            childDirected(model.childDirected);
            detectSentiment(model.detectSentiment);
            createVersion(model.createVersion);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Intent.Builder> getIntents() {
            return intents != null ? intents.stream().map(Intent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder intents(Collection<Intent> intents) {
            this.intents = IntentListCopier.copy(intents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(Intent... intents) {
            intents(Arrays.asList(intents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(Consumer<Intent.Builder>... intents) {
            intents(Stream.of(intents).map(c -> Intent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIntents(Collection<Intent.BuilderImpl> intents) {
            this.intents = IntentListCopier.copyFromBuilder(intents);
        }

        public final Prompt.Builder getClarificationPrompt() {
            return clarificationPrompt != null ? clarificationPrompt.toBuilder() : null;
        }

        @Override
        public final Builder clarificationPrompt(Prompt clarificationPrompt) {
            this.clarificationPrompt = clarificationPrompt;
            return this;
        }

        public final void setClarificationPrompt(Prompt.BuilderImpl clarificationPrompt) {
            this.clarificationPrompt = clarificationPrompt != null ? clarificationPrompt.build() : null;
        }

        public final Statement.Builder getAbortStatement() {
            return abortStatement != null ? abortStatement.toBuilder() : null;
        }

        @Override
        public final Builder abortStatement(Statement abortStatement) {
            this.abortStatement = abortStatement;
            return this;
        }

        public final void setAbortStatement(Statement.BuilderImpl abortStatement) {
            this.abortStatement = abortStatement != null ? abortStatement.build() : null;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        public final String getVoiceId() {
            return voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final String getProcessBehavior() {
            return processBehavior;
        }

        @Override
        public final Builder processBehavior(String processBehavior) {
            this.processBehavior = processBehavior;
            return this;
        }

        @Override
        public final Builder processBehavior(ProcessBehavior processBehavior) {
            this.processBehavior(processBehavior == null ? null : processBehavior.toString());
            return this;
        }

        public final void setProcessBehavior(String processBehavior) {
            this.processBehavior = processBehavior;
        }

        public final String getLocale() {
            return locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final Boolean getChildDirected() {
            return childDirected;
        }

        @Override
        public final Builder childDirected(Boolean childDirected) {
            this.childDirected = childDirected;
            return this;
        }

        public final void setChildDirected(Boolean childDirected) {
            this.childDirected = childDirected;
        }

        public final Boolean getDetectSentiment() {
            return detectSentiment;
        }

        @Override
        public final Builder detectSentiment(Boolean detectSentiment) {
            this.detectSentiment = detectSentiment;
            return this;
        }

        public final void setDetectSentiment(Boolean detectSentiment) {
            this.detectSentiment = detectSentiment;
        }

        public final Boolean getCreateVersion() {
            return createVersion;
        }

        @Override
        public final Builder createVersion(Boolean createVersion) {
            this.createVersion = createVersion;
            return this;
        }

        public final void setCreateVersion(Boolean createVersion) {
            this.createVersion = createVersion;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutBotRequest build() {
            return new PutBotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
