/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OperationAction {
    START("START"),
    SUCCEED("SUCCEED"),
    FAIL("FAIL"),
    RETRY("RETRY"),
    CANCEL("CANCEL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OperationAction> VALUE_MAP;
    private final String value;

    private OperationAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperationAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OperationAction> knownValues() {
        EnumSet<OperationAction> knownValues = EnumSet.allOf(OperationAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OperationAction.class, OperationAction::toString);
    }
}

