/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.GetDurableExecutionStateRequest;
import software.amazon.awssdk.services.lambda.model.GetDurableExecutionStateResponse;
import software.amazon.awssdk.services.lambda.model.Operation;

public class GetDurableExecutionStateIterable
implements SdkIterable<GetDurableExecutionStateResponse> {
    private final LambdaClient client;
    private final GetDurableExecutionStateRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetDurableExecutionStateIterable(LambdaClient client, GetDurableExecutionStateRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetDurableExecutionStateResponseFetcher();
    }

    public Iterator<GetDurableExecutionStateResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Operation> operations() {
        Function<GetDurableExecutionStateResponse, Iterator> getIterator = response -> {
            if (response != null && response.operations() != null) {
                return response.operations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetDurableExecutionStateResponseFetcher
    implements SyncPageFetcher<GetDurableExecutionStateResponse> {
        private GetDurableExecutionStateResponseFetcher() {
        }

        public boolean hasNextPage(GetDurableExecutionStateResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public GetDurableExecutionStateResponse nextPage(GetDurableExecutionStateResponse previousPage) {
            if (previousPage == null) {
                return GetDurableExecutionStateIterable.this.client.getDurableExecutionState(GetDurableExecutionStateIterable.this.firstRequest);
            }
            return GetDurableExecutionStateIterable.this.client.getDurableExecutionState((GetDurableExecutionStateRequest)((Object)GetDurableExecutionStateIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

