/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * <fullname>Lambda</fullname>
 * <p>
 * <b>Overview</b>
 * </p>
 * <p>
 * Lambda is a compute service that lets you run code without provisioning or managing servers. Lambda runs your code on
 * a high-availability compute infrastructure and performs all of the administration of the compute resources, including
 * server and operating system maintenance, capacity provisioning and automatic scaling, code monitoring and logging.
 * With Lambda, you can run code for virtually any type of application or backend service. For more information about
 * the Lambda service, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/welcome.html">What is Lambda</a> in the
 * <b>Lambda Developer Guide</b>.
 * </p>
 * <p>
 * The <i>Lambda API Reference</i> provides information about each of the API methods, including details about the
 * parameters in each API request and response.
 * </p>
 * <p/>
 * <p>
 * You can use Software Development Kits (SDKs), Integrated Development Environment (IDE) Toolkits, and command line
 * tools to access the API. For installation instructions, see <a href="http://aws.amazon.com/tools/">Tools for Amazon
 * Web Services</a>.
 * </p>
 * <p>
 * For a list of Region-specific endpoints that Lambda supports, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/lambda-service.html">Lambda endpoints and quotas </a> in the
 * <i>Amazon Web Services General Reference.</i>.
 * </p>
 * <p>
 * When making the API calls, you will need to authenticate your request by providing a signature. Lambda supports
 * signature version 4. For more information, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 signing process</a>
 * in the <i>Amazon Web Services General Reference.</i>.
 * </p>
 * <p>
 * <b>CA certificates</b>
 * </p>
 * <p>
 * Because Amazon Web Services SDKs use the CA certificates from your computer, changes to the certificates on the
 * Amazon Web Services servers can cause connection failures when you attempt to use an SDK. You can prevent these
 * failures by keeping your computer's CA certificates and operating system up-to-date. If you encounter this issue in a
 * corporate environment and do not manage your own computer, you might need to ask an administrator to assist with the
 * update process. The following list shows minimum operating system and Java versions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Microsoft Windows versions that have updates from January 2005 or later installed contain at least one of the
 * required CAs in their trust list.
 * </p>
 * </li>
 * <li>
 * <p>
 * Mac OS X 10.4 with Java for Mac OS X 10.4 Release 5 (February 2007), Mac OS X 10.5 (October 2007), and later versions
 * contain at least one of the required CAs in their trust list.
 * </p>
 * </li>
 * <li>
 * <p>
 * Red Hat Enterprise Linux 5 (March 2007), 6, and 7 and CentOS 5, 6, and 7 all contain at least one of the required CAs
 * in their default trusted CA list.
 * </p>
 * </li>
 * <li>
 * <p>
 * Java 1.4.2_12 (May 2006), 5 Update 2 (March 2005), and all later versions, including Java 6 (December 2006), 7, and
 * 8, contain at least one of the required CAs in their default trusted CA list.
 * </p>
 * </li>
 * </ul>
 * <p>
 * When accessing the Lambda management console or Lambda API endpoints, whether through browsers or programmatically,
 * you will need to ensure your client machines support any of the following CAs:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Amazon Root CA 1
 * </p>
 * </li>
 * <li>
 * <p>
 * Starfield Services Root Certificate Authority - G2
 * </p>
 * </li>
 * <li>
 * <p>
 * Starfield Class 2 Certification Authority
 * </p>
 * </li>
 * </ul>
 * <p>
 * Root certificates from the first two authorities are available from <a
 * href="https://www.amazontrust.com/repository/">Amazon trust services</a>, but keeping your computer up-to-date is the
 * more straightforward solution. To learn more about ACM-provided certificates, see <a
 * href="http://aws.amazon.com/certificate-manager/faqs/#certificates">Amazon Web Services Certificate Manager FAQs.</a>
 * </p>
 * </p>
 *
 * <h2>Code Examples</h2>
 * <p>
 * For code examples demonstrating how to use this service with the AWS SDK for Java v2, see:
 * </p>
 * <h3>Getting Started</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_lambda_Hello_section.html"
 * target="_top">Hello Lambda</a></li>
 * </ul>
 * <h3>Basics</h3>
 * <ul>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_lambda_Scenario_GettingStartedFunctions_section.html"
 * target="_top">Learn the basics of Lambda with an AWS SDK</a></li>
 * </ul>
 * <h3>API Actions</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_lambda_CreateFunction_section.html"
 * target="_top">Use CreateFunction</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_lambda_DeleteFunction_section.html"
 * target="_top">Use DeleteFunction</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_lambda_Invoke_section.html"
 * target="_top">Use Invoke</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_lambda_GetFunction_section.html"
 * target="_top">Use GetFunction</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_lambda_UpdateFunctionCode_section.html"
 * target="_top">Use UpdateFunctionCode</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_lambda_UpdateFunctionConfiguration_section.html"
 * target="_top">Use UpdateFunctionConfiguration</a></li>
 * </ul>
 * <h3>Scenarios</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_cross_Neptune_Query_section.html"
 * target="_top">Use the Amazon Neptune API to develop a Lambda function that queries graph data</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_cross_FSA_section.html"
 * target="_top">Create an application that analyzes customer feedback and synthesizes audio</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_cross_PAM_section.html"
 * target="_top">Create a photo asset management application that lets users manage photos using labels</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_cross_LambdaAPIGateway_section.html"
 * target="_top">Use API Gateway to invoke a Lambda function</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_cross_LambdaScheduledEvents_section.html"
 * target="_top">Use scheduled events to invoke a Lambda function</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_cross_ServerlessWorkflows_section.html"
 * target="_top">Use Step Functions to invoke Lambda functions</a></li>
 * </ul>
 * <h3>Serverless Examples</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_serverless_S3_Lambda_section.html"
 * target="_top">Invoke a Lambda function from an Amazon S3 trigger</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_serverless_SNS_Lambda_section.html"
 * target="_top">Invoke a Lambda function from an Amazon SNS trigger</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_serverless_SQS_Lambda_section.html"
 * target="_top">Invoke a Lambda function from an Amazon SQS trigger</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_serverless_SQS_Lambda_batch_item_failures_section.html"
 * target="_top">Reporting batch item failures for Lambda functions with an Amazon SQS trigger</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_serverless_Kinesis_Lambda_section.html"
 * target="_top">Invoke a Lambda function from a Kinesis trigger</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_serverless_Kinesis_Lambda_batch_item_failures_section.html"
 * target="_top">Reporting batch item failures for Lambda functions with a Kinesis trigger</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_serverless_DynamoDB_Lambda_section.html"
 * target="_top">Invoke a Lambda function from a DynamoDB trigger</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_serverless_DynamoDB_Lambda_batch_item_failures_section.html"
 * target="_top">Reporting batch item failures for Lambda functions with a DynamoDB trigger</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_serverless_DocumentDB_Lambda_section.html"
 * target="_top">Invoke a Lambda function from a Amazon DocumentDB trigger</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_serverless_connect_RDS_Lambda_section.html"
 * target="_top">Connecting to an Amazon RDS database in a Lambda function</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_serverless_MSK_Lambda_section.html"
 * target="_top">Invoke a Lambda function from an Amazon MSK trigger</a></li>
 * </ul>
 * <h3>TributaryLite</h3>
 * <ul>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/lambda_example_tributary-lite_serverless-application_section.html"
 * target="_top">Build and test a serverless application</a></li>
 * </ul>
 */
package software.amazon.awssdk.services.lambda;