/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A scaling policy for the capacity provider that automatically adjusts capacity to maintain a target value for a
 * specific metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetTrackingScalingPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetTrackingScalingPolicy.Builder, TargetTrackingScalingPolicy> {
    private static final SdkField<String> PREDEFINED_METRIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PredefinedMetricType").getter(getter(TargetTrackingScalingPolicy::predefinedMetricTypeAsString))
            .setter(setter(Builder::predefinedMetricType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedMetricType").build())
            .build();

    private static final SdkField<Double> TARGET_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TargetValue").getter(getter(TargetTrackingScalingPolicy::targetValue))
            .setter(setter(Builder::targetValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDEFINED_METRIC_TYPE_FIELD,
            TARGET_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String predefinedMetricType;

    private final Double targetValue;

    private TargetTrackingScalingPolicy(BuilderImpl builder) {
        this.predefinedMetricType = builder.predefinedMetricType;
        this.targetValue = builder.targetValue;
    }

    /**
     * <p>
     * The predefined metric type to track for scaling decisions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #predefinedMetricType} will return {@link CapacityProviderPredefinedMetricType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #predefinedMetricTypeAsString}.
     * </p>
     * 
     * @return The predefined metric type to track for scaling decisions.
     * @see CapacityProviderPredefinedMetricType
     */
    public final CapacityProviderPredefinedMetricType predefinedMetricType() {
        return CapacityProviderPredefinedMetricType.fromValue(predefinedMetricType);
    }

    /**
     * <p>
     * The predefined metric type to track for scaling decisions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #predefinedMetricType} will return {@link CapacityProviderPredefinedMetricType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #predefinedMetricTypeAsString}.
     * </p>
     * 
     * @return The predefined metric type to track for scaling decisions.
     * @see CapacityProviderPredefinedMetricType
     */
    public final String predefinedMetricTypeAsString() {
        return predefinedMetricType;
    }

    /**
     * <p>
     * The target value for the metric that the scaling policy attempts to maintain through scaling actions.
     * </p>
     * 
     * @return The target value for the metric that the scaling policy attempts to maintain through scaling actions.
     */
    public final Double targetValue() {
        return targetValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(predefinedMetricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTrackingScalingPolicy)) {
            return false;
        }
        TargetTrackingScalingPolicy other = (TargetTrackingScalingPolicy) obj;
        return Objects.equals(predefinedMetricTypeAsString(), other.predefinedMetricTypeAsString())
                && Objects.equals(targetValue(), other.targetValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetTrackingScalingPolicy").add("PredefinedMetricType", predefinedMetricTypeAsString())
                .add("TargetValue", targetValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredefinedMetricType":
            return Optional.ofNullable(clazz.cast(predefinedMetricTypeAsString()));
        case "TargetValue":
            return Optional.ofNullable(clazz.cast(targetValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PredefinedMetricType", PREDEFINED_METRIC_TYPE_FIELD);
        map.put("TargetValue", TARGET_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetTrackingScalingPolicy, T> g) {
        return obj -> g.apply((TargetTrackingScalingPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetTrackingScalingPolicy> {
        /**
         * <p>
         * The predefined metric type to track for scaling decisions.
         * </p>
         * 
         * @param predefinedMetricType
         *        The predefined metric type to track for scaling decisions.
         * @see CapacityProviderPredefinedMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityProviderPredefinedMetricType
         */
        Builder predefinedMetricType(String predefinedMetricType);

        /**
         * <p>
         * The predefined metric type to track for scaling decisions.
         * </p>
         * 
         * @param predefinedMetricType
         *        The predefined metric type to track for scaling decisions.
         * @see CapacityProviderPredefinedMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityProviderPredefinedMetricType
         */
        Builder predefinedMetricType(CapacityProviderPredefinedMetricType predefinedMetricType);

        /**
         * <p>
         * The target value for the metric that the scaling policy attempts to maintain through scaling actions.
         * </p>
         * 
         * @param targetValue
         *        The target value for the metric that the scaling policy attempts to maintain through scaling actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetValue(Double targetValue);
    }

    static final class BuilderImpl implements Builder {
        private String predefinedMetricType;

        private Double targetValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTrackingScalingPolicy model) {
            predefinedMetricType(model.predefinedMetricType);
            targetValue(model.targetValue);
        }

        public final String getPredefinedMetricType() {
            return predefinedMetricType;
        }

        public final void setPredefinedMetricType(String predefinedMetricType) {
            this.predefinedMetricType = predefinedMetricType;
        }

        @Override
        public final Builder predefinedMetricType(String predefinedMetricType) {
            this.predefinedMetricType = predefinedMetricType;
            return this;
        }

        @Override
        public final Builder predefinedMetricType(CapacityProviderPredefinedMetricType predefinedMetricType) {
            this.predefinedMetricType(predefinedMetricType == null ? null : predefinedMetricType.toString());
            return this;
        }

        public final Double getTargetValue() {
            return targetValue;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        @Override
        public TargetTrackingScalingPolicy build() {
            return new TargetTrackingScalingPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
