/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutFunctionScalingConfigRequest extends LambdaRequest implements
        ToCopyableBuilder<PutFunctionScalingConfigRequest.Builder, PutFunctionScalingConfigRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(PutFunctionScalingConfigRequest::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()).build();

    private static final SdkField<String> QUALIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Qualifier").getter(getter(PutFunctionScalingConfigRequest::qualifier))
            .setter(setter(Builder::qualifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Qualifier").build()).build();

    private static final SdkField<FunctionScalingConfig> FUNCTION_SCALING_CONFIG_FIELD = SdkField
            .<FunctionScalingConfig> builder(MarshallingType.SDK_POJO).memberName("FunctionScalingConfig")
            .getter(getter(PutFunctionScalingConfigRequest::functionScalingConfig))
            .setter(setter(Builder::functionScalingConfig)).constructor(FunctionScalingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionScalingConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            QUALIFIER_FIELD, FUNCTION_SCALING_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String functionName;

    private final String qualifier;

    private final FunctionScalingConfig functionScalingConfig;

    private PutFunctionScalingConfigRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.qualifier = builder.qualifier;
        this.functionScalingConfig = builder.functionScalingConfig;
    }

    /**
     * <p>
     * The name or ARN of the Lambda function.
     * </p>
     * 
     * @return The name or ARN of the Lambda function.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * Specify a version or alias to set the scaling configuration for a published version of the function.
     * </p>
     * 
     * @return Specify a version or alias to set the scaling configuration for a published version of the function.
     */
    public final String qualifier() {
        return qualifier;
    }

    /**
     * <p>
     * The scaling configuration to apply to the function, including minimum and maximum execution environment limits.
     * </p>
     * 
     * @return The scaling configuration to apply to the function, including minimum and maximum execution environment
     *         limits.
     */
    public final FunctionScalingConfig functionScalingConfig() {
        return functionScalingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(functionScalingConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFunctionScalingConfigRequest)) {
            return false;
        }
        PutFunctionScalingConfigRequest other = (PutFunctionScalingConfigRequest) obj;
        return Objects.equals(functionName(), other.functionName()) && Objects.equals(qualifier(), other.qualifier())
                && Objects.equals(functionScalingConfig(), other.functionScalingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutFunctionScalingConfigRequest").add("FunctionName", functionName())
                .add("Qualifier", qualifier()).add("FunctionScalingConfig", functionScalingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "Qualifier":
            return Optional.ofNullable(clazz.cast(qualifier()));
        case "FunctionScalingConfig":
            return Optional.ofNullable(clazz.cast(functionScalingConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FunctionName", FUNCTION_NAME_FIELD);
        map.put("Qualifier", QUALIFIER_FIELD);
        map.put("FunctionScalingConfig", FUNCTION_SCALING_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutFunctionScalingConfigRequest, T> g) {
        return obj -> g.apply((PutFunctionScalingConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutFunctionScalingConfigRequest> {
        /**
         * <p>
         * The name or ARN of the Lambda function.
         * </p>
         * 
         * @param functionName
         *        The name or ARN of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * Specify a version or alias to set the scaling configuration for a published version of the function.
         * </p>
         * 
         * @param qualifier
         *        Specify a version or alias to set the scaling configuration for a published version of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualifier(String qualifier);

        /**
         * <p>
         * The scaling configuration to apply to the function, including minimum and maximum execution environment
         * limits.
         * </p>
         * 
         * @param functionScalingConfig
         *        The scaling configuration to apply to the function, including minimum and maximum execution
         *        environment limits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionScalingConfig(FunctionScalingConfig functionScalingConfig);

        /**
         * <p>
         * The scaling configuration to apply to the function, including minimum and maximum execution environment
         * limits.
         * </p>
         * This is a convenience method that creates an instance of the {@link FunctionScalingConfig.Builder} avoiding
         * the need to create one manually via {@link FunctionScalingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunctionScalingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #functionScalingConfig(FunctionScalingConfig)}.
         * 
         * @param functionScalingConfig
         *        a consumer that will call methods on {@link FunctionScalingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionScalingConfig(FunctionScalingConfig)
         */
        default Builder functionScalingConfig(Consumer<FunctionScalingConfig.Builder> functionScalingConfig) {
            return functionScalingConfig(FunctionScalingConfig.builder().applyMutation(functionScalingConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String functionName;

        private String qualifier;

        private FunctionScalingConfig functionScalingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFunctionScalingConfigRequest model) {
            super(model);
            functionName(model.functionName);
            qualifier(model.qualifier);
            functionScalingConfig(model.functionScalingConfig);
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getQualifier() {
            return qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final FunctionScalingConfig.Builder getFunctionScalingConfig() {
            return functionScalingConfig != null ? functionScalingConfig.toBuilder() : null;
        }

        public final void setFunctionScalingConfig(FunctionScalingConfig.BuilderImpl functionScalingConfig) {
            this.functionScalingConfig = functionScalingConfig != null ? functionScalingConfig.build() : null;
        }

        @Override
        public final Builder functionScalingConfig(FunctionScalingConfig functionScalingConfig) {
            this.functionScalingConfig = functionScalingConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutFunctionScalingConfigRequest build() {
            return new PutFunctionScalingConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
