/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFunctionVersionsByCapacityProviderResponse extends LambdaResponse implements
        ToCopyableBuilder<ListFunctionVersionsByCapacityProviderResponse.Builder, ListFunctionVersionsByCapacityProviderResponse> {
    private static final SdkField<String> CAPACITY_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CapacityProviderArn")
            .getter(getter(ListFunctionVersionsByCapacityProviderResponse::capacityProviderArn))
            .setter(setter(Builder::capacityProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviderArn").build())
            .build();

    private static final SdkField<List<FunctionVersionsByCapacityProviderListItem>> FUNCTION_VERSIONS_FIELD = SdkField
            .<List<FunctionVersionsByCapacityProviderListItem>> builder(MarshallingType.LIST)
            .memberName("FunctionVersions")
            .getter(getter(ListFunctionVersionsByCapacityProviderResponse::functionVersions))
            .setter(setter(Builder::functionVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FunctionVersionsByCapacityProviderListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(FunctionVersionsByCapacityProviderListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListFunctionVersionsByCapacityProviderResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDER_ARN_FIELD,
            FUNCTION_VERSIONS_FIELD, NEXT_MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String capacityProviderArn;

    private final List<FunctionVersionsByCapacityProviderListItem> functionVersions;

    private final String nextMarker;

    private ListFunctionVersionsByCapacityProviderResponse(BuilderImpl builder) {
        super(builder);
        this.capacityProviderArn = builder.capacityProviderArn;
        this.functionVersions = builder.functionVersions;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the capacity provider.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the capacity provider.
     */
    public final String capacityProviderArn() {
        return capacityProviderArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the FunctionVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFunctionVersions() {
        return functionVersions != null && !(functionVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of function versions that use the specified capacity provider.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctionVersions} method.
     * </p>
     * 
     * @return A list of function versions that use the specified capacity provider.
     */
    public final List<FunctionVersionsByCapacityProviderListItem> functionVersions() {
        return functionVersions;
    }

    /**
     * <p>
     * The pagination token that's included if more results are available.
     * </p>
     * 
     * @return The pagination token that's included if more results are available.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctionVersions() ? functionVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionVersionsByCapacityProviderResponse)) {
            return false;
        }
        ListFunctionVersionsByCapacityProviderResponse other = (ListFunctionVersionsByCapacityProviderResponse) obj;
        return Objects.equals(capacityProviderArn(), other.capacityProviderArn())
                && hasFunctionVersions() == other.hasFunctionVersions()
                && Objects.equals(functionVersions(), other.functionVersions())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFunctionVersionsByCapacityProviderResponse")
                .add("CapacityProviderArn", capacityProviderArn())
                .add("FunctionVersions", hasFunctionVersions() ? functionVersions() : null).add("NextMarker", nextMarker())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityProviderArn":
            return Optional.ofNullable(clazz.cast(capacityProviderArn()));
        case "FunctionVersions":
            return Optional.ofNullable(clazz.cast(functionVersions()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityProviderArn", CAPACITY_PROVIDER_ARN_FIELD);
        map.put("FunctionVersions", FUNCTION_VERSIONS_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFunctionVersionsByCapacityProviderResponse, T> g) {
        return obj -> g.apply((ListFunctionVersionsByCapacityProviderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFunctionVersionsByCapacityProviderResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the capacity provider.
         * </p>
         * 
         * @param capacityProviderArn
         *        The Amazon Resource Name (ARN) of the capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderArn(String capacityProviderArn);

        /**
         * <p>
         * A list of function versions that use the specified capacity provider.
         * </p>
         * 
         * @param functionVersions
         *        A list of function versions that use the specified capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionVersions(Collection<FunctionVersionsByCapacityProviderListItem> functionVersions);

        /**
         * <p>
         * A list of function versions that use the specified capacity provider.
         * </p>
         * 
         * @param functionVersions
         *        A list of function versions that use the specified capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionVersions(FunctionVersionsByCapacityProviderListItem... functionVersions);

        /**
         * <p>
         * A list of function versions that use the specified capacity provider.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lambda.model.FunctionVersionsByCapacityProviderListItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.lambda.model.FunctionVersionsByCapacityProviderListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lambda.model.FunctionVersionsByCapacityProviderListItem.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #functionVersions(List<FunctionVersionsByCapacityProviderListItem>)}.
         * 
         * @param functionVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lambda.model.FunctionVersionsByCapacityProviderListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionVersions(java.util.Collection<FunctionVersionsByCapacityProviderListItem>)
         */
        Builder functionVersions(Consumer<FunctionVersionsByCapacityProviderListItem.Builder>... functionVersions);

        /**
         * <p>
         * The pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextMarker
         *        The pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String capacityProviderArn;

        private List<FunctionVersionsByCapacityProviderListItem> functionVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFunctionVersionsByCapacityProviderResponse model) {
            super(model);
            capacityProviderArn(model.capacityProviderArn);
            functionVersions(model.functionVersions);
            nextMarker(model.nextMarker);
        }

        public final String getCapacityProviderArn() {
            return capacityProviderArn;
        }

        public final void setCapacityProviderArn(String capacityProviderArn) {
            this.capacityProviderArn = capacityProviderArn;
        }

        @Override
        public final Builder capacityProviderArn(String capacityProviderArn) {
            this.capacityProviderArn = capacityProviderArn;
            return this;
        }

        public final List<FunctionVersionsByCapacityProviderListItem.Builder> getFunctionVersions() {
            List<FunctionVersionsByCapacityProviderListItem.Builder> result = FunctionVersionsByCapacityProviderListCopier
                    .copyToBuilder(this.functionVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFunctionVersions(Collection<FunctionVersionsByCapacityProviderListItem.BuilderImpl> functionVersions) {
            this.functionVersions = FunctionVersionsByCapacityProviderListCopier.copyFromBuilder(functionVersions);
        }

        @Override
        public final Builder functionVersions(Collection<FunctionVersionsByCapacityProviderListItem> functionVersions) {
            this.functionVersions = FunctionVersionsByCapacityProviderListCopier.copy(functionVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionVersions(FunctionVersionsByCapacityProviderListItem... functionVersions) {
            functionVersions(Arrays.asList(functionVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionVersions(Consumer<FunctionVersionsByCapacityProviderListItem.Builder>... functionVersions) {
            functionVersions(Stream.of(functionVersions)
                    .map(c -> FunctionVersionsByCapacityProviderListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListFunctionVersionsByCapacityProviderResponse build() {
            return new ListFunctionVersionsByCapacityProviderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
