/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response from the GetDurableExecution operation, containing detailed information about the durable execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDurableExecutionResponse extends LambdaResponse implements
        ToCopyableBuilder<GetDurableExecutionResponse.Builder, GetDurableExecutionResponse> {
    private static final SdkField<String> DURABLE_EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DurableExecutionArn").getter(getter(GetDurableExecutionResponse::durableExecutionArn))
            .setter(setter(Builder::durableExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurableExecutionArn").build())
            .build();

    private static final SdkField<String> DURABLE_EXECUTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DurableExecutionName").getter(getter(GetDurableExecutionResponse::durableExecutionName))
            .setter(setter(Builder::durableExecutionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurableExecutionName").build())
            .build();

    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionArn").getter(getter(GetDurableExecutionResponse::functionArn))
            .setter(setter(Builder::functionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()).build();

    private static final SdkField<String> INPUT_PAYLOAD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputPayload").getter(getter(GetDurableExecutionResponse::inputPayload))
            .setter(setter(Builder::inputPayload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputPayload").build()).build();

    private static final SdkField<String> RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Result")
            .getter(getter(GetDurableExecutionResponse::result)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()).build();

    private static final SdkField<ErrorObject> ERROR_FIELD = SdkField.<ErrorObject> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(GetDurableExecutionResponse::error)).setter(setter(Builder::error))
            .constructor(ErrorObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTimestamp").getter(getter(GetDurableExecutionResponse::startTimestamp))
            .setter(setter(Builder::startTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetDurableExecutionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTimestamp").getter(getter(GetDurableExecutionResponse::endTimestamp))
            .setter(setter(Builder::endTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestamp").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(GetDurableExecutionResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<TraceHeader> TRACE_HEADER_FIELD = SdkField.<TraceHeader> builder(MarshallingType.SDK_POJO)
            .memberName("TraceHeader").getter(getter(GetDurableExecutionResponse::traceHeader))
            .setter(setter(Builder::traceHeader)).constructor(TraceHeader::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceHeader").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURABLE_EXECUTION_ARN_FIELD,
            DURABLE_EXECUTION_NAME_FIELD, FUNCTION_ARN_FIELD, INPUT_PAYLOAD_FIELD, RESULT_FIELD, ERROR_FIELD,
            START_TIMESTAMP_FIELD, STATUS_FIELD, END_TIMESTAMP_FIELD, VERSION_FIELD, TRACE_HEADER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String durableExecutionArn;

    private final String durableExecutionName;

    private final String functionArn;

    private final String inputPayload;

    private final String result;

    private final ErrorObject error;

    private final Instant startTimestamp;

    private final String status;

    private final Instant endTimestamp;

    private final String version;

    private final TraceHeader traceHeader;

    private GetDurableExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.durableExecutionArn = builder.durableExecutionArn;
        this.durableExecutionName = builder.durableExecutionName;
        this.functionArn = builder.functionArn;
        this.inputPayload = builder.inputPayload;
        this.result = builder.result;
        this.error = builder.error;
        this.startTimestamp = builder.startTimestamp;
        this.status = builder.status;
        this.endTimestamp = builder.endTimestamp;
        this.version = builder.version;
        this.traceHeader = builder.traceHeader;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the durable execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the durable execution.
     */
    public final String durableExecutionArn() {
        return durableExecutionArn;
    }

    /**
     * <p>
     * The name of the durable execution. This is either the name you provided when invoking the function, or a
     * system-generated unique identifier if no name was provided.
     * </p>
     * 
     * @return The name of the durable execution. This is either the name you provided when invoking the function, or a
     *         system-generated unique identifier if no name was provided.
     */
    public final String durableExecutionName() {
        return durableExecutionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda function that was invoked to start this durable execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda function that was invoked to start this durable execution.
     */
    public final String functionArn() {
        return functionArn;
    }

    /**
     * <p>
     * The JSON input payload that was provided when the durable execution was started. For asynchronous invocations,
     * this is limited to 256 KB. For synchronous invocations, this can be up to 6 MB.
     * </p>
     * 
     * @return The JSON input payload that was provided when the durable execution was started. For asynchronous
     *         invocations, this is limited to 256 KB. For synchronous invocations, this can be up to 6 MB.
     */
    public final String inputPayload() {
        return inputPayload;
    }

    /**
     * <p>
     * The JSON result returned by the durable execution if it completed successfully. This field is only present when
     * the execution status is <code>SUCCEEDED</code>. The result is limited to 256 KB.
     * </p>
     * 
     * @return The JSON result returned by the durable execution if it completed successfully. This field is only
     *         present when the execution status is <code>SUCCEEDED</code>. The result is limited to 256 KB.
     */
    public final String result() {
        return result;
    }

    /**
     * <p>
     * Error information if the durable execution failed. This field is only present when the execution status is
     * <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>STOPPED</code>. The combined size of all error fields is
     * limited to 256 KB.
     * </p>
     * 
     * @return Error information if the durable execution failed. This field is only present when the execution status
     *         is <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>STOPPED</code>. The combined size of all error
     *         fields is limited to 256 KB.
     */
    public final ErrorObject error() {
        return error;
    }

    /**
     * <p>
     * The date and time when the durable execution started, in Unix timestamp format.
     * </p>
     * 
     * @return The date and time when the durable execution started, in Unix timestamp format.
     */
    public final Instant startTimestamp() {
        return startTimestamp;
    }

    /**
     * <p>
     * The current status of the durable execution. Valid values are <code>RUNNING</code>, <code>SUCCEEDED</code>,
     * <code>FAILED</code>, <code>TIMED_OUT</code>, and <code>STOPPED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the durable execution. Valid values are <code>RUNNING</code>,
     *         <code>SUCCEEDED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, and <code>STOPPED</code>.
     * @see ExecutionStatus
     */
    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the durable execution. Valid values are <code>RUNNING</code>, <code>SUCCEEDED</code>,
     * <code>FAILED</code>, <code>TIMED_OUT</code>, and <code>STOPPED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the durable execution. Valid values are <code>RUNNING</code>,
     *         <code>SUCCEEDED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, and <code>STOPPED</code>.
     * @see ExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time when the durable execution ended, in Unix timestamp format. This field is only present if the
     * execution has completed (status is <code>SUCCEEDED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or
     * <code>STOPPED</code>).
     * </p>
     * 
     * @return The date and time when the durable execution ended, in Unix timestamp format. This field is only present
     *         if the execution has completed (status is <code>SUCCEEDED</code>, <code>FAILED</code>,
     *         <code>TIMED_OUT</code>, or <code>STOPPED</code>).
     */
    public final Instant endTimestamp() {
        return endTimestamp;
    }

    /**
     * <p>
     * The version of the Lambda function that was invoked for this durable execution. This ensures that all replays
     * during the execution use the same function version.
     * </p>
     * 
     * @return The version of the Lambda function that was invoked for this durable execution. This ensures that all
     *         replays during the execution use the same function version.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The trace headers associated with the durable execution.
     * </p>
     * 
     * @return The trace headers associated with the durable execution.
     */
    public final TraceHeader traceHeader() {
        return traceHeader;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(durableExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(durableExecutionName());
        hashCode = 31 * hashCode + Objects.hashCode(functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(inputPayload());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(traceHeader());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDurableExecutionResponse)) {
            return false;
        }
        GetDurableExecutionResponse other = (GetDurableExecutionResponse) obj;
        return Objects.equals(durableExecutionArn(), other.durableExecutionArn())
                && Objects.equals(durableExecutionName(), other.durableExecutionName())
                && Objects.equals(functionArn(), other.functionArn()) && Objects.equals(inputPayload(), other.inputPayload())
                && Objects.equals(result(), other.result()) && Objects.equals(error(), other.error())
                && Objects.equals(startTimestamp(), other.startTimestamp())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(endTimestamp(), other.endTimestamp()) && Objects.equals(version(), other.version())
                && Objects.equals(traceHeader(), other.traceHeader());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDurableExecutionResponse").add("DurableExecutionArn", durableExecutionArn())
                .add("DurableExecutionName", durableExecutionName()).add("FunctionArn", functionArn())
                .add("InputPayload", inputPayload() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Result", result() == null ? null : "*** Sensitive Data Redacted ***").add("Error", error())
                .add("StartTimestamp", startTimestamp()).add("Status", statusAsString()).add("EndTimestamp", endTimestamp())
                .add("Version", version()).add("TraceHeader", traceHeader()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DurableExecutionArn":
            return Optional.ofNullable(clazz.cast(durableExecutionArn()));
        case "DurableExecutionName":
            return Optional.ofNullable(clazz.cast(durableExecutionName()));
        case "FunctionArn":
            return Optional.ofNullable(clazz.cast(functionArn()));
        case "InputPayload":
            return Optional.ofNullable(clazz.cast(inputPayload()));
        case "Result":
            return Optional.ofNullable(clazz.cast(result()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "StartTimestamp":
            return Optional.ofNullable(clazz.cast(startTimestamp()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "EndTimestamp":
            return Optional.ofNullable(clazz.cast(endTimestamp()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "TraceHeader":
            return Optional.ofNullable(clazz.cast(traceHeader()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DurableExecutionArn", DURABLE_EXECUTION_ARN_FIELD);
        map.put("DurableExecutionName", DURABLE_EXECUTION_NAME_FIELD);
        map.put("FunctionArn", FUNCTION_ARN_FIELD);
        map.put("InputPayload", INPUT_PAYLOAD_FIELD);
        map.put("Result", RESULT_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("StartTimestamp", START_TIMESTAMP_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("EndTimestamp", END_TIMESTAMP_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("TraceHeader", TRACE_HEADER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDurableExecutionResponse, T> g) {
        return obj -> g.apply((GetDurableExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDurableExecutionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the durable execution.
         * </p>
         * 
         * @param durableExecutionArn
         *        The Amazon Resource Name (ARN) of the durable execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durableExecutionArn(String durableExecutionArn);

        /**
         * <p>
         * The name of the durable execution. This is either the name you provided when invoking the function, or a
         * system-generated unique identifier if no name was provided.
         * </p>
         * 
         * @param durableExecutionName
         *        The name of the durable execution. This is either the name you provided when invoking the function, or
         *        a system-generated unique identifier if no name was provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durableExecutionName(String durableExecutionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function that was invoked to start this durable execution.
         * </p>
         * 
         * @param functionArn
         *        The Amazon Resource Name (ARN) of the Lambda function that was invoked to start this durable
         *        execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArn(String functionArn);

        /**
         * <p>
         * The JSON input payload that was provided when the durable execution was started. For asynchronous
         * invocations, this is limited to 256 KB. For synchronous invocations, this can be up to 6 MB.
         * </p>
         * 
         * @param inputPayload
         *        The JSON input payload that was provided when the durable execution was started. For asynchronous
         *        invocations, this is limited to 256 KB. For synchronous invocations, this can be up to 6 MB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputPayload(String inputPayload);

        /**
         * <p>
         * The JSON result returned by the durable execution if it completed successfully. This field is only present
         * when the execution status is <code>SUCCEEDED</code>. The result is limited to 256 KB.
         * </p>
         * 
         * @param result
         *        The JSON result returned by the durable execution if it completed successfully. This field is only
         *        present when the execution status is <code>SUCCEEDED</code>. The result is limited to 256 KB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(String result);

        /**
         * <p>
         * Error information if the durable execution failed. This field is only present when the execution status is
         * <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>STOPPED</code>. The combined size of all error fields
         * is limited to 256 KB.
         * </p>
         * 
         * @param error
         *        Error information if the durable execution failed. This field is only present when the execution
         *        status is <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>STOPPED</code>. The combined size of
         *        all error fields is limited to 256 KB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorObject error);

        /**
         * <p>
         * Error information if the durable execution failed. This field is only present when the execution status is
         * <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>STOPPED</code>. The combined size of all error fields
         * is limited to 256 KB.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorObject.Builder} avoiding the need to
         * create one manually via {@link ErrorObject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorObject.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorObject)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorObject)
         */
        default Builder error(Consumer<ErrorObject.Builder> error) {
            return error(ErrorObject.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * The date and time when the durable execution started, in Unix timestamp format.
         * </p>
         * 
         * @param startTimestamp
         *        The date and time when the durable execution started, in Unix timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestamp(Instant startTimestamp);

        /**
         * <p>
         * The current status of the durable execution. Valid values are <code>RUNNING</code>, <code>SUCCEEDED</code>,
         * <code>FAILED</code>, <code>TIMED_OUT</code>, and <code>STOPPED</code>.
         * </p>
         * 
         * @param status
         *        The current status of the durable execution. Valid values are <code>RUNNING</code>,
         *        <code>SUCCEEDED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, and <code>STOPPED</code>.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the durable execution. Valid values are <code>RUNNING</code>, <code>SUCCEEDED</code>,
         * <code>FAILED</code>, <code>TIMED_OUT</code>, and <code>STOPPED</code>.
         * </p>
         * 
         * @param status
         *        The current status of the durable execution. Valid values are <code>RUNNING</code>,
         *        <code>SUCCEEDED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, and <code>STOPPED</code>.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(ExecutionStatus status);

        /**
         * <p>
         * The date and time when the durable execution ended, in Unix timestamp format. This field is only present if
         * the execution has completed (status is <code>SUCCEEDED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>,
         * or <code>STOPPED</code>).
         * </p>
         * 
         * @param endTimestamp
         *        The date and time when the durable execution ended, in Unix timestamp format. This field is only
         *        present if the execution has completed (status is <code>SUCCEEDED</code>, <code>FAILED</code>,
         *        <code>TIMED_OUT</code>, or <code>STOPPED</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimestamp(Instant endTimestamp);

        /**
         * <p>
         * The version of the Lambda function that was invoked for this durable execution. This ensures that all replays
         * during the execution use the same function version.
         * </p>
         * 
         * @param version
         *        The version of the Lambda function that was invoked for this durable execution. This ensures that all
         *        replays during the execution use the same function version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The trace headers associated with the durable execution.
         * </p>
         * 
         * @param traceHeader
         *        The trace headers associated with the durable execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceHeader(TraceHeader traceHeader);

        /**
         * <p>
         * The trace headers associated with the durable execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link TraceHeader.Builder} avoiding the need to
         * create one manually via {@link TraceHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TraceHeader.Builder#build()} is called immediately and its result
         * is passed to {@link #traceHeader(TraceHeader)}.
         * 
         * @param traceHeader
         *        a consumer that will call methods on {@link TraceHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #traceHeader(TraceHeader)
         */
        default Builder traceHeader(Consumer<TraceHeader.Builder> traceHeader) {
            return traceHeader(TraceHeader.builder().applyMutation(traceHeader).build());
        }
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String durableExecutionArn;

        private String durableExecutionName;

        private String functionArn;

        private String inputPayload;

        private String result;

        private ErrorObject error;

        private Instant startTimestamp;

        private String status;

        private Instant endTimestamp;

        private String version;

        private TraceHeader traceHeader;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDurableExecutionResponse model) {
            super(model);
            durableExecutionArn(model.durableExecutionArn);
            durableExecutionName(model.durableExecutionName);
            functionArn(model.functionArn);
            inputPayload(model.inputPayload);
            result(model.result);
            error(model.error);
            startTimestamp(model.startTimestamp);
            status(model.status);
            endTimestamp(model.endTimestamp);
            version(model.version);
            traceHeader(model.traceHeader);
        }

        public final String getDurableExecutionArn() {
            return durableExecutionArn;
        }

        public final void setDurableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
        }

        @Override
        public final Builder durableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
            return this;
        }

        public final String getDurableExecutionName() {
            return durableExecutionName;
        }

        public final void setDurableExecutionName(String durableExecutionName) {
            this.durableExecutionName = durableExecutionName;
        }

        @Override
        public final Builder durableExecutionName(String durableExecutionName) {
            this.durableExecutionName = durableExecutionName;
            return this;
        }

        public final String getFunctionArn() {
            return functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final String getInputPayload() {
            return inputPayload;
        }

        public final void setInputPayload(String inputPayload) {
            this.inputPayload = inputPayload;
        }

        @Override
        public final Builder inputPayload(String inputPayload) {
            this.inputPayload = inputPayload;
            return this;
        }

        public final String getResult() {
            return result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        public final ErrorObject.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorObject.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorObject error) {
            this.error = error;
            return this;
        }

        public final Instant getStartTimestamp() {
            return startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getEndTimestamp() {
            return endTimestamp;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final TraceHeader.Builder getTraceHeader() {
            return traceHeader != null ? traceHeader.toBuilder() : null;
        }

        public final void setTraceHeader(TraceHeader.BuilderImpl traceHeader) {
            this.traceHeader = traceHeader != null ? traceHeader.build() : null;
        }

        @Override
        public final Builder traceHeader(TraceHeader traceHeader) {
            this.traceHeader = traceHeader;
            return this;
        }

        @Override
        public GetDurableExecutionResponse build() {
            return new GetDurableExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
