/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for <a href="https://docs.aws.amazon.com/lambda/latest/dg/durable-functions.html">durable
 * functions</a>, including execution timeout and retention period for execution history.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DurableConfig implements SdkPojo, Serializable, ToCopyableBuilder<DurableConfig.Builder, DurableConfig> {
    private static final SdkField<Integer> RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetentionPeriodInDays").getter(getter(DurableConfig::retentionPeriodInDays))
            .setter(setter(Builder::retentionPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriodInDays").build())
            .build();

    private static final SdkField<Integer> EXECUTION_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExecutionTimeout").getter(getter(DurableConfig::executionTimeout))
            .setter(setter(Builder::executionTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTimeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RETENTION_PERIOD_IN_DAYS_FIELD, EXECUTION_TIMEOUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer retentionPeriodInDays;

    private final Integer executionTimeout;

    private DurableConfig(BuilderImpl builder) {
        this.retentionPeriodInDays = builder.retentionPeriodInDays;
        this.executionTimeout = builder.executionTimeout;
    }

    /**
     * <p>
     * The number of days to retain execution history after a durable execution completes. After this period, execution
     * history is no longer available through the GetDurableExecutionHistory API.
     * </p>
     * 
     * @return The number of days to retain execution history after a durable execution completes. After this period,
     *         execution history is no longer available through the GetDurableExecutionHistory API.
     */
    public final Integer retentionPeriodInDays() {
        return retentionPeriodInDays;
    }

    /**
     * <p>
     * The maximum time (in seconds) that a durable execution can run before timing out. This timeout applies to the
     * entire durable execution, not individual function invocations.
     * </p>
     * 
     * @return The maximum time (in seconds) that a durable execution can run before timing out. This timeout applies to
     *         the entire durable execution, not individual function invocations.
     */
    public final Integer executionTimeout() {
        return executionTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(executionTimeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DurableConfig)) {
            return false;
        }
        DurableConfig other = (DurableConfig) obj;
        return Objects.equals(retentionPeriodInDays(), other.retentionPeriodInDays())
                && Objects.equals(executionTimeout(), other.executionTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DurableConfig").add("RetentionPeriodInDays", retentionPeriodInDays())
                .add("ExecutionTimeout", executionTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetentionPeriodInDays":
            return Optional.ofNullable(clazz.cast(retentionPeriodInDays()));
        case "ExecutionTimeout":
            return Optional.ofNullable(clazz.cast(executionTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RetentionPeriodInDays", RETENTION_PERIOD_IN_DAYS_FIELD);
        map.put("ExecutionTimeout", EXECUTION_TIMEOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DurableConfig, T> g) {
        return obj -> g.apply((DurableConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DurableConfig> {
        /**
         * <p>
         * The number of days to retain execution history after a durable execution completes. After this period,
         * execution history is no longer available through the GetDurableExecutionHistory API.
         * </p>
         * 
         * @param retentionPeriodInDays
         *        The number of days to retain execution history after a durable execution completes. After this period,
         *        execution history is no longer available through the GetDurableExecutionHistory API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriodInDays(Integer retentionPeriodInDays);

        /**
         * <p>
         * The maximum time (in seconds) that a durable execution can run before timing out. This timeout applies to the
         * entire durable execution, not individual function invocations.
         * </p>
         * 
         * @param executionTimeout
         *        The maximum time (in seconds) that a durable execution can run before timing out. This timeout applies
         *        to the entire durable execution, not individual function invocations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTimeout(Integer executionTimeout);
    }

    static final class BuilderImpl implements Builder {
        private Integer retentionPeriodInDays;

        private Integer executionTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(DurableConfig model) {
            retentionPeriodInDays(model.retentionPeriodInDays);
            executionTimeout(model.executionTimeout);
        }

        public final Integer getRetentionPeriodInDays() {
            return retentionPeriodInDays;
        }

        public final void setRetentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
        }

        @Override
        public final Builder retentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
            return this;
        }

        public final Integer getExecutionTimeout() {
            return executionTimeout;
        }

        public final void setExecutionTimeout(Integer executionTimeout) {
            this.executionTimeout = executionTimeout;
        }

        @Override
        public final Builder executionTimeout(Integer executionTimeout) {
            this.executionTimeout = executionTimeout;
            return this;
        }

        @Override
        public DurableConfig build() {
            return new DurableConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
