/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCapacityProviderRequest extends LambdaRequest implements
        ToCopyableBuilder<CreateCapacityProviderRequest.Builder, CreateCapacityProviderRequest> {
    private static final SdkField<String> CAPACITY_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CapacityProviderName").getter(getter(CreateCapacityProviderRequest::capacityProviderName))
            .setter(setter(Builder::capacityProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviderName").build())
            .build();

    private static final SdkField<CapacityProviderVpcConfig> VPC_CONFIG_FIELD = SdkField
            .<CapacityProviderVpcConfig> builder(MarshallingType.SDK_POJO).memberName("VpcConfig")
            .getter(getter(CreateCapacityProviderRequest::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(CapacityProviderVpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<CapacityProviderPermissionsConfig> PERMISSIONS_CONFIG_FIELD = SdkField
            .<CapacityProviderPermissionsConfig> builder(MarshallingType.SDK_POJO).memberName("PermissionsConfig")
            .getter(getter(CreateCapacityProviderRequest::permissionsConfig)).setter(setter(Builder::permissionsConfig))
            .constructor(CapacityProviderPermissionsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsConfig").build()).build();

    private static final SdkField<InstanceRequirements> INSTANCE_REQUIREMENTS_FIELD = SdkField
            .<InstanceRequirements> builder(MarshallingType.SDK_POJO).memberName("InstanceRequirements")
            .getter(getter(CreateCapacityProviderRequest::instanceRequirements)).setter(setter(Builder::instanceRequirements))
            .constructor(InstanceRequirements::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirements").build())
            .build();

    private static final SdkField<CapacityProviderScalingConfig> CAPACITY_PROVIDER_SCALING_CONFIG_FIELD = SdkField
            .<CapacityProviderScalingConfig> builder(MarshallingType.SDK_POJO)
            .memberName("CapacityProviderScalingConfig")
            .getter(getter(CreateCapacityProviderRequest::capacityProviderScalingConfig))
            .setter(setter(Builder::capacityProviderScalingConfig))
            .constructor(CapacityProviderScalingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviderScalingConfig")
                    .build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(CreateCapacityProviderRequest::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateCapacityProviderRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDER_NAME_FIELD,
            VPC_CONFIG_FIELD, PERMISSIONS_CONFIG_FIELD, INSTANCE_REQUIREMENTS_FIELD, CAPACITY_PROVIDER_SCALING_CONFIG_FIELD,
            KMS_KEY_ARN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String capacityProviderName;

    private final CapacityProviderVpcConfig vpcConfig;

    private final CapacityProviderPermissionsConfig permissionsConfig;

    private final InstanceRequirements instanceRequirements;

    private final CapacityProviderScalingConfig capacityProviderScalingConfig;

    private final String kmsKeyArn;

    private final Map<String, String> tags;

    private CreateCapacityProviderRequest(BuilderImpl builder) {
        super(builder);
        this.capacityProviderName = builder.capacityProviderName;
        this.vpcConfig = builder.vpcConfig;
        this.permissionsConfig = builder.permissionsConfig;
        this.instanceRequirements = builder.instanceRequirements;
        this.capacityProviderScalingConfig = builder.capacityProviderScalingConfig;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the capacity provider.
     * </p>
     * 
     * @return The name of the capacity provider.
     */
    public final String capacityProviderName() {
        return capacityProviderName;
    }

    /**
     * <p>
     * The VPC configuration for the capacity provider, including subnet IDs and security group IDs where compute
     * instances will be launched.
     * </p>
     * 
     * @return The VPC configuration for the capacity provider, including subnet IDs and security group IDs where
     *         compute instances will be launched.
     */
    public final CapacityProviderVpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The permissions configuration that specifies the IAM role ARN used by the capacity provider to manage compute
     * resources.
     * </p>
     * 
     * @return The permissions configuration that specifies the IAM role ARN used by the capacity provider to manage
     *         compute resources.
     */
    public final CapacityProviderPermissionsConfig permissionsConfig() {
        return permissionsConfig;
    }

    /**
     * <p>
     * The instance requirements that specify the compute instance characteristics, including architectures and allowed
     * or excluded instance types.
     * </p>
     * 
     * @return The instance requirements that specify the compute instance characteristics, including architectures and
     *         allowed or excluded instance types.
     */
    public final InstanceRequirements instanceRequirements() {
        return instanceRequirements;
    }

    /**
     * <p>
     * The scaling configuration that defines how the capacity provider scales compute instances, including maximum vCPU
     * count and scaling policies.
     * </p>
     * 
     * @return The scaling configuration that defines how the capacity provider scales compute instances, including
     *         maximum vCPU count and scaling policies.
     */
    public final CapacityProviderScalingConfig capacityProviderScalingConfig() {
        return capacityProviderScalingConfig;
    }

    /**
     * <p>
     * The ARN of the KMS key used to encrypt data associated with the capacity provider.
     * </p>
     * 
     * @return The ARN of the KMS key used to encrypt data associated with the capacity provider.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags to associate with the capacity provider.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to associate with the capacity provider.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacityProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(permissionsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(instanceRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(capacityProviderScalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCapacityProviderRequest)) {
            return false;
        }
        CreateCapacityProviderRequest other = (CreateCapacityProviderRequest) obj;
        return Objects.equals(capacityProviderName(), other.capacityProviderName())
                && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(permissionsConfig(), other.permissionsConfig())
                && Objects.equals(instanceRequirements(), other.instanceRequirements())
                && Objects.equals(capacityProviderScalingConfig(), other.capacityProviderScalingConfig())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCapacityProviderRequest").add("CapacityProviderName", capacityProviderName())
                .add("VpcConfig", vpcConfig()).add("PermissionsConfig", permissionsConfig())
                .add("InstanceRequirements", instanceRequirements())
                .add("CapacityProviderScalingConfig", capacityProviderScalingConfig()).add("KmsKeyArn", kmsKeyArn())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityProviderName":
            return Optional.ofNullable(clazz.cast(capacityProviderName()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "PermissionsConfig":
            return Optional.ofNullable(clazz.cast(permissionsConfig()));
        case "InstanceRequirements":
            return Optional.ofNullable(clazz.cast(instanceRequirements()));
        case "CapacityProviderScalingConfig":
            return Optional.ofNullable(clazz.cast(capacityProviderScalingConfig()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityProviderName", CAPACITY_PROVIDER_NAME_FIELD);
        map.put("VpcConfig", VPC_CONFIG_FIELD);
        map.put("PermissionsConfig", PERMISSIONS_CONFIG_FIELD);
        map.put("InstanceRequirements", INSTANCE_REQUIREMENTS_FIELD);
        map.put("CapacityProviderScalingConfig", CAPACITY_PROVIDER_SCALING_CONFIG_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCapacityProviderRequest, T> g) {
        return obj -> g.apply((CreateCapacityProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCapacityProviderRequest> {
        /**
         * <p>
         * The name of the capacity provider.
         * </p>
         * 
         * @param capacityProviderName
         *        The name of the capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderName(String capacityProviderName);

        /**
         * <p>
         * The VPC configuration for the capacity provider, including subnet IDs and security group IDs where compute
         * instances will be launched.
         * </p>
         * 
         * @param vpcConfig
         *        The VPC configuration for the capacity provider, including subnet IDs and security group IDs where
         *        compute instances will be launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(CapacityProviderVpcConfig vpcConfig);

        /**
         * <p>
         * The VPC configuration for the capacity provider, including subnet IDs and security group IDs where compute
         * instances will be launched.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityProviderVpcConfig.Builder}
         * avoiding the need to create one manually via {@link CapacityProviderVpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityProviderVpcConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcConfig(CapacityProviderVpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link CapacityProviderVpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(CapacityProviderVpcConfig)
         */
        default Builder vpcConfig(Consumer<CapacityProviderVpcConfig.Builder> vpcConfig) {
            return vpcConfig(CapacityProviderVpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The permissions configuration that specifies the IAM role ARN used by the capacity provider to manage compute
         * resources.
         * </p>
         * 
         * @param permissionsConfig
         *        The permissions configuration that specifies the IAM role ARN used by the capacity provider to manage
         *        compute resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsConfig(CapacityProviderPermissionsConfig permissionsConfig);

        /**
         * <p>
         * The permissions configuration that specifies the IAM role ARN used by the capacity provider to manage compute
         * resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CapacityProviderPermissionsConfig.Builder} avoiding the need to create one manually via
         * {@link CapacityProviderPermissionsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityProviderPermissionsConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #permissionsConfig(CapacityProviderPermissionsConfig)}.
         * 
         * @param permissionsConfig
         *        a consumer that will call methods on {@link CapacityProviderPermissionsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionsConfig(CapacityProviderPermissionsConfig)
         */
        default Builder permissionsConfig(Consumer<CapacityProviderPermissionsConfig.Builder> permissionsConfig) {
            return permissionsConfig(CapacityProviderPermissionsConfig.builder().applyMutation(permissionsConfig).build());
        }

        /**
         * <p>
         * The instance requirements that specify the compute instance characteristics, including architectures and
         * allowed or excluded instance types.
         * </p>
         * 
         * @param instanceRequirements
         *        The instance requirements that specify the compute instance characteristics, including architectures
         *        and allowed or excluded instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRequirements(InstanceRequirements instanceRequirements);

        /**
         * <p>
         * The instance requirements that specify the compute instance characteristics, including architectures and
         * allowed or excluded instance types.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceRequirements.Builder} avoiding
         * the need to create one manually via {@link InstanceRequirements#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceRequirements.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceRequirements(InstanceRequirements)}.
         * 
         * @param instanceRequirements
         *        a consumer that will call methods on {@link InstanceRequirements.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceRequirements(InstanceRequirements)
         */
        default Builder instanceRequirements(Consumer<InstanceRequirements.Builder> instanceRequirements) {
            return instanceRequirements(InstanceRequirements.builder().applyMutation(instanceRequirements).build());
        }

        /**
         * <p>
         * The scaling configuration that defines how the capacity provider scales compute instances, including maximum
         * vCPU count and scaling policies.
         * </p>
         * 
         * @param capacityProviderScalingConfig
         *        The scaling configuration that defines how the capacity provider scales compute instances, including
         *        maximum vCPU count and scaling policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderScalingConfig(CapacityProviderScalingConfig capacityProviderScalingConfig);

        /**
         * <p>
         * The scaling configuration that defines how the capacity provider scales compute instances, including maximum
         * vCPU count and scaling policies.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityProviderScalingConfig.Builder}
         * avoiding the need to create one manually via {@link CapacityProviderScalingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityProviderScalingConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #capacityProviderScalingConfig(CapacityProviderScalingConfig)}.
         * 
         * @param capacityProviderScalingConfig
         *        a consumer that will call methods on {@link CapacityProviderScalingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityProviderScalingConfig(CapacityProviderScalingConfig)
         */
        default Builder capacityProviderScalingConfig(
                Consumer<CapacityProviderScalingConfig.Builder> capacityProviderScalingConfig) {
            return capacityProviderScalingConfig(CapacityProviderScalingConfig.builder()
                    .applyMutation(capacityProviderScalingConfig).build());
        }

        /**
         * <p>
         * The ARN of the KMS key used to encrypt data associated with the capacity provider.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the KMS key used to encrypt data associated with the capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * A list of tags to associate with the capacity provider.
         * </p>
         * 
         * @param tags
         *        A list of tags to associate with the capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String capacityProviderName;

        private CapacityProviderVpcConfig vpcConfig;

        private CapacityProviderPermissionsConfig permissionsConfig;

        private InstanceRequirements instanceRequirements;

        private CapacityProviderScalingConfig capacityProviderScalingConfig;

        private String kmsKeyArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCapacityProviderRequest model) {
            super(model);
            capacityProviderName(model.capacityProviderName);
            vpcConfig(model.vpcConfig);
            permissionsConfig(model.permissionsConfig);
            instanceRequirements(model.instanceRequirements);
            capacityProviderScalingConfig(model.capacityProviderScalingConfig);
            kmsKeyArn(model.kmsKeyArn);
            tags(model.tags);
        }

        public final String getCapacityProviderName() {
            return capacityProviderName;
        }

        public final void setCapacityProviderName(String capacityProviderName) {
            this.capacityProviderName = capacityProviderName;
        }

        @Override
        public final Builder capacityProviderName(String capacityProviderName) {
            this.capacityProviderName = capacityProviderName;
            return this;
        }

        public final CapacityProviderVpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(CapacityProviderVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(CapacityProviderVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final CapacityProviderPermissionsConfig.Builder getPermissionsConfig() {
            return permissionsConfig != null ? permissionsConfig.toBuilder() : null;
        }

        public final void setPermissionsConfig(CapacityProviderPermissionsConfig.BuilderImpl permissionsConfig) {
            this.permissionsConfig = permissionsConfig != null ? permissionsConfig.build() : null;
        }

        @Override
        public final Builder permissionsConfig(CapacityProviderPermissionsConfig permissionsConfig) {
            this.permissionsConfig = permissionsConfig;
            return this;
        }

        public final InstanceRequirements.Builder getInstanceRequirements() {
            return instanceRequirements != null ? instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(InstanceRequirements.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        public final Builder instanceRequirements(InstanceRequirements instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        public final CapacityProviderScalingConfig.Builder getCapacityProviderScalingConfig() {
            return capacityProviderScalingConfig != null ? capacityProviderScalingConfig.toBuilder() : null;
        }

        public final void setCapacityProviderScalingConfig(CapacityProviderScalingConfig.BuilderImpl capacityProviderScalingConfig) {
            this.capacityProviderScalingConfig = capacityProviderScalingConfig != null ? capacityProviderScalingConfig.build()
                    : null;
        }

        @Override
        public final Builder capacityProviderScalingConfig(CapacityProviderScalingConfig capacityProviderScalingConfig) {
            this.capacityProviderScalingConfig = capacityProviderScalingConfig;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCapacityProviderRequest build() {
            return new CreateCapacityProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
