/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response from the CheckpointDurableExecution operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckpointDurableExecutionResponse extends LambdaResponse implements
        ToCopyableBuilder<CheckpointDurableExecutionResponse.Builder, CheckpointDurableExecutionResponse> {
    private static final SdkField<String> CHECKPOINT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CheckpointToken").getter(getter(CheckpointDurableExecutionResponse::checkpointToken))
            .setter(setter(Builder::checkpointToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointToken").build()).build();

    private static final SdkField<CheckpointUpdatedExecutionState> NEW_EXECUTION_STATE_FIELD = SdkField
            .<CheckpointUpdatedExecutionState> builder(MarshallingType.SDK_POJO).memberName("NewExecutionState")
            .getter(getter(CheckpointDurableExecutionResponse::newExecutionState)).setter(setter(Builder::newExecutionState))
            .constructor(CheckpointUpdatedExecutionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewExecutionState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECKPOINT_TOKEN_FIELD,
            NEW_EXECUTION_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String checkpointToken;

    private final CheckpointUpdatedExecutionState newExecutionState;

    private CheckpointDurableExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.checkpointToken = builder.checkpointToken;
        this.newExecutionState = builder.newExecutionState;
    }

    /**
     * <p>
     * A new checkpoint token to use for the next checkpoint operation. This token replaces the one provided in the
     * request and must be used for subsequent checkpoints to maintain proper ordering.
     * </p>
     * 
     * @return A new checkpoint token to use for the next checkpoint operation. This token replaces the one provided in
     *         the request and must be used for subsequent checkpoints to maintain proper ordering.
     */
    public final String checkpointToken() {
        return checkpointToken;
    }

    /**
     * <p>
     * Updated execution state information that includes any changes that occurred since the last checkpoint, such as
     * completed callbacks or expired timers. This allows the SDK to update its internal state during replay.
     * </p>
     * 
     * @return Updated execution state information that includes any changes that occurred since the last checkpoint,
     *         such as completed callbacks or expired timers. This allows the SDK to update its internal state during
     *         replay.
     */
    public final CheckpointUpdatedExecutionState newExecutionState() {
        return newExecutionState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(checkpointToken());
        hashCode = 31 * hashCode + Objects.hashCode(newExecutionState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckpointDurableExecutionResponse)) {
            return false;
        }
        CheckpointDurableExecutionResponse other = (CheckpointDurableExecutionResponse) obj;
        return Objects.equals(checkpointToken(), other.checkpointToken())
                && Objects.equals(newExecutionState(), other.newExecutionState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckpointDurableExecutionResponse").add("CheckpointToken", checkpointToken())
                .add("NewExecutionState", newExecutionState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CheckpointToken":
            return Optional.ofNullable(clazz.cast(checkpointToken()));
        case "NewExecutionState":
            return Optional.ofNullable(clazz.cast(newExecutionState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CheckpointToken", CHECKPOINT_TOKEN_FIELD);
        map.put("NewExecutionState", NEW_EXECUTION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckpointDurableExecutionResponse, T> g) {
        return obj -> g.apply((CheckpointDurableExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CheckpointDurableExecutionResponse> {
        /**
         * <p>
         * A new checkpoint token to use for the next checkpoint operation. This token replaces the one provided in the
         * request and must be used for subsequent checkpoints to maintain proper ordering.
         * </p>
         * 
         * @param checkpointToken
         *        A new checkpoint token to use for the next checkpoint operation. This token replaces the one provided
         *        in the request and must be used for subsequent checkpoints to maintain proper ordering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkpointToken(String checkpointToken);

        /**
         * <p>
         * Updated execution state information that includes any changes that occurred since the last checkpoint, such
         * as completed callbacks or expired timers. This allows the SDK to update its internal state during replay.
         * </p>
         * 
         * @param newExecutionState
         *        Updated execution state information that includes any changes that occurred since the last checkpoint,
         *        such as completed callbacks or expired timers. This allows the SDK to update its internal state during
         *        replay.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newExecutionState(CheckpointUpdatedExecutionState newExecutionState);

        /**
         * <p>
         * Updated execution state information that includes any changes that occurred since the last checkpoint, such
         * as completed callbacks or expired timers. This allows the SDK to update its internal state during replay.
         * </p>
         * This is a convenience method that creates an instance of the {@link CheckpointUpdatedExecutionState.Builder}
         * avoiding the need to create one manually via {@link CheckpointUpdatedExecutionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CheckpointUpdatedExecutionState.Builder#build()} is called
         * immediately and its result is passed to {@link #newExecutionState(CheckpointUpdatedExecutionState)}.
         * 
         * @param newExecutionState
         *        a consumer that will call methods on {@link CheckpointUpdatedExecutionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newExecutionState(CheckpointUpdatedExecutionState)
         */
        default Builder newExecutionState(Consumer<CheckpointUpdatedExecutionState.Builder> newExecutionState) {
            return newExecutionState(CheckpointUpdatedExecutionState.builder().applyMutation(newExecutionState).build());
        }
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String checkpointToken;

        private CheckpointUpdatedExecutionState newExecutionState;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckpointDurableExecutionResponse model) {
            super(model);
            checkpointToken(model.checkpointToken);
            newExecutionState(model.newExecutionState);
        }

        public final String getCheckpointToken() {
            return checkpointToken;
        }

        public final void setCheckpointToken(String checkpointToken) {
            this.checkpointToken = checkpointToken;
        }

        @Override
        public final Builder checkpointToken(String checkpointToken) {
            this.checkpointToken = checkpointToken;
            return this;
        }

        public final CheckpointUpdatedExecutionState.Builder getNewExecutionState() {
            return newExecutionState != null ? newExecutionState.toBuilder() : null;
        }

        public final void setNewExecutionState(CheckpointUpdatedExecutionState.BuilderImpl newExecutionState) {
            this.newExecutionState = newExecutionState != null ? newExecutionState.build() : null;
        }

        @Override
        public final Builder newExecutionState(CheckpointUpdatedExecutionState newExecutionState) {
            this.newExecutionState = newExecutionState;
            return this;
        }

        @Override
        public CheckpointDurableExecutionResponse build() {
            return new CheckpointDurableExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
