/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An event that occurred during the execution of a durable function.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Event implements SdkPojo, Serializable, ToCopyableBuilder<Event.Builder, Event> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventType").getter(getter(Event::eventTypeAsString)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()).build();

    private static final SdkField<String> SUB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubType").getter(getter(Event::subType)).setter(setter(Builder::subType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubType").build()).build();

    private static final SdkField<Integer> EVENT_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EventId").getter(getter(Event::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Event::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Event::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Instant> EVENT_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EventTimestamp").getter(getter(Event::eventTimestamp)).setter(setter(Builder::eventTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTimestamp").build()).build();

    private static final SdkField<String> PARENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentId").getter(getter(Event::parentId)).setter(setter(Builder::parentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentId").build()).build();

    private static final SdkField<ExecutionStartedDetails> EXECUTION_STARTED_DETAILS_FIELD = SdkField
            .<ExecutionStartedDetails> builder(MarshallingType.SDK_POJO).memberName("ExecutionStartedDetails")
            .getter(getter(Event::executionStartedDetails)).setter(setter(Builder::executionStartedDetails))
            .constructor(ExecutionStartedDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStartedDetails").build())
            .build();

    private static final SdkField<ExecutionSucceededDetails> EXECUTION_SUCCEEDED_DETAILS_FIELD = SdkField
            .<ExecutionSucceededDetails> builder(MarshallingType.SDK_POJO).memberName("ExecutionSucceededDetails")
            .getter(getter(Event::executionSucceededDetails)).setter(setter(Builder::executionSucceededDetails))
            .constructor(ExecutionSucceededDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionSucceededDetails").build())
            .build();

    private static final SdkField<ExecutionFailedDetails> EXECUTION_FAILED_DETAILS_FIELD = SdkField
            .<ExecutionFailedDetails> builder(MarshallingType.SDK_POJO).memberName("ExecutionFailedDetails")
            .getter(getter(Event::executionFailedDetails)).setter(setter(Builder::executionFailedDetails))
            .constructor(ExecutionFailedDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionFailedDetails").build())
            .build();

    private static final SdkField<ExecutionTimedOutDetails> EXECUTION_TIMED_OUT_DETAILS_FIELD = SdkField
            .<ExecutionTimedOutDetails> builder(MarshallingType.SDK_POJO).memberName("ExecutionTimedOutDetails")
            .getter(getter(Event::executionTimedOutDetails)).setter(setter(Builder::executionTimedOutDetails))
            .constructor(ExecutionTimedOutDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTimedOutDetails").build())
            .build();

    private static final SdkField<ExecutionStoppedDetails> EXECUTION_STOPPED_DETAILS_FIELD = SdkField
            .<ExecutionStoppedDetails> builder(MarshallingType.SDK_POJO).memberName("ExecutionStoppedDetails")
            .getter(getter(Event::executionStoppedDetails)).setter(setter(Builder::executionStoppedDetails))
            .constructor(ExecutionStoppedDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStoppedDetails").build())
            .build();

    private static final SdkField<ContextStartedDetails> CONTEXT_STARTED_DETAILS_FIELD = SdkField
            .<ContextStartedDetails> builder(MarshallingType.SDK_POJO).memberName("ContextStartedDetails")
            .getter(getter(Event::contextStartedDetails)).setter(setter(Builder::contextStartedDetails))
            .constructor(ContextStartedDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextStartedDetails").build())
            .build();

    private static final SdkField<ContextSucceededDetails> CONTEXT_SUCCEEDED_DETAILS_FIELD = SdkField
            .<ContextSucceededDetails> builder(MarshallingType.SDK_POJO).memberName("ContextSucceededDetails")
            .getter(getter(Event::contextSucceededDetails)).setter(setter(Builder::contextSucceededDetails))
            .constructor(ContextSucceededDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextSucceededDetails").build())
            .build();

    private static final SdkField<ContextFailedDetails> CONTEXT_FAILED_DETAILS_FIELD = SdkField
            .<ContextFailedDetails> builder(MarshallingType.SDK_POJO).memberName("ContextFailedDetails")
            .getter(getter(Event::contextFailedDetails)).setter(setter(Builder::contextFailedDetails))
            .constructor(ContextFailedDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextFailedDetails").build())
            .build();

    private static final SdkField<WaitStartedDetails> WAIT_STARTED_DETAILS_FIELD = SdkField
            .<WaitStartedDetails> builder(MarshallingType.SDK_POJO).memberName("WaitStartedDetails")
            .getter(getter(Event::waitStartedDetails)).setter(setter(Builder::waitStartedDetails))
            .constructor(WaitStartedDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitStartedDetails").build())
            .build();

    private static final SdkField<WaitSucceededDetails> WAIT_SUCCEEDED_DETAILS_FIELD = SdkField
            .<WaitSucceededDetails> builder(MarshallingType.SDK_POJO).memberName("WaitSucceededDetails")
            .getter(getter(Event::waitSucceededDetails)).setter(setter(Builder::waitSucceededDetails))
            .constructor(WaitSucceededDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitSucceededDetails").build())
            .build();

    private static final SdkField<WaitCancelledDetails> WAIT_CANCELLED_DETAILS_FIELD = SdkField
            .<WaitCancelledDetails> builder(MarshallingType.SDK_POJO).memberName("WaitCancelledDetails")
            .getter(getter(Event::waitCancelledDetails)).setter(setter(Builder::waitCancelledDetails))
            .constructor(WaitCancelledDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitCancelledDetails").build())
            .build();

    private static final SdkField<StepStartedDetails> STEP_STARTED_DETAILS_FIELD = SdkField
            .<StepStartedDetails> builder(MarshallingType.SDK_POJO).memberName("StepStartedDetails")
            .getter(getter(Event::stepStartedDetails)).setter(setter(Builder::stepStartedDetails))
            .constructor(StepStartedDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepStartedDetails").build())
            .build();

    private static final SdkField<StepSucceededDetails> STEP_SUCCEEDED_DETAILS_FIELD = SdkField
            .<StepSucceededDetails> builder(MarshallingType.SDK_POJO).memberName("StepSucceededDetails")
            .getter(getter(Event::stepSucceededDetails)).setter(setter(Builder::stepSucceededDetails))
            .constructor(StepSucceededDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepSucceededDetails").build())
            .build();

    private static final SdkField<StepFailedDetails> STEP_FAILED_DETAILS_FIELD = SdkField
            .<StepFailedDetails> builder(MarshallingType.SDK_POJO).memberName("StepFailedDetails")
            .getter(getter(Event::stepFailedDetails)).setter(setter(Builder::stepFailedDetails))
            .constructor(StepFailedDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepFailedDetails").build()).build();

    private static final SdkField<ChainedInvokeStartedDetails> CHAINED_INVOKE_STARTED_DETAILS_FIELD = SdkField
            .<ChainedInvokeStartedDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ChainedInvokeStartedDetails")
            .getter(getter(Event::chainedInvokeStartedDetails))
            .setter(setter(Builder::chainedInvokeStartedDetails))
            .constructor(ChainedInvokeStartedDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChainedInvokeStartedDetails")
                    .build()).build();

    private static final SdkField<ChainedInvokeSucceededDetails> CHAINED_INVOKE_SUCCEEDED_DETAILS_FIELD = SdkField
            .<ChainedInvokeSucceededDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ChainedInvokeSucceededDetails")
            .getter(getter(Event::chainedInvokeSucceededDetails))
            .setter(setter(Builder::chainedInvokeSucceededDetails))
            .constructor(ChainedInvokeSucceededDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChainedInvokeSucceededDetails")
                    .build()).build();

    private static final SdkField<ChainedInvokeFailedDetails> CHAINED_INVOKE_FAILED_DETAILS_FIELD = SdkField
            .<ChainedInvokeFailedDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ChainedInvokeFailedDetails")
            .getter(getter(Event::chainedInvokeFailedDetails))
            .setter(setter(Builder::chainedInvokeFailedDetails))
            .constructor(ChainedInvokeFailedDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChainedInvokeFailedDetails").build())
            .build();

    private static final SdkField<ChainedInvokeTimedOutDetails> CHAINED_INVOKE_TIMED_OUT_DETAILS_FIELD = SdkField
            .<ChainedInvokeTimedOutDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ChainedInvokeTimedOutDetails")
            .getter(getter(Event::chainedInvokeTimedOutDetails))
            .setter(setter(Builder::chainedInvokeTimedOutDetails))
            .constructor(ChainedInvokeTimedOutDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChainedInvokeTimedOutDetails")
                    .build()).build();

    private static final SdkField<ChainedInvokeStoppedDetails> CHAINED_INVOKE_STOPPED_DETAILS_FIELD = SdkField
            .<ChainedInvokeStoppedDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ChainedInvokeStoppedDetails")
            .getter(getter(Event::chainedInvokeStoppedDetails))
            .setter(setter(Builder::chainedInvokeStoppedDetails))
            .constructor(ChainedInvokeStoppedDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChainedInvokeStoppedDetails")
                    .build()).build();

    private static final SdkField<CallbackStartedDetails> CALLBACK_STARTED_DETAILS_FIELD = SdkField
            .<CallbackStartedDetails> builder(MarshallingType.SDK_POJO).memberName("CallbackStartedDetails")
            .getter(getter(Event::callbackStartedDetails)).setter(setter(Builder::callbackStartedDetails))
            .constructor(CallbackStartedDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackStartedDetails").build())
            .build();

    private static final SdkField<CallbackSucceededDetails> CALLBACK_SUCCEEDED_DETAILS_FIELD = SdkField
            .<CallbackSucceededDetails> builder(MarshallingType.SDK_POJO).memberName("CallbackSucceededDetails")
            .getter(getter(Event::callbackSucceededDetails)).setter(setter(Builder::callbackSucceededDetails))
            .constructor(CallbackSucceededDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackSucceededDetails").build())
            .build();

    private static final SdkField<CallbackFailedDetails> CALLBACK_FAILED_DETAILS_FIELD = SdkField
            .<CallbackFailedDetails> builder(MarshallingType.SDK_POJO).memberName("CallbackFailedDetails")
            .getter(getter(Event::callbackFailedDetails)).setter(setter(Builder::callbackFailedDetails))
            .constructor(CallbackFailedDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackFailedDetails").build())
            .build();

    private static final SdkField<CallbackTimedOutDetails> CALLBACK_TIMED_OUT_DETAILS_FIELD = SdkField
            .<CallbackTimedOutDetails> builder(MarshallingType.SDK_POJO).memberName("CallbackTimedOutDetails")
            .getter(getter(Event::callbackTimedOutDetails)).setter(setter(Builder::callbackTimedOutDetails))
            .constructor(CallbackTimedOutDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackTimedOutDetails").build())
            .build();

    private static final SdkField<InvocationCompletedDetails> INVOCATION_COMPLETED_DETAILS_FIELD = SdkField
            .<InvocationCompletedDetails> builder(MarshallingType.SDK_POJO)
            .memberName("InvocationCompletedDetails")
            .getter(getter(Event::invocationCompletedDetails))
            .setter(setter(Builder::invocationCompletedDetails))
            .constructor(InvocationCompletedDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationCompletedDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD,
            SUB_TYPE_FIELD, EVENT_ID_FIELD, ID_FIELD, NAME_FIELD, EVENT_TIMESTAMP_FIELD, PARENT_ID_FIELD,
            EXECUTION_STARTED_DETAILS_FIELD, EXECUTION_SUCCEEDED_DETAILS_FIELD, EXECUTION_FAILED_DETAILS_FIELD,
            EXECUTION_TIMED_OUT_DETAILS_FIELD, EXECUTION_STOPPED_DETAILS_FIELD, CONTEXT_STARTED_DETAILS_FIELD,
            CONTEXT_SUCCEEDED_DETAILS_FIELD, CONTEXT_FAILED_DETAILS_FIELD, WAIT_STARTED_DETAILS_FIELD,
            WAIT_SUCCEEDED_DETAILS_FIELD, WAIT_CANCELLED_DETAILS_FIELD, STEP_STARTED_DETAILS_FIELD, STEP_SUCCEEDED_DETAILS_FIELD,
            STEP_FAILED_DETAILS_FIELD, CHAINED_INVOKE_STARTED_DETAILS_FIELD, CHAINED_INVOKE_SUCCEEDED_DETAILS_FIELD,
            CHAINED_INVOKE_FAILED_DETAILS_FIELD, CHAINED_INVOKE_TIMED_OUT_DETAILS_FIELD, CHAINED_INVOKE_STOPPED_DETAILS_FIELD,
            CALLBACK_STARTED_DETAILS_FIELD, CALLBACK_SUCCEEDED_DETAILS_FIELD, CALLBACK_FAILED_DETAILS_FIELD,
            CALLBACK_TIMED_OUT_DETAILS_FIELD, INVOCATION_COMPLETED_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eventType;

    private final String subType;

    private final Integer eventId;

    private final String id;

    private final String name;

    private final Instant eventTimestamp;

    private final String parentId;

    private final ExecutionStartedDetails executionStartedDetails;

    private final ExecutionSucceededDetails executionSucceededDetails;

    private final ExecutionFailedDetails executionFailedDetails;

    private final ExecutionTimedOutDetails executionTimedOutDetails;

    private final ExecutionStoppedDetails executionStoppedDetails;

    private final ContextStartedDetails contextStartedDetails;

    private final ContextSucceededDetails contextSucceededDetails;

    private final ContextFailedDetails contextFailedDetails;

    private final WaitStartedDetails waitStartedDetails;

    private final WaitSucceededDetails waitSucceededDetails;

    private final WaitCancelledDetails waitCancelledDetails;

    private final StepStartedDetails stepStartedDetails;

    private final StepSucceededDetails stepSucceededDetails;

    private final StepFailedDetails stepFailedDetails;

    private final ChainedInvokeStartedDetails chainedInvokeStartedDetails;

    private final ChainedInvokeSucceededDetails chainedInvokeSucceededDetails;

    private final ChainedInvokeFailedDetails chainedInvokeFailedDetails;

    private final ChainedInvokeTimedOutDetails chainedInvokeTimedOutDetails;

    private final ChainedInvokeStoppedDetails chainedInvokeStoppedDetails;

    private final CallbackStartedDetails callbackStartedDetails;

    private final CallbackSucceededDetails callbackSucceededDetails;

    private final CallbackFailedDetails callbackFailedDetails;

    private final CallbackTimedOutDetails callbackTimedOutDetails;

    private final InvocationCompletedDetails invocationCompletedDetails;

    private Event(BuilderImpl builder) {
        this.eventType = builder.eventType;
        this.subType = builder.subType;
        this.eventId = builder.eventId;
        this.id = builder.id;
        this.name = builder.name;
        this.eventTimestamp = builder.eventTimestamp;
        this.parentId = builder.parentId;
        this.executionStartedDetails = builder.executionStartedDetails;
        this.executionSucceededDetails = builder.executionSucceededDetails;
        this.executionFailedDetails = builder.executionFailedDetails;
        this.executionTimedOutDetails = builder.executionTimedOutDetails;
        this.executionStoppedDetails = builder.executionStoppedDetails;
        this.contextStartedDetails = builder.contextStartedDetails;
        this.contextSucceededDetails = builder.contextSucceededDetails;
        this.contextFailedDetails = builder.contextFailedDetails;
        this.waitStartedDetails = builder.waitStartedDetails;
        this.waitSucceededDetails = builder.waitSucceededDetails;
        this.waitCancelledDetails = builder.waitCancelledDetails;
        this.stepStartedDetails = builder.stepStartedDetails;
        this.stepSucceededDetails = builder.stepSucceededDetails;
        this.stepFailedDetails = builder.stepFailedDetails;
        this.chainedInvokeStartedDetails = builder.chainedInvokeStartedDetails;
        this.chainedInvokeSucceededDetails = builder.chainedInvokeSucceededDetails;
        this.chainedInvokeFailedDetails = builder.chainedInvokeFailedDetails;
        this.chainedInvokeTimedOutDetails = builder.chainedInvokeTimedOutDetails;
        this.chainedInvokeStoppedDetails = builder.chainedInvokeStoppedDetails;
        this.callbackStartedDetails = builder.callbackStartedDetails;
        this.callbackSucceededDetails = builder.callbackSucceededDetails;
        this.callbackFailedDetails = builder.callbackFailedDetails;
        this.callbackTimedOutDetails = builder.callbackTimedOutDetails;
        this.invocationCompletedDetails = builder.invocationCompletedDetails;
    }

    /**
     * <p>
     * The type of event that occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of event that occurred.
     * @see EventType
     */
    public final EventType eventType() {
        return EventType.fromValue(eventType);
    }

    /**
     * <p>
     * The type of event that occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of event that occurred.
     * @see EventType
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * The subtype of the event, providing additional categorization.
     * </p>
     * 
     * @return The subtype of the event, providing additional categorization.
     */
    public final String subType() {
        return subType;
    }

    /**
     * <p>
     * The unique identifier for this event. Event IDs increment sequentially.
     * </p>
     * 
     * @return The unique identifier for this event. Event IDs increment sequentially.
     */
    public final Integer eventId() {
        return eventId;
    }

    /**
     * <p>
     * The unique identifier for this operation.
     * </p>
     * 
     * @return The unique identifier for this operation.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The customer-provided name for this operation.
     * </p>
     * 
     * @return The customer-provided name for this operation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The date and time when this event occurred, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a>
     * (YYYY-MM-DDThh:mm:ss.sTZD).
     * </p>
     * 
     * @return The date and time when this event occurred, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
     *         format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
     */
    public final Instant eventTimestamp() {
        return eventTimestamp;
    }

    /**
     * <p>
     * The unique identifier of the parent operation, if this operation is running within a child context.
     * </p>
     * 
     * @return The unique identifier of the parent operation, if this operation is running within a child context.
     */
    public final String parentId() {
        return parentId;
    }

    /**
     * <p>
     * Details about an execution that started.
     * </p>
     * 
     * @return Details about an execution that started.
     */
    public final ExecutionStartedDetails executionStartedDetails() {
        return executionStartedDetails;
    }

    /**
     * <p>
     * Details about an execution that succeeded.
     * </p>
     * 
     * @return Details about an execution that succeeded.
     */
    public final ExecutionSucceededDetails executionSucceededDetails() {
        return executionSucceededDetails;
    }

    /**
     * <p>
     * Details about an execution that failed.
     * </p>
     * 
     * @return Details about an execution that failed.
     */
    public final ExecutionFailedDetails executionFailedDetails() {
        return executionFailedDetails;
    }

    /**
     * <p>
     * Details about an execution that timed out.
     * </p>
     * 
     * @return Details about an execution that timed out.
     */
    public final ExecutionTimedOutDetails executionTimedOutDetails() {
        return executionTimedOutDetails;
    }

    /**
     * <p>
     * Details about an execution that was stopped.
     * </p>
     * 
     * @return Details about an execution that was stopped.
     */
    public final ExecutionStoppedDetails executionStoppedDetails() {
        return executionStoppedDetails;
    }

    /**
     * <p>
     * Details about a context that started.
     * </p>
     * 
     * @return Details about a context that started.
     */
    public final ContextStartedDetails contextStartedDetails() {
        return contextStartedDetails;
    }

    /**
     * <p>
     * Details about a context that succeeded.
     * </p>
     * 
     * @return Details about a context that succeeded.
     */
    public final ContextSucceededDetails contextSucceededDetails() {
        return contextSucceededDetails;
    }

    /**
     * <p>
     * Details about a context that failed.
     * </p>
     * 
     * @return Details about a context that failed.
     */
    public final ContextFailedDetails contextFailedDetails() {
        return contextFailedDetails;
    }

    /**
     * <p>
     * Details about a wait operation that started.
     * </p>
     * 
     * @return Details about a wait operation that started.
     */
    public final WaitStartedDetails waitStartedDetails() {
        return waitStartedDetails;
    }

    /**
     * <p>
     * Details about a wait operation that succeeded.
     * </p>
     * 
     * @return Details about a wait operation that succeeded.
     */
    public final WaitSucceededDetails waitSucceededDetails() {
        return waitSucceededDetails;
    }

    /**
     * <p>
     * Details about a wait operation that was cancelled.
     * </p>
     * 
     * @return Details about a wait operation that was cancelled.
     */
    public final WaitCancelledDetails waitCancelledDetails() {
        return waitCancelledDetails;
    }

    /**
     * <p>
     * Details about a step that started.
     * </p>
     * 
     * @return Details about a step that started.
     */
    public final StepStartedDetails stepStartedDetails() {
        return stepStartedDetails;
    }

    /**
     * <p>
     * Details about a step that succeeded.
     * </p>
     * 
     * @return Details about a step that succeeded.
     */
    public final StepSucceededDetails stepSucceededDetails() {
        return stepSucceededDetails;
    }

    /**
     * <p>
     * Details about a step that failed.
     * </p>
     * 
     * @return Details about a step that failed.
     */
    public final StepFailedDetails stepFailedDetails() {
        return stepFailedDetails;
    }

    /**
     * Returns the value of the ChainedInvokeStartedDetails property for this object.
     * 
     * @return The value of the ChainedInvokeStartedDetails property for this object.
     */
    public final ChainedInvokeStartedDetails chainedInvokeStartedDetails() {
        return chainedInvokeStartedDetails;
    }

    /**
     * <p>
     * Details about a chained invocation that succeeded.
     * </p>
     * 
     * @return Details about a chained invocation that succeeded.
     */
    public final ChainedInvokeSucceededDetails chainedInvokeSucceededDetails() {
        return chainedInvokeSucceededDetails;
    }

    /**
     * Returns the value of the ChainedInvokeFailedDetails property for this object.
     * 
     * @return The value of the ChainedInvokeFailedDetails property for this object.
     */
    public final ChainedInvokeFailedDetails chainedInvokeFailedDetails() {
        return chainedInvokeFailedDetails;
    }

    /**
     * <p>
     * Details about a chained invocation that timed out.
     * </p>
     * 
     * @return Details about a chained invocation that timed out.
     */
    public final ChainedInvokeTimedOutDetails chainedInvokeTimedOutDetails() {
        return chainedInvokeTimedOutDetails;
    }

    /**
     * <p>
     * Details about a chained invocation that was stopped.
     * </p>
     * 
     * @return Details about a chained invocation that was stopped.
     */
    public final ChainedInvokeStoppedDetails chainedInvokeStoppedDetails() {
        return chainedInvokeStoppedDetails;
    }

    /**
     * Returns the value of the CallbackStartedDetails property for this object.
     * 
     * @return The value of the CallbackStartedDetails property for this object.
     */
    public final CallbackStartedDetails callbackStartedDetails() {
        return callbackStartedDetails;
    }

    /**
     * Returns the value of the CallbackSucceededDetails property for this object.
     * 
     * @return The value of the CallbackSucceededDetails property for this object.
     */
    public final CallbackSucceededDetails callbackSucceededDetails() {
        return callbackSucceededDetails;
    }

    /**
     * Returns the value of the CallbackFailedDetails property for this object.
     * 
     * @return The value of the CallbackFailedDetails property for this object.
     */
    public final CallbackFailedDetails callbackFailedDetails() {
        return callbackFailedDetails;
    }

    /**
     * Returns the value of the CallbackTimedOutDetails property for this object.
     * 
     * @return The value of the CallbackTimedOutDetails property for this object.
     */
    public final CallbackTimedOutDetails callbackTimedOutDetails() {
        return callbackTimedOutDetails;
    }

    /**
     * <p>
     * Details about a function invocation that completed.
     * </p>
     * 
     * @return Details about a function invocation that completed.
     */
    public final InvocationCompletedDetails invocationCompletedDetails() {
        return invocationCompletedDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subType());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(parentId());
        hashCode = 31 * hashCode + Objects.hashCode(executionStartedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(executionSucceededDetails());
        hashCode = 31 * hashCode + Objects.hashCode(executionFailedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(executionTimedOutDetails());
        hashCode = 31 * hashCode + Objects.hashCode(executionStoppedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(contextStartedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(contextSucceededDetails());
        hashCode = 31 * hashCode + Objects.hashCode(contextFailedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(waitStartedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(waitSucceededDetails());
        hashCode = 31 * hashCode + Objects.hashCode(waitCancelledDetails());
        hashCode = 31 * hashCode + Objects.hashCode(stepStartedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(stepSucceededDetails());
        hashCode = 31 * hashCode + Objects.hashCode(stepFailedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(chainedInvokeStartedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(chainedInvokeSucceededDetails());
        hashCode = 31 * hashCode + Objects.hashCode(chainedInvokeFailedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(chainedInvokeTimedOutDetails());
        hashCode = 31 * hashCode + Objects.hashCode(chainedInvokeStoppedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(callbackStartedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(callbackSucceededDetails());
        hashCode = 31 * hashCode + Objects.hashCode(callbackFailedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(callbackTimedOutDetails());
        hashCode = 31 * hashCode + Objects.hashCode(invocationCompletedDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event) obj;
        return Objects.equals(eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(subType(), other.subType())
                && Objects.equals(eventId(), other.eventId()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(eventTimestamp(), other.eventTimestamp())
                && Objects.equals(parentId(), other.parentId())
                && Objects.equals(executionStartedDetails(), other.executionStartedDetails())
                && Objects.equals(executionSucceededDetails(), other.executionSucceededDetails())
                && Objects.equals(executionFailedDetails(), other.executionFailedDetails())
                && Objects.equals(executionTimedOutDetails(), other.executionTimedOutDetails())
                && Objects.equals(executionStoppedDetails(), other.executionStoppedDetails())
                && Objects.equals(contextStartedDetails(), other.contextStartedDetails())
                && Objects.equals(contextSucceededDetails(), other.contextSucceededDetails())
                && Objects.equals(contextFailedDetails(), other.contextFailedDetails())
                && Objects.equals(waitStartedDetails(), other.waitStartedDetails())
                && Objects.equals(waitSucceededDetails(), other.waitSucceededDetails())
                && Objects.equals(waitCancelledDetails(), other.waitCancelledDetails())
                && Objects.equals(stepStartedDetails(), other.stepStartedDetails())
                && Objects.equals(stepSucceededDetails(), other.stepSucceededDetails())
                && Objects.equals(stepFailedDetails(), other.stepFailedDetails())
                && Objects.equals(chainedInvokeStartedDetails(), other.chainedInvokeStartedDetails())
                && Objects.equals(chainedInvokeSucceededDetails(), other.chainedInvokeSucceededDetails())
                && Objects.equals(chainedInvokeFailedDetails(), other.chainedInvokeFailedDetails())
                && Objects.equals(chainedInvokeTimedOutDetails(), other.chainedInvokeTimedOutDetails())
                && Objects.equals(chainedInvokeStoppedDetails(), other.chainedInvokeStoppedDetails())
                && Objects.equals(callbackStartedDetails(), other.callbackStartedDetails())
                && Objects.equals(callbackSucceededDetails(), other.callbackSucceededDetails())
                && Objects.equals(callbackFailedDetails(), other.callbackFailedDetails())
                && Objects.equals(callbackTimedOutDetails(), other.callbackTimedOutDetails())
                && Objects.equals(invocationCompletedDetails(), other.invocationCompletedDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Event").add("EventType", eventTypeAsString()).add("SubType", subType())
                .add("EventId", eventId()).add("Id", id()).add("Name", name()).add("EventTimestamp", eventTimestamp())
                .add("ParentId", parentId()).add("ExecutionStartedDetails", executionStartedDetails())
                .add("ExecutionSucceededDetails", executionSucceededDetails())
                .add("ExecutionFailedDetails", executionFailedDetails())
                .add("ExecutionTimedOutDetails", executionTimedOutDetails())
                .add("ExecutionStoppedDetails", executionStoppedDetails()).add("ContextStartedDetails", contextStartedDetails())
                .add("ContextSucceededDetails", contextSucceededDetails()).add("ContextFailedDetails", contextFailedDetails())
                .add("WaitStartedDetails", waitStartedDetails()).add("WaitSucceededDetails", waitSucceededDetails())
                .add("WaitCancelledDetails", waitCancelledDetails()).add("StepStartedDetails", stepStartedDetails())
                .add("StepSucceededDetails", stepSucceededDetails()).add("StepFailedDetails", stepFailedDetails())
                .add("ChainedInvokeStartedDetails", chainedInvokeStartedDetails())
                .add("ChainedInvokeSucceededDetails", chainedInvokeSucceededDetails())
                .add("ChainedInvokeFailedDetails", chainedInvokeFailedDetails())
                .add("ChainedInvokeTimedOutDetails", chainedInvokeTimedOutDetails())
                .add("ChainedInvokeStoppedDetails", chainedInvokeStoppedDetails())
                .add("CallbackStartedDetails", callbackStartedDetails())
                .add("CallbackSucceededDetails", callbackSucceededDetails())
                .add("CallbackFailedDetails", callbackFailedDetails()).add("CallbackTimedOutDetails", callbackTimedOutDetails())
                .add("InvocationCompletedDetails", invocationCompletedDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "SubType":
            return Optional.ofNullable(clazz.cast(subType()));
        case "EventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "EventTimestamp":
            return Optional.ofNullable(clazz.cast(eventTimestamp()));
        case "ParentId":
            return Optional.ofNullable(clazz.cast(parentId()));
        case "ExecutionStartedDetails":
            return Optional.ofNullable(clazz.cast(executionStartedDetails()));
        case "ExecutionSucceededDetails":
            return Optional.ofNullable(clazz.cast(executionSucceededDetails()));
        case "ExecutionFailedDetails":
            return Optional.ofNullable(clazz.cast(executionFailedDetails()));
        case "ExecutionTimedOutDetails":
            return Optional.ofNullable(clazz.cast(executionTimedOutDetails()));
        case "ExecutionStoppedDetails":
            return Optional.ofNullable(clazz.cast(executionStoppedDetails()));
        case "ContextStartedDetails":
            return Optional.ofNullable(clazz.cast(contextStartedDetails()));
        case "ContextSucceededDetails":
            return Optional.ofNullable(clazz.cast(contextSucceededDetails()));
        case "ContextFailedDetails":
            return Optional.ofNullable(clazz.cast(contextFailedDetails()));
        case "WaitStartedDetails":
            return Optional.ofNullable(clazz.cast(waitStartedDetails()));
        case "WaitSucceededDetails":
            return Optional.ofNullable(clazz.cast(waitSucceededDetails()));
        case "WaitCancelledDetails":
            return Optional.ofNullable(clazz.cast(waitCancelledDetails()));
        case "StepStartedDetails":
            return Optional.ofNullable(clazz.cast(stepStartedDetails()));
        case "StepSucceededDetails":
            return Optional.ofNullable(clazz.cast(stepSucceededDetails()));
        case "StepFailedDetails":
            return Optional.ofNullable(clazz.cast(stepFailedDetails()));
        case "ChainedInvokeStartedDetails":
            return Optional.ofNullable(clazz.cast(chainedInvokeStartedDetails()));
        case "ChainedInvokeSucceededDetails":
            return Optional.ofNullable(clazz.cast(chainedInvokeSucceededDetails()));
        case "ChainedInvokeFailedDetails":
            return Optional.ofNullable(clazz.cast(chainedInvokeFailedDetails()));
        case "ChainedInvokeTimedOutDetails":
            return Optional.ofNullable(clazz.cast(chainedInvokeTimedOutDetails()));
        case "ChainedInvokeStoppedDetails":
            return Optional.ofNullable(clazz.cast(chainedInvokeStoppedDetails()));
        case "CallbackStartedDetails":
            return Optional.ofNullable(clazz.cast(callbackStartedDetails()));
        case "CallbackSucceededDetails":
            return Optional.ofNullable(clazz.cast(callbackSucceededDetails()));
        case "CallbackFailedDetails":
            return Optional.ofNullable(clazz.cast(callbackFailedDetails()));
        case "CallbackTimedOutDetails":
            return Optional.ofNullable(clazz.cast(callbackTimedOutDetails()));
        case "InvocationCompletedDetails":
            return Optional.ofNullable(clazz.cast(invocationCompletedDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventType", EVENT_TYPE_FIELD);
        map.put("SubType", SUB_TYPE_FIELD);
        map.put("EventId", EVENT_ID_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("EventTimestamp", EVENT_TIMESTAMP_FIELD);
        map.put("ParentId", PARENT_ID_FIELD);
        map.put("ExecutionStartedDetails", EXECUTION_STARTED_DETAILS_FIELD);
        map.put("ExecutionSucceededDetails", EXECUTION_SUCCEEDED_DETAILS_FIELD);
        map.put("ExecutionFailedDetails", EXECUTION_FAILED_DETAILS_FIELD);
        map.put("ExecutionTimedOutDetails", EXECUTION_TIMED_OUT_DETAILS_FIELD);
        map.put("ExecutionStoppedDetails", EXECUTION_STOPPED_DETAILS_FIELD);
        map.put("ContextStartedDetails", CONTEXT_STARTED_DETAILS_FIELD);
        map.put("ContextSucceededDetails", CONTEXT_SUCCEEDED_DETAILS_FIELD);
        map.put("ContextFailedDetails", CONTEXT_FAILED_DETAILS_FIELD);
        map.put("WaitStartedDetails", WAIT_STARTED_DETAILS_FIELD);
        map.put("WaitSucceededDetails", WAIT_SUCCEEDED_DETAILS_FIELD);
        map.put("WaitCancelledDetails", WAIT_CANCELLED_DETAILS_FIELD);
        map.put("StepStartedDetails", STEP_STARTED_DETAILS_FIELD);
        map.put("StepSucceededDetails", STEP_SUCCEEDED_DETAILS_FIELD);
        map.put("StepFailedDetails", STEP_FAILED_DETAILS_FIELD);
        map.put("ChainedInvokeStartedDetails", CHAINED_INVOKE_STARTED_DETAILS_FIELD);
        map.put("ChainedInvokeSucceededDetails", CHAINED_INVOKE_SUCCEEDED_DETAILS_FIELD);
        map.put("ChainedInvokeFailedDetails", CHAINED_INVOKE_FAILED_DETAILS_FIELD);
        map.put("ChainedInvokeTimedOutDetails", CHAINED_INVOKE_TIMED_OUT_DETAILS_FIELD);
        map.put("ChainedInvokeStoppedDetails", CHAINED_INVOKE_STOPPED_DETAILS_FIELD);
        map.put("CallbackStartedDetails", CALLBACK_STARTED_DETAILS_FIELD);
        map.put("CallbackSucceededDetails", CALLBACK_SUCCEEDED_DETAILS_FIELD);
        map.put("CallbackFailedDetails", CALLBACK_FAILED_DETAILS_FIELD);
        map.put("CallbackTimedOutDetails", CALLBACK_TIMED_OUT_DETAILS_FIELD);
        map.put("InvocationCompletedDetails", INVOCATION_COMPLETED_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Event> {
        /**
         * <p>
         * The type of event that occurred.
         * </p>
         * 
         * @param eventType
         *        The type of event that occurred.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The type of event that occurred.
         * </p>
         * 
         * @param eventType
         *        The type of event that occurred.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(EventType eventType);

        /**
         * <p>
         * The subtype of the event, providing additional categorization.
         * </p>
         * 
         * @param subType
         *        The subtype of the event, providing additional categorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subType(String subType);

        /**
         * <p>
         * The unique identifier for this event. Event IDs increment sequentially.
         * </p>
         * 
         * @param eventId
         *        The unique identifier for this event. Event IDs increment sequentially.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(Integer eventId);

        /**
         * <p>
         * The unique identifier for this operation.
         * </p>
         * 
         * @param id
         *        The unique identifier for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The customer-provided name for this operation.
         * </p>
         * 
         * @param name
         *        The customer-provided name for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The date and time when this event occurred, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
         * format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * </p>
         * 
         * @param eventTimestamp
         *        The date and time when this event occurred, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
         *        format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimestamp(Instant eventTimestamp);

        /**
         * <p>
         * The unique identifier of the parent operation, if this operation is running within a child context.
         * </p>
         * 
         * @param parentId
         *        The unique identifier of the parent operation, if this operation is running within a child context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentId(String parentId);

        /**
         * <p>
         * Details about an execution that started.
         * </p>
         * 
         * @param executionStartedDetails
         *        Details about an execution that started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartedDetails(ExecutionStartedDetails executionStartedDetails);

        /**
         * <p>
         * Details about an execution that started.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionStartedDetails.Builder} avoiding
         * the need to create one manually via {@link ExecutionStartedDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionStartedDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #executionStartedDetails(ExecutionStartedDetails)}.
         * 
         * @param executionStartedDetails
         *        a consumer that will call methods on {@link ExecutionStartedDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionStartedDetails(ExecutionStartedDetails)
         */
        default Builder executionStartedDetails(Consumer<ExecutionStartedDetails.Builder> executionStartedDetails) {
            return executionStartedDetails(ExecutionStartedDetails.builder().applyMutation(executionStartedDetails).build());
        }

        /**
         * <p>
         * Details about an execution that succeeded.
         * </p>
         * 
         * @param executionSucceededDetails
         *        Details about an execution that succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionSucceededDetails(ExecutionSucceededDetails executionSucceededDetails);

        /**
         * <p>
         * Details about an execution that succeeded.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionSucceededDetails.Builder}
         * avoiding the need to create one manually via {@link ExecutionSucceededDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionSucceededDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #executionSucceededDetails(ExecutionSucceededDetails)}.
         * 
         * @param executionSucceededDetails
         *        a consumer that will call methods on {@link ExecutionSucceededDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionSucceededDetails(ExecutionSucceededDetails)
         */
        default Builder executionSucceededDetails(Consumer<ExecutionSucceededDetails.Builder> executionSucceededDetails) {
            return executionSucceededDetails(ExecutionSucceededDetails.builder().applyMutation(executionSucceededDetails).build());
        }

        /**
         * <p>
         * Details about an execution that failed.
         * </p>
         * 
         * @param executionFailedDetails
         *        Details about an execution that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionFailedDetails(ExecutionFailedDetails executionFailedDetails);

        /**
         * <p>
         * Details about an execution that failed.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionFailedDetails.Builder} avoiding
         * the need to create one manually via {@link ExecutionFailedDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionFailedDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #executionFailedDetails(ExecutionFailedDetails)}.
         * 
         * @param executionFailedDetails
         *        a consumer that will call methods on {@link ExecutionFailedDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionFailedDetails(ExecutionFailedDetails)
         */
        default Builder executionFailedDetails(Consumer<ExecutionFailedDetails.Builder> executionFailedDetails) {
            return executionFailedDetails(ExecutionFailedDetails.builder().applyMutation(executionFailedDetails).build());
        }

        /**
         * <p>
         * Details about an execution that timed out.
         * </p>
         * 
         * @param executionTimedOutDetails
         *        Details about an execution that timed out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTimedOutDetails(ExecutionTimedOutDetails executionTimedOutDetails);

        /**
         * <p>
         * Details about an execution that timed out.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionTimedOutDetails.Builder}
         * avoiding the need to create one manually via {@link ExecutionTimedOutDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionTimedOutDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #executionTimedOutDetails(ExecutionTimedOutDetails)}.
         * 
         * @param executionTimedOutDetails
         *        a consumer that will call methods on {@link ExecutionTimedOutDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionTimedOutDetails(ExecutionTimedOutDetails)
         */
        default Builder executionTimedOutDetails(Consumer<ExecutionTimedOutDetails.Builder> executionTimedOutDetails) {
            return executionTimedOutDetails(ExecutionTimedOutDetails.builder().applyMutation(executionTimedOutDetails).build());
        }

        /**
         * <p>
         * Details about an execution that was stopped.
         * </p>
         * 
         * @param executionStoppedDetails
         *        Details about an execution that was stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStoppedDetails(ExecutionStoppedDetails executionStoppedDetails);

        /**
         * <p>
         * Details about an execution that was stopped.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionStoppedDetails.Builder} avoiding
         * the need to create one manually via {@link ExecutionStoppedDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionStoppedDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #executionStoppedDetails(ExecutionStoppedDetails)}.
         * 
         * @param executionStoppedDetails
         *        a consumer that will call methods on {@link ExecutionStoppedDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionStoppedDetails(ExecutionStoppedDetails)
         */
        default Builder executionStoppedDetails(Consumer<ExecutionStoppedDetails.Builder> executionStoppedDetails) {
            return executionStoppedDetails(ExecutionStoppedDetails.builder().applyMutation(executionStoppedDetails).build());
        }

        /**
         * <p>
         * Details about a context that started.
         * </p>
         * 
         * @param contextStartedDetails
         *        Details about a context that started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextStartedDetails(ContextStartedDetails contextStartedDetails);

        /**
         * <p>
         * Details about a context that started.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContextStartedDetails.Builder} avoiding
         * the need to create one manually via {@link ContextStartedDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContextStartedDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #contextStartedDetails(ContextStartedDetails)}.
         * 
         * @param contextStartedDetails
         *        a consumer that will call methods on {@link ContextStartedDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contextStartedDetails(ContextStartedDetails)
         */
        default Builder contextStartedDetails(Consumer<ContextStartedDetails.Builder> contextStartedDetails) {
            return contextStartedDetails(ContextStartedDetails.builder().applyMutation(contextStartedDetails).build());
        }

        /**
         * <p>
         * Details about a context that succeeded.
         * </p>
         * 
         * @param contextSucceededDetails
         *        Details about a context that succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextSucceededDetails(ContextSucceededDetails contextSucceededDetails);

        /**
         * <p>
         * Details about a context that succeeded.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContextSucceededDetails.Builder} avoiding
         * the need to create one manually via {@link ContextSucceededDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContextSucceededDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #contextSucceededDetails(ContextSucceededDetails)}.
         * 
         * @param contextSucceededDetails
         *        a consumer that will call methods on {@link ContextSucceededDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contextSucceededDetails(ContextSucceededDetails)
         */
        default Builder contextSucceededDetails(Consumer<ContextSucceededDetails.Builder> contextSucceededDetails) {
            return contextSucceededDetails(ContextSucceededDetails.builder().applyMutation(contextSucceededDetails).build());
        }

        /**
         * <p>
         * Details about a context that failed.
         * </p>
         * 
         * @param contextFailedDetails
         *        Details about a context that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextFailedDetails(ContextFailedDetails contextFailedDetails);

        /**
         * <p>
         * Details about a context that failed.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContextFailedDetails.Builder} avoiding
         * the need to create one manually via {@link ContextFailedDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContextFailedDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #contextFailedDetails(ContextFailedDetails)}.
         * 
         * @param contextFailedDetails
         *        a consumer that will call methods on {@link ContextFailedDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contextFailedDetails(ContextFailedDetails)
         */
        default Builder contextFailedDetails(Consumer<ContextFailedDetails.Builder> contextFailedDetails) {
            return contextFailedDetails(ContextFailedDetails.builder().applyMutation(contextFailedDetails).build());
        }

        /**
         * <p>
         * Details about a wait operation that started.
         * </p>
         * 
         * @param waitStartedDetails
         *        Details about a wait operation that started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitStartedDetails(WaitStartedDetails waitStartedDetails);

        /**
         * <p>
         * Details about a wait operation that started.
         * </p>
         * This is a convenience method that creates an instance of the {@link WaitStartedDetails.Builder} avoiding the
         * need to create one manually via {@link WaitStartedDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaitStartedDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #waitStartedDetails(WaitStartedDetails)}.
         * 
         * @param waitStartedDetails
         *        a consumer that will call methods on {@link WaitStartedDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #waitStartedDetails(WaitStartedDetails)
         */
        default Builder waitStartedDetails(Consumer<WaitStartedDetails.Builder> waitStartedDetails) {
            return waitStartedDetails(WaitStartedDetails.builder().applyMutation(waitStartedDetails).build());
        }

        /**
         * <p>
         * Details about a wait operation that succeeded.
         * </p>
         * 
         * @param waitSucceededDetails
         *        Details about a wait operation that succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitSucceededDetails(WaitSucceededDetails waitSucceededDetails);

        /**
         * <p>
         * Details about a wait operation that succeeded.
         * </p>
         * This is a convenience method that creates an instance of the {@link WaitSucceededDetails.Builder} avoiding
         * the need to create one manually via {@link WaitSucceededDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaitSucceededDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #waitSucceededDetails(WaitSucceededDetails)}.
         * 
         * @param waitSucceededDetails
         *        a consumer that will call methods on {@link WaitSucceededDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #waitSucceededDetails(WaitSucceededDetails)
         */
        default Builder waitSucceededDetails(Consumer<WaitSucceededDetails.Builder> waitSucceededDetails) {
            return waitSucceededDetails(WaitSucceededDetails.builder().applyMutation(waitSucceededDetails).build());
        }

        /**
         * <p>
         * Details about a wait operation that was cancelled.
         * </p>
         * 
         * @param waitCancelledDetails
         *        Details about a wait operation that was cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitCancelledDetails(WaitCancelledDetails waitCancelledDetails);

        /**
         * <p>
         * Details about a wait operation that was cancelled.
         * </p>
         * This is a convenience method that creates an instance of the {@link WaitCancelledDetails.Builder} avoiding
         * the need to create one manually via {@link WaitCancelledDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaitCancelledDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #waitCancelledDetails(WaitCancelledDetails)}.
         * 
         * @param waitCancelledDetails
         *        a consumer that will call methods on {@link WaitCancelledDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #waitCancelledDetails(WaitCancelledDetails)
         */
        default Builder waitCancelledDetails(Consumer<WaitCancelledDetails.Builder> waitCancelledDetails) {
            return waitCancelledDetails(WaitCancelledDetails.builder().applyMutation(waitCancelledDetails).build());
        }

        /**
         * <p>
         * Details about a step that started.
         * </p>
         * 
         * @param stepStartedDetails
         *        Details about a step that started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepStartedDetails(StepStartedDetails stepStartedDetails);

        /**
         * <p>
         * Details about a step that started.
         * </p>
         * This is a convenience method that creates an instance of the {@link StepStartedDetails.Builder} avoiding the
         * need to create one manually via {@link StepStartedDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StepStartedDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #stepStartedDetails(StepStartedDetails)}.
         * 
         * @param stepStartedDetails
         *        a consumer that will call methods on {@link StepStartedDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepStartedDetails(StepStartedDetails)
         */
        default Builder stepStartedDetails(Consumer<StepStartedDetails.Builder> stepStartedDetails) {
            return stepStartedDetails(StepStartedDetails.builder().applyMutation(stepStartedDetails).build());
        }

        /**
         * <p>
         * Details about a step that succeeded.
         * </p>
         * 
         * @param stepSucceededDetails
         *        Details about a step that succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepSucceededDetails(StepSucceededDetails stepSucceededDetails);

        /**
         * <p>
         * Details about a step that succeeded.
         * </p>
         * This is a convenience method that creates an instance of the {@link StepSucceededDetails.Builder} avoiding
         * the need to create one manually via {@link StepSucceededDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StepSucceededDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #stepSucceededDetails(StepSucceededDetails)}.
         * 
         * @param stepSucceededDetails
         *        a consumer that will call methods on {@link StepSucceededDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepSucceededDetails(StepSucceededDetails)
         */
        default Builder stepSucceededDetails(Consumer<StepSucceededDetails.Builder> stepSucceededDetails) {
            return stepSucceededDetails(StepSucceededDetails.builder().applyMutation(stepSucceededDetails).build());
        }

        /**
         * <p>
         * Details about a step that failed.
         * </p>
         * 
         * @param stepFailedDetails
         *        Details about a step that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepFailedDetails(StepFailedDetails stepFailedDetails);

        /**
         * <p>
         * Details about a step that failed.
         * </p>
         * This is a convenience method that creates an instance of the {@link StepFailedDetails.Builder} avoiding the
         * need to create one manually via {@link StepFailedDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StepFailedDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #stepFailedDetails(StepFailedDetails)}.
         * 
         * @param stepFailedDetails
         *        a consumer that will call methods on {@link StepFailedDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepFailedDetails(StepFailedDetails)
         */
        default Builder stepFailedDetails(Consumer<StepFailedDetails.Builder> stepFailedDetails) {
            return stepFailedDetails(StepFailedDetails.builder().applyMutation(stepFailedDetails).build());
        }

        /**
         * Sets the value of the ChainedInvokeStartedDetails property for this object.
         *
         * @param chainedInvokeStartedDetails
         *        The new value for the ChainedInvokeStartedDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chainedInvokeStartedDetails(ChainedInvokeStartedDetails chainedInvokeStartedDetails);

        /**
         * Sets the value of the ChainedInvokeStartedDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ChainedInvokeStartedDetails.Builder}
         * avoiding the need to create one manually via {@link ChainedInvokeStartedDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChainedInvokeStartedDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #chainedInvokeStartedDetails(ChainedInvokeStartedDetails)}.
         * 
         * @param chainedInvokeStartedDetails
         *        a consumer that will call methods on {@link ChainedInvokeStartedDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chainedInvokeStartedDetails(ChainedInvokeStartedDetails)
         */
        default Builder chainedInvokeStartedDetails(Consumer<ChainedInvokeStartedDetails.Builder> chainedInvokeStartedDetails) {
            return chainedInvokeStartedDetails(ChainedInvokeStartedDetails.builder().applyMutation(chainedInvokeStartedDetails)
                    .build());
        }

        /**
         * <p>
         * Details about a chained invocation that succeeded.
         * </p>
         * 
         * @param chainedInvokeSucceededDetails
         *        Details about a chained invocation that succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chainedInvokeSucceededDetails(ChainedInvokeSucceededDetails chainedInvokeSucceededDetails);

        /**
         * <p>
         * Details about a chained invocation that succeeded.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChainedInvokeSucceededDetails.Builder}
         * avoiding the need to create one manually via {@link ChainedInvokeSucceededDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChainedInvokeSucceededDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #chainedInvokeSucceededDetails(ChainedInvokeSucceededDetails)}.
         * 
         * @param chainedInvokeSucceededDetails
         *        a consumer that will call methods on {@link ChainedInvokeSucceededDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chainedInvokeSucceededDetails(ChainedInvokeSucceededDetails)
         */
        default Builder chainedInvokeSucceededDetails(
                Consumer<ChainedInvokeSucceededDetails.Builder> chainedInvokeSucceededDetails) {
            return chainedInvokeSucceededDetails(ChainedInvokeSucceededDetails.builder()
                    .applyMutation(chainedInvokeSucceededDetails).build());
        }

        /**
         * Sets the value of the ChainedInvokeFailedDetails property for this object.
         *
         * @param chainedInvokeFailedDetails
         *        The new value for the ChainedInvokeFailedDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chainedInvokeFailedDetails(ChainedInvokeFailedDetails chainedInvokeFailedDetails);

        /**
         * Sets the value of the ChainedInvokeFailedDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ChainedInvokeFailedDetails.Builder}
         * avoiding the need to create one manually via {@link ChainedInvokeFailedDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChainedInvokeFailedDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #chainedInvokeFailedDetails(ChainedInvokeFailedDetails)}.
         * 
         * @param chainedInvokeFailedDetails
         *        a consumer that will call methods on {@link ChainedInvokeFailedDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chainedInvokeFailedDetails(ChainedInvokeFailedDetails)
         */
        default Builder chainedInvokeFailedDetails(Consumer<ChainedInvokeFailedDetails.Builder> chainedInvokeFailedDetails) {
            return chainedInvokeFailedDetails(ChainedInvokeFailedDetails.builder().applyMutation(chainedInvokeFailedDetails)
                    .build());
        }

        /**
         * <p>
         * Details about a chained invocation that timed out.
         * </p>
         * 
         * @param chainedInvokeTimedOutDetails
         *        Details about a chained invocation that timed out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chainedInvokeTimedOutDetails(ChainedInvokeTimedOutDetails chainedInvokeTimedOutDetails);

        /**
         * <p>
         * Details about a chained invocation that timed out.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChainedInvokeTimedOutDetails.Builder}
         * avoiding the need to create one manually via {@link ChainedInvokeTimedOutDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChainedInvokeTimedOutDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #chainedInvokeTimedOutDetails(ChainedInvokeTimedOutDetails)}.
         * 
         * @param chainedInvokeTimedOutDetails
         *        a consumer that will call methods on {@link ChainedInvokeTimedOutDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chainedInvokeTimedOutDetails(ChainedInvokeTimedOutDetails)
         */
        default Builder chainedInvokeTimedOutDetails(Consumer<ChainedInvokeTimedOutDetails.Builder> chainedInvokeTimedOutDetails) {
            return chainedInvokeTimedOutDetails(ChainedInvokeTimedOutDetails.builder()
                    .applyMutation(chainedInvokeTimedOutDetails).build());
        }

        /**
         * <p>
         * Details about a chained invocation that was stopped.
         * </p>
         * 
         * @param chainedInvokeStoppedDetails
         *        Details about a chained invocation that was stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chainedInvokeStoppedDetails(ChainedInvokeStoppedDetails chainedInvokeStoppedDetails);

        /**
         * <p>
         * Details about a chained invocation that was stopped.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChainedInvokeStoppedDetails.Builder}
         * avoiding the need to create one manually via {@link ChainedInvokeStoppedDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChainedInvokeStoppedDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #chainedInvokeStoppedDetails(ChainedInvokeStoppedDetails)}.
         * 
         * @param chainedInvokeStoppedDetails
         *        a consumer that will call methods on {@link ChainedInvokeStoppedDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chainedInvokeStoppedDetails(ChainedInvokeStoppedDetails)
         */
        default Builder chainedInvokeStoppedDetails(Consumer<ChainedInvokeStoppedDetails.Builder> chainedInvokeStoppedDetails) {
            return chainedInvokeStoppedDetails(ChainedInvokeStoppedDetails.builder().applyMutation(chainedInvokeStoppedDetails)
                    .build());
        }

        /**
         * Sets the value of the CallbackStartedDetails property for this object.
         *
         * @param callbackStartedDetails
         *        The new value for the CallbackStartedDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackStartedDetails(CallbackStartedDetails callbackStartedDetails);

        /**
         * Sets the value of the CallbackStartedDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CallbackStartedDetails.Builder} avoiding
         * the need to create one manually via {@link CallbackStartedDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CallbackStartedDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #callbackStartedDetails(CallbackStartedDetails)}.
         * 
         * @param callbackStartedDetails
         *        a consumer that will call methods on {@link CallbackStartedDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #callbackStartedDetails(CallbackStartedDetails)
         */
        default Builder callbackStartedDetails(Consumer<CallbackStartedDetails.Builder> callbackStartedDetails) {
            return callbackStartedDetails(CallbackStartedDetails.builder().applyMutation(callbackStartedDetails).build());
        }

        /**
         * Sets the value of the CallbackSucceededDetails property for this object.
         *
         * @param callbackSucceededDetails
         *        The new value for the CallbackSucceededDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackSucceededDetails(CallbackSucceededDetails callbackSucceededDetails);

        /**
         * Sets the value of the CallbackSucceededDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CallbackSucceededDetails.Builder}
         * avoiding the need to create one manually via {@link CallbackSucceededDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CallbackSucceededDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #callbackSucceededDetails(CallbackSucceededDetails)}.
         * 
         * @param callbackSucceededDetails
         *        a consumer that will call methods on {@link CallbackSucceededDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #callbackSucceededDetails(CallbackSucceededDetails)
         */
        default Builder callbackSucceededDetails(Consumer<CallbackSucceededDetails.Builder> callbackSucceededDetails) {
            return callbackSucceededDetails(CallbackSucceededDetails.builder().applyMutation(callbackSucceededDetails).build());
        }

        /**
         * Sets the value of the CallbackFailedDetails property for this object.
         *
         * @param callbackFailedDetails
         *        The new value for the CallbackFailedDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackFailedDetails(CallbackFailedDetails callbackFailedDetails);

        /**
         * Sets the value of the CallbackFailedDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CallbackFailedDetails.Builder} avoiding
         * the need to create one manually via {@link CallbackFailedDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CallbackFailedDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #callbackFailedDetails(CallbackFailedDetails)}.
         * 
         * @param callbackFailedDetails
         *        a consumer that will call methods on {@link CallbackFailedDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #callbackFailedDetails(CallbackFailedDetails)
         */
        default Builder callbackFailedDetails(Consumer<CallbackFailedDetails.Builder> callbackFailedDetails) {
            return callbackFailedDetails(CallbackFailedDetails.builder().applyMutation(callbackFailedDetails).build());
        }

        /**
         * Sets the value of the CallbackTimedOutDetails property for this object.
         *
         * @param callbackTimedOutDetails
         *        The new value for the CallbackTimedOutDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackTimedOutDetails(CallbackTimedOutDetails callbackTimedOutDetails);

        /**
         * Sets the value of the CallbackTimedOutDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CallbackTimedOutDetails.Builder} avoiding
         * the need to create one manually via {@link CallbackTimedOutDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CallbackTimedOutDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #callbackTimedOutDetails(CallbackTimedOutDetails)}.
         * 
         * @param callbackTimedOutDetails
         *        a consumer that will call methods on {@link CallbackTimedOutDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #callbackTimedOutDetails(CallbackTimedOutDetails)
         */
        default Builder callbackTimedOutDetails(Consumer<CallbackTimedOutDetails.Builder> callbackTimedOutDetails) {
            return callbackTimedOutDetails(CallbackTimedOutDetails.builder().applyMutation(callbackTimedOutDetails).build());
        }

        /**
         * <p>
         * Details about a function invocation that completed.
         * </p>
         * 
         * @param invocationCompletedDetails
         *        Details about a function invocation that completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationCompletedDetails(InvocationCompletedDetails invocationCompletedDetails);

        /**
         * <p>
         * Details about a function invocation that completed.
         * </p>
         * This is a convenience method that creates an instance of the {@link InvocationCompletedDetails.Builder}
         * avoiding the need to create one manually via {@link InvocationCompletedDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvocationCompletedDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #invocationCompletedDetails(InvocationCompletedDetails)}.
         * 
         * @param invocationCompletedDetails
         *        a consumer that will call methods on {@link InvocationCompletedDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invocationCompletedDetails(InvocationCompletedDetails)
         */
        default Builder invocationCompletedDetails(Consumer<InvocationCompletedDetails.Builder> invocationCompletedDetails) {
            return invocationCompletedDetails(InvocationCompletedDetails.builder().applyMutation(invocationCompletedDetails)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String eventType;

        private String subType;

        private Integer eventId;

        private String id;

        private String name;

        private Instant eventTimestamp;

        private String parentId;

        private ExecutionStartedDetails executionStartedDetails;

        private ExecutionSucceededDetails executionSucceededDetails;

        private ExecutionFailedDetails executionFailedDetails;

        private ExecutionTimedOutDetails executionTimedOutDetails;

        private ExecutionStoppedDetails executionStoppedDetails;

        private ContextStartedDetails contextStartedDetails;

        private ContextSucceededDetails contextSucceededDetails;

        private ContextFailedDetails contextFailedDetails;

        private WaitStartedDetails waitStartedDetails;

        private WaitSucceededDetails waitSucceededDetails;

        private WaitCancelledDetails waitCancelledDetails;

        private StepStartedDetails stepStartedDetails;

        private StepSucceededDetails stepSucceededDetails;

        private StepFailedDetails stepFailedDetails;

        private ChainedInvokeStartedDetails chainedInvokeStartedDetails;

        private ChainedInvokeSucceededDetails chainedInvokeSucceededDetails;

        private ChainedInvokeFailedDetails chainedInvokeFailedDetails;

        private ChainedInvokeTimedOutDetails chainedInvokeTimedOutDetails;

        private ChainedInvokeStoppedDetails chainedInvokeStoppedDetails;

        private CallbackStartedDetails callbackStartedDetails;

        private CallbackSucceededDetails callbackSucceededDetails;

        private CallbackFailedDetails callbackFailedDetails;

        private CallbackTimedOutDetails callbackTimedOutDetails;

        private InvocationCompletedDetails invocationCompletedDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            eventType(model.eventType);
            subType(model.subType);
            eventId(model.eventId);
            id(model.id);
            name(model.name);
            eventTimestamp(model.eventTimestamp);
            parentId(model.parentId);
            executionStartedDetails(model.executionStartedDetails);
            executionSucceededDetails(model.executionSucceededDetails);
            executionFailedDetails(model.executionFailedDetails);
            executionTimedOutDetails(model.executionTimedOutDetails);
            executionStoppedDetails(model.executionStoppedDetails);
            contextStartedDetails(model.contextStartedDetails);
            contextSucceededDetails(model.contextSucceededDetails);
            contextFailedDetails(model.contextFailedDetails);
            waitStartedDetails(model.waitStartedDetails);
            waitSucceededDetails(model.waitSucceededDetails);
            waitCancelledDetails(model.waitCancelledDetails);
            stepStartedDetails(model.stepStartedDetails);
            stepSucceededDetails(model.stepSucceededDetails);
            stepFailedDetails(model.stepFailedDetails);
            chainedInvokeStartedDetails(model.chainedInvokeStartedDetails);
            chainedInvokeSucceededDetails(model.chainedInvokeSucceededDetails);
            chainedInvokeFailedDetails(model.chainedInvokeFailedDetails);
            chainedInvokeTimedOutDetails(model.chainedInvokeTimedOutDetails);
            chainedInvokeStoppedDetails(model.chainedInvokeStoppedDetails);
            callbackStartedDetails(model.callbackStartedDetails);
            callbackSucceededDetails(model.callbackSucceededDetails);
            callbackFailedDetails(model.callbackFailedDetails);
            callbackTimedOutDetails(model.callbackTimedOutDetails);
            invocationCompletedDetails(model.invocationCompletedDetails);
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getSubType() {
            return subType;
        }

        public final void setSubType(String subType) {
            this.subType = subType;
        }

        @Override
        public final Builder subType(String subType) {
            this.subType = subType;
            return this;
        }

        public final Integer getEventId() {
            return eventId;
        }

        public final void setEventId(Integer eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(Integer eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getEventTimestamp() {
            return eventTimestamp;
        }

        public final void setEventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public final Builder eventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final String getParentId() {
            return parentId;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final ExecutionStartedDetails.Builder getExecutionStartedDetails() {
            return executionStartedDetails != null ? executionStartedDetails.toBuilder() : null;
        }

        public final void setExecutionStartedDetails(ExecutionStartedDetails.BuilderImpl executionStartedDetails) {
            this.executionStartedDetails = executionStartedDetails != null ? executionStartedDetails.build() : null;
        }

        @Override
        public final Builder executionStartedDetails(ExecutionStartedDetails executionStartedDetails) {
            this.executionStartedDetails = executionStartedDetails;
            return this;
        }

        public final ExecutionSucceededDetails.Builder getExecutionSucceededDetails() {
            return executionSucceededDetails != null ? executionSucceededDetails.toBuilder() : null;
        }

        public final void setExecutionSucceededDetails(ExecutionSucceededDetails.BuilderImpl executionSucceededDetails) {
            this.executionSucceededDetails = executionSucceededDetails != null ? executionSucceededDetails.build() : null;
        }

        @Override
        public final Builder executionSucceededDetails(ExecutionSucceededDetails executionSucceededDetails) {
            this.executionSucceededDetails = executionSucceededDetails;
            return this;
        }

        public final ExecutionFailedDetails.Builder getExecutionFailedDetails() {
            return executionFailedDetails != null ? executionFailedDetails.toBuilder() : null;
        }

        public final void setExecutionFailedDetails(ExecutionFailedDetails.BuilderImpl executionFailedDetails) {
            this.executionFailedDetails = executionFailedDetails != null ? executionFailedDetails.build() : null;
        }

        @Override
        public final Builder executionFailedDetails(ExecutionFailedDetails executionFailedDetails) {
            this.executionFailedDetails = executionFailedDetails;
            return this;
        }

        public final ExecutionTimedOutDetails.Builder getExecutionTimedOutDetails() {
            return executionTimedOutDetails != null ? executionTimedOutDetails.toBuilder() : null;
        }

        public final void setExecutionTimedOutDetails(ExecutionTimedOutDetails.BuilderImpl executionTimedOutDetails) {
            this.executionTimedOutDetails = executionTimedOutDetails != null ? executionTimedOutDetails.build() : null;
        }

        @Override
        public final Builder executionTimedOutDetails(ExecutionTimedOutDetails executionTimedOutDetails) {
            this.executionTimedOutDetails = executionTimedOutDetails;
            return this;
        }

        public final ExecutionStoppedDetails.Builder getExecutionStoppedDetails() {
            return executionStoppedDetails != null ? executionStoppedDetails.toBuilder() : null;
        }

        public final void setExecutionStoppedDetails(ExecutionStoppedDetails.BuilderImpl executionStoppedDetails) {
            this.executionStoppedDetails = executionStoppedDetails != null ? executionStoppedDetails.build() : null;
        }

        @Override
        public final Builder executionStoppedDetails(ExecutionStoppedDetails executionStoppedDetails) {
            this.executionStoppedDetails = executionStoppedDetails;
            return this;
        }

        public final ContextStartedDetails.Builder getContextStartedDetails() {
            return contextStartedDetails != null ? contextStartedDetails.toBuilder() : null;
        }

        public final void setContextStartedDetails(ContextStartedDetails.BuilderImpl contextStartedDetails) {
            this.contextStartedDetails = contextStartedDetails != null ? contextStartedDetails.build() : null;
        }

        @Override
        public final Builder contextStartedDetails(ContextStartedDetails contextStartedDetails) {
            this.contextStartedDetails = contextStartedDetails;
            return this;
        }

        public final ContextSucceededDetails.Builder getContextSucceededDetails() {
            return contextSucceededDetails != null ? contextSucceededDetails.toBuilder() : null;
        }

        public final void setContextSucceededDetails(ContextSucceededDetails.BuilderImpl contextSucceededDetails) {
            this.contextSucceededDetails = contextSucceededDetails != null ? contextSucceededDetails.build() : null;
        }

        @Override
        public final Builder contextSucceededDetails(ContextSucceededDetails contextSucceededDetails) {
            this.contextSucceededDetails = contextSucceededDetails;
            return this;
        }

        public final ContextFailedDetails.Builder getContextFailedDetails() {
            return contextFailedDetails != null ? contextFailedDetails.toBuilder() : null;
        }

        public final void setContextFailedDetails(ContextFailedDetails.BuilderImpl contextFailedDetails) {
            this.contextFailedDetails = contextFailedDetails != null ? contextFailedDetails.build() : null;
        }

        @Override
        public final Builder contextFailedDetails(ContextFailedDetails contextFailedDetails) {
            this.contextFailedDetails = contextFailedDetails;
            return this;
        }

        public final WaitStartedDetails.Builder getWaitStartedDetails() {
            return waitStartedDetails != null ? waitStartedDetails.toBuilder() : null;
        }

        public final void setWaitStartedDetails(WaitStartedDetails.BuilderImpl waitStartedDetails) {
            this.waitStartedDetails = waitStartedDetails != null ? waitStartedDetails.build() : null;
        }

        @Override
        public final Builder waitStartedDetails(WaitStartedDetails waitStartedDetails) {
            this.waitStartedDetails = waitStartedDetails;
            return this;
        }

        public final WaitSucceededDetails.Builder getWaitSucceededDetails() {
            return waitSucceededDetails != null ? waitSucceededDetails.toBuilder() : null;
        }

        public final void setWaitSucceededDetails(WaitSucceededDetails.BuilderImpl waitSucceededDetails) {
            this.waitSucceededDetails = waitSucceededDetails != null ? waitSucceededDetails.build() : null;
        }

        @Override
        public final Builder waitSucceededDetails(WaitSucceededDetails waitSucceededDetails) {
            this.waitSucceededDetails = waitSucceededDetails;
            return this;
        }

        public final WaitCancelledDetails.Builder getWaitCancelledDetails() {
            return waitCancelledDetails != null ? waitCancelledDetails.toBuilder() : null;
        }

        public final void setWaitCancelledDetails(WaitCancelledDetails.BuilderImpl waitCancelledDetails) {
            this.waitCancelledDetails = waitCancelledDetails != null ? waitCancelledDetails.build() : null;
        }

        @Override
        public final Builder waitCancelledDetails(WaitCancelledDetails waitCancelledDetails) {
            this.waitCancelledDetails = waitCancelledDetails;
            return this;
        }

        public final StepStartedDetails.Builder getStepStartedDetails() {
            return stepStartedDetails != null ? stepStartedDetails.toBuilder() : null;
        }

        public final void setStepStartedDetails(StepStartedDetails.BuilderImpl stepStartedDetails) {
            this.stepStartedDetails = stepStartedDetails != null ? stepStartedDetails.build() : null;
        }

        @Override
        public final Builder stepStartedDetails(StepStartedDetails stepStartedDetails) {
            this.stepStartedDetails = stepStartedDetails;
            return this;
        }

        public final StepSucceededDetails.Builder getStepSucceededDetails() {
            return stepSucceededDetails != null ? stepSucceededDetails.toBuilder() : null;
        }

        public final void setStepSucceededDetails(StepSucceededDetails.BuilderImpl stepSucceededDetails) {
            this.stepSucceededDetails = stepSucceededDetails != null ? stepSucceededDetails.build() : null;
        }

        @Override
        public final Builder stepSucceededDetails(StepSucceededDetails stepSucceededDetails) {
            this.stepSucceededDetails = stepSucceededDetails;
            return this;
        }

        public final StepFailedDetails.Builder getStepFailedDetails() {
            return stepFailedDetails != null ? stepFailedDetails.toBuilder() : null;
        }

        public final void setStepFailedDetails(StepFailedDetails.BuilderImpl stepFailedDetails) {
            this.stepFailedDetails = stepFailedDetails != null ? stepFailedDetails.build() : null;
        }

        @Override
        public final Builder stepFailedDetails(StepFailedDetails stepFailedDetails) {
            this.stepFailedDetails = stepFailedDetails;
            return this;
        }

        public final ChainedInvokeStartedDetails.Builder getChainedInvokeStartedDetails() {
            return chainedInvokeStartedDetails != null ? chainedInvokeStartedDetails.toBuilder() : null;
        }

        public final void setChainedInvokeStartedDetails(ChainedInvokeStartedDetails.BuilderImpl chainedInvokeStartedDetails) {
            this.chainedInvokeStartedDetails = chainedInvokeStartedDetails != null ? chainedInvokeStartedDetails.build() : null;
        }

        @Override
        public final Builder chainedInvokeStartedDetails(ChainedInvokeStartedDetails chainedInvokeStartedDetails) {
            this.chainedInvokeStartedDetails = chainedInvokeStartedDetails;
            return this;
        }

        public final ChainedInvokeSucceededDetails.Builder getChainedInvokeSucceededDetails() {
            return chainedInvokeSucceededDetails != null ? chainedInvokeSucceededDetails.toBuilder() : null;
        }

        public final void setChainedInvokeSucceededDetails(ChainedInvokeSucceededDetails.BuilderImpl chainedInvokeSucceededDetails) {
            this.chainedInvokeSucceededDetails = chainedInvokeSucceededDetails != null ? chainedInvokeSucceededDetails.build()
                    : null;
        }

        @Override
        public final Builder chainedInvokeSucceededDetails(ChainedInvokeSucceededDetails chainedInvokeSucceededDetails) {
            this.chainedInvokeSucceededDetails = chainedInvokeSucceededDetails;
            return this;
        }

        public final ChainedInvokeFailedDetails.Builder getChainedInvokeFailedDetails() {
            return chainedInvokeFailedDetails != null ? chainedInvokeFailedDetails.toBuilder() : null;
        }

        public final void setChainedInvokeFailedDetails(ChainedInvokeFailedDetails.BuilderImpl chainedInvokeFailedDetails) {
            this.chainedInvokeFailedDetails = chainedInvokeFailedDetails != null ? chainedInvokeFailedDetails.build() : null;
        }

        @Override
        public final Builder chainedInvokeFailedDetails(ChainedInvokeFailedDetails chainedInvokeFailedDetails) {
            this.chainedInvokeFailedDetails = chainedInvokeFailedDetails;
            return this;
        }

        public final ChainedInvokeTimedOutDetails.Builder getChainedInvokeTimedOutDetails() {
            return chainedInvokeTimedOutDetails != null ? chainedInvokeTimedOutDetails.toBuilder() : null;
        }

        public final void setChainedInvokeTimedOutDetails(ChainedInvokeTimedOutDetails.BuilderImpl chainedInvokeTimedOutDetails) {
            this.chainedInvokeTimedOutDetails = chainedInvokeTimedOutDetails != null ? chainedInvokeTimedOutDetails.build()
                    : null;
        }

        @Override
        public final Builder chainedInvokeTimedOutDetails(ChainedInvokeTimedOutDetails chainedInvokeTimedOutDetails) {
            this.chainedInvokeTimedOutDetails = chainedInvokeTimedOutDetails;
            return this;
        }

        public final ChainedInvokeStoppedDetails.Builder getChainedInvokeStoppedDetails() {
            return chainedInvokeStoppedDetails != null ? chainedInvokeStoppedDetails.toBuilder() : null;
        }

        public final void setChainedInvokeStoppedDetails(ChainedInvokeStoppedDetails.BuilderImpl chainedInvokeStoppedDetails) {
            this.chainedInvokeStoppedDetails = chainedInvokeStoppedDetails != null ? chainedInvokeStoppedDetails.build() : null;
        }

        @Override
        public final Builder chainedInvokeStoppedDetails(ChainedInvokeStoppedDetails chainedInvokeStoppedDetails) {
            this.chainedInvokeStoppedDetails = chainedInvokeStoppedDetails;
            return this;
        }

        public final CallbackStartedDetails.Builder getCallbackStartedDetails() {
            return callbackStartedDetails != null ? callbackStartedDetails.toBuilder() : null;
        }

        public final void setCallbackStartedDetails(CallbackStartedDetails.BuilderImpl callbackStartedDetails) {
            this.callbackStartedDetails = callbackStartedDetails != null ? callbackStartedDetails.build() : null;
        }

        @Override
        public final Builder callbackStartedDetails(CallbackStartedDetails callbackStartedDetails) {
            this.callbackStartedDetails = callbackStartedDetails;
            return this;
        }

        public final CallbackSucceededDetails.Builder getCallbackSucceededDetails() {
            return callbackSucceededDetails != null ? callbackSucceededDetails.toBuilder() : null;
        }

        public final void setCallbackSucceededDetails(CallbackSucceededDetails.BuilderImpl callbackSucceededDetails) {
            this.callbackSucceededDetails = callbackSucceededDetails != null ? callbackSucceededDetails.build() : null;
        }

        @Override
        public final Builder callbackSucceededDetails(CallbackSucceededDetails callbackSucceededDetails) {
            this.callbackSucceededDetails = callbackSucceededDetails;
            return this;
        }

        public final CallbackFailedDetails.Builder getCallbackFailedDetails() {
            return callbackFailedDetails != null ? callbackFailedDetails.toBuilder() : null;
        }

        public final void setCallbackFailedDetails(CallbackFailedDetails.BuilderImpl callbackFailedDetails) {
            this.callbackFailedDetails = callbackFailedDetails != null ? callbackFailedDetails.build() : null;
        }

        @Override
        public final Builder callbackFailedDetails(CallbackFailedDetails callbackFailedDetails) {
            this.callbackFailedDetails = callbackFailedDetails;
            return this;
        }

        public final CallbackTimedOutDetails.Builder getCallbackTimedOutDetails() {
            return callbackTimedOutDetails != null ? callbackTimedOutDetails.toBuilder() : null;
        }

        public final void setCallbackTimedOutDetails(CallbackTimedOutDetails.BuilderImpl callbackTimedOutDetails) {
            this.callbackTimedOutDetails = callbackTimedOutDetails != null ? callbackTimedOutDetails.build() : null;
        }

        @Override
        public final Builder callbackTimedOutDetails(CallbackTimedOutDetails callbackTimedOutDetails) {
            this.callbackTimedOutDetails = callbackTimedOutDetails;
            return this;
        }

        public final InvocationCompletedDetails.Builder getInvocationCompletedDetails() {
            return invocationCompletedDetails != null ? invocationCompletedDetails.toBuilder() : null;
        }

        public final void setInvocationCompletedDetails(InvocationCompletedDetails.BuilderImpl invocationCompletedDetails) {
            this.invocationCompletedDetails = invocationCompletedDetails != null ? invocationCompletedDetails.build() : null;
        }

        @Override
        public final Builder invocationCompletedDetails(InvocationCompletedDetails invocationCompletedDetails) {
            this.invocationCompletedDetails = invocationCompletedDetails;
            return this;
        }

        @Override
        public Event build() {
            return new Event(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
