/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a durable execution context.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContextDetails implements SdkPojo, Serializable, ToCopyableBuilder<ContextDetails.Builder, ContextDetails> {
    private static final SdkField<Boolean> REPLAY_CHILDREN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReplayChildren").getter(getter(ContextDetails::replayChildren)).setter(setter(Builder::replayChildren))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayChildren").build()).build();

    private static final SdkField<String> RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Result")
            .getter(getter(ContextDetails::result)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()).build();

    private static final SdkField<ErrorObject> ERROR_FIELD = SdkField.<ErrorObject> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(ContextDetails::error)).setter(setter(Builder::error))
            .constructor(ErrorObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLAY_CHILDREN_FIELD,
            RESULT_FIELD, ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean replayChildren;

    private final String result;

    private final ErrorObject error;

    private ContextDetails(BuilderImpl builder) {
        this.replayChildren = builder.replayChildren;
        this.result = builder.result;
        this.error = builder.error;
    }

    /**
     * <p>
     * Whether the state data of child operations of this completed context should be included in the invoke payload and
     * <code>GetDurableExecutionState</code> response.
     * </p>
     * 
     * @return Whether the state data of child operations of this completed context should be included in the invoke
     *         payload and <code>GetDurableExecutionState</code> response.
     */
    public final Boolean replayChildren() {
        return replayChildren;
    }

    /**
     * <p>
     * The response payload from the context.
     * </p>
     * 
     * @return The response payload from the context.
     */
    public final String result() {
        return result;
    }

    /**
     * <p>
     * Details about the context failure.
     * </p>
     * 
     * @return Details about the context failure.
     */
    public final ErrorObject error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replayChildren());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContextDetails)) {
            return false;
        }
        ContextDetails other = (ContextDetails) obj;
        return Objects.equals(replayChildren(), other.replayChildren()) && Objects.equals(result(), other.result())
                && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContextDetails").add("ReplayChildren", replayChildren())
                .add("Result", result() == null ? null : "*** Sensitive Data Redacted ***").add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplayChildren":
            return Optional.ofNullable(clazz.cast(replayChildren()));
        case "Result":
            return Optional.ofNullable(clazz.cast(result()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplayChildren", REPLAY_CHILDREN_FIELD);
        map.put("Result", RESULT_FIELD);
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContextDetails, T> g) {
        return obj -> g.apply((ContextDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContextDetails> {
        /**
         * <p>
         * Whether the state data of child operations of this completed context should be included in the invoke payload
         * and <code>GetDurableExecutionState</code> response.
         * </p>
         * 
         * @param replayChildren
         *        Whether the state data of child operations of this completed context should be included in the invoke
         *        payload and <code>GetDurableExecutionState</code> response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replayChildren(Boolean replayChildren);

        /**
         * <p>
         * The response payload from the context.
         * </p>
         * 
         * @param result
         *        The response payload from the context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(String result);

        /**
         * <p>
         * Details about the context failure.
         * </p>
         * 
         * @param error
         *        Details about the context failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorObject error);

        /**
         * <p>
         * Details about the context failure.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorObject.Builder} avoiding the need to
         * create one manually via {@link ErrorObject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorObject.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorObject)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorObject)
         */
        default Builder error(Consumer<ErrorObject.Builder> error) {
            return error(ErrorObject.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean replayChildren;

        private String result;

        private ErrorObject error;

        private BuilderImpl() {
        }

        private BuilderImpl(ContextDetails model) {
            replayChildren(model.replayChildren);
            result(model.result);
            error(model.error);
        }

        public final Boolean getReplayChildren() {
            return replayChildren;
        }

        public final void setReplayChildren(Boolean replayChildren) {
            this.replayChildren = replayChildren;
        }

        @Override
        public final Builder replayChildren(Boolean replayChildren) {
            this.replayChildren = replayChildren;
            return this;
        }

        public final String getResult() {
            return result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        public final ErrorObject.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorObject.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorObject error) {
            this.error = error;
            return this;
        }

        @Override
        public ContextDetails build() {
            return new ContextDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
