/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.CapacityProviderScalingMode;
import software.amazon.awssdk.services.lambda.model.CapacityProviderScalingPoliciesListCopier;
import software.amazon.awssdk.services.lambda.model.TargetTrackingScalingPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityProviderScalingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityProviderScalingConfig> {
    private static final SdkField<Integer> MAX_V_CPU_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxVCpuCount").getter(CapacityProviderScalingConfig.getter(CapacityProviderScalingConfig::maxVCpuCount)).setter(CapacityProviderScalingConfig.setter(Builder::maxVCpuCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxVCpuCount").build()}).build();
    private static final SdkField<String> SCALING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalingMode").getter(CapacityProviderScalingConfig.getter(CapacityProviderScalingConfig::scalingModeAsString)).setter(CapacityProviderScalingConfig.setter(Builder::scalingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingMode").build()}).build();
    private static final SdkField<List<TargetTrackingScalingPolicy>> SCALING_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScalingPolicies").getter(CapacityProviderScalingConfig.getter(CapacityProviderScalingConfig::scalingPolicies)).setter(CapacityProviderScalingConfig.setter(Builder::scalingPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetTrackingScalingPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_V_CPU_COUNT_FIELD, SCALING_MODE_FIELD, SCALING_POLICIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapacityProviderScalingConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer maxVCpuCount;
    private final String scalingMode;
    private final List<TargetTrackingScalingPolicy> scalingPolicies;

    private CapacityProviderScalingConfig(BuilderImpl builder) {
        this.maxVCpuCount = builder.maxVCpuCount;
        this.scalingMode = builder.scalingMode;
        this.scalingPolicies = builder.scalingPolicies;
    }

    public final Integer maxVCpuCount() {
        return this.maxVCpuCount;
    }

    public final CapacityProviderScalingMode scalingMode() {
        return CapacityProviderScalingMode.fromValue(this.scalingMode);
    }

    public final String scalingModeAsString() {
        return this.scalingMode;
    }

    public final boolean hasScalingPolicies() {
        return this.scalingPolicies != null && !(this.scalingPolicies instanceof SdkAutoConstructList);
    }

    public final List<TargetTrackingScalingPolicy> scalingPolicies() {
        return this.scalingPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxVCpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScalingPolicies() ? this.scalingPolicies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityProviderScalingConfig)) {
            return false;
        }
        CapacityProviderScalingConfig other = (CapacityProviderScalingConfig)obj;
        return Objects.equals(this.maxVCpuCount(), other.maxVCpuCount()) && Objects.equals(this.scalingModeAsString(), other.scalingModeAsString()) && this.hasScalingPolicies() == other.hasScalingPolicies() && Objects.equals(this.scalingPolicies(), other.scalingPolicies());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityProviderScalingConfig").add("MaxVCpuCount", (Object)this.maxVCpuCount()).add("ScalingMode", (Object)this.scalingModeAsString()).add("ScalingPolicies", this.hasScalingPolicies() ? this.scalingPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxVCpuCount": {
                return Optional.ofNullable(clazz.cast(this.maxVCpuCount()));
            }
            case "ScalingMode": {
                return Optional.ofNullable(clazz.cast(this.scalingModeAsString()));
            }
            case "ScalingPolicies": {
                return Optional.ofNullable(clazz.cast(this.scalingPolicies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MaxVCpuCount", MAX_V_CPU_COUNT_FIELD);
        map.put("ScalingMode", SCALING_MODE_FIELD);
        map.put("ScalingPolicies", SCALING_POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityProviderScalingConfig, T> g) {
        return obj -> g.apply((CapacityProviderScalingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxVCpuCount;
        private String scalingMode;
        private List<TargetTrackingScalingPolicy> scalingPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityProviderScalingConfig model) {
            this.maxVCpuCount(model.maxVCpuCount);
            this.scalingMode(model.scalingMode);
            this.scalingPolicies(model.scalingPolicies);
        }

        public final Integer getMaxVCpuCount() {
            return this.maxVCpuCount;
        }

        public final void setMaxVCpuCount(Integer maxVCpuCount) {
            this.maxVCpuCount = maxVCpuCount;
        }

        @Override
        public final Builder maxVCpuCount(Integer maxVCpuCount) {
            this.maxVCpuCount = maxVCpuCount;
            return this;
        }

        public final String getScalingMode() {
            return this.scalingMode;
        }

        public final void setScalingMode(String scalingMode) {
            this.scalingMode = scalingMode;
        }

        @Override
        public final Builder scalingMode(String scalingMode) {
            this.scalingMode = scalingMode;
            return this;
        }

        @Override
        public final Builder scalingMode(CapacityProviderScalingMode scalingMode) {
            this.scalingMode(scalingMode == null ? null : scalingMode.toString());
            return this;
        }

        public final List<TargetTrackingScalingPolicy.Builder> getScalingPolicies() {
            List<TargetTrackingScalingPolicy.Builder> result = CapacityProviderScalingPoliciesListCopier.copyToBuilder(this.scalingPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScalingPolicies(Collection<TargetTrackingScalingPolicy.BuilderImpl> scalingPolicies) {
            this.scalingPolicies = CapacityProviderScalingPoliciesListCopier.copyFromBuilder(scalingPolicies);
        }

        @Override
        public final Builder scalingPolicies(Collection<TargetTrackingScalingPolicy> scalingPolicies) {
            this.scalingPolicies = CapacityProviderScalingPoliciesListCopier.copy(scalingPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(TargetTrackingScalingPolicy ... scalingPolicies) {
            this.scalingPolicies(Arrays.asList(scalingPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(Consumer<TargetTrackingScalingPolicy.Builder> ... scalingPolicies) {
            this.scalingPolicies(Stream.of(scalingPolicies).map(c -> (TargetTrackingScalingPolicy)((TargetTrackingScalingPolicy.Builder)TargetTrackingScalingPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CapacityProviderScalingConfig build() {
            return new CapacityProviderScalingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityProviderScalingConfig> {
        public Builder maxVCpuCount(Integer var1);

        public Builder scalingMode(String var1);

        public Builder scalingMode(CapacityProviderScalingMode var1);

        public Builder scalingPolicies(Collection<TargetTrackingScalingPolicy> var1);

        public Builder scalingPolicies(TargetTrackingScalingPolicy ... var1);

        public Builder scalingPolicies(Consumer<TargetTrackingScalingPolicy.Builder> ... var1);
    }
}

