/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains trace headers for the Lambda durable execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TraceHeader implements SdkPojo, Serializable, ToCopyableBuilder<TraceHeader.Builder, TraceHeader> {
    private static final SdkField<String> X_AMZN_TRACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("XAmznTraceId").getter(getter(TraceHeader::xAmznTraceId)).setter(setter(Builder::xAmznTraceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAmznTraceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(X_AMZN_TRACE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String xAmznTraceId;

    private TraceHeader(BuilderImpl builder) {
        this.xAmznTraceId = builder.xAmznTraceId;
    }

    /**
     * <p>
     * The X-Ray trace header associated with the durable execution.
     * </p>
     * 
     * @return The X-Ray trace header associated with the durable execution.
     */
    public final String xAmznTraceId() {
        return xAmznTraceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(xAmznTraceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TraceHeader)) {
            return false;
        }
        TraceHeader other = (TraceHeader) obj;
        return Objects.equals(xAmznTraceId(), other.xAmznTraceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TraceHeader").add("XAmznTraceId", xAmznTraceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "XAmznTraceId":
            return Optional.ofNullable(clazz.cast(xAmznTraceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("XAmznTraceId", X_AMZN_TRACE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TraceHeader, T> g) {
        return obj -> g.apply((TraceHeader) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TraceHeader> {
        /**
         * <p>
         * The X-Ray trace header associated with the durable execution.
         * </p>
         * 
         * @param xAmznTraceId
         *        The X-Ray trace header associated with the durable execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xAmznTraceId(String xAmznTraceId);
    }

    static final class BuilderImpl implements Builder {
        private String xAmznTraceId;

        private BuilderImpl() {
        }

        private BuilderImpl(TraceHeader model) {
            xAmznTraceId(model.xAmznTraceId);
        }

        public final String getXAmznTraceId() {
            return xAmznTraceId;
        }

        public final void setXAmznTraceId(String xAmznTraceId) {
            this.xAmznTraceId = xAmznTraceId;
        }

        @Override
        public final Builder xAmznTraceId(String xAmznTraceId) {
            this.xAmznTraceId = xAmznTraceId;
            return this;
        }

        @Override
        public TraceHeader build() {
            return new TraceHeader(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
